
#include "core/jobs/changeUser.h"
#include "core/profileApp.h"
#include "core/configInterface.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/changeUser.cpp.trc.h"
#endif

namespace profileMngr {

ChangeUserJob::ChangeUserJob(uintptr_t act,uint8_t newUser,uint8_t oldUser,uint32_t numClients,ProfileAppIF & IF,bool bPrepareData):Job(act,numClients),m_NewUser(newUser),m_OldUser(oldUser),m_IF(IF)
{
	if (bPrepareData==true)
		m_State=Initializing;
	else
		m_State=skipPrepare;
	if (newUser==oldUser)//used for login on system startup
		m_State=Done;
}

void ChangeUserJob::updateStatus(ClientStatusUpdate & status,uint32_t clientID)
{
	if (clientID >= m_NumClients)
		return;
	switch (m_State)
	{
	case Preparing:
		if (status ==csuPrepareChange || status == csuFailed)
			setStatus(status,clientID);
		break;
	case Changing:
		if (status ==csuUserChanged  || status == csuFailed)
			setStatus(status,clientID);
		break;
	case RecoverFromError:
		if (status == csuUserChanged||status == csuFailed)
			setStatus(status,clientID);
	}

}

bool ChangeUserJob::stateFunction()
{
	bool bSuccess=true;
	switch (m_State)
		{
		case Initializing:
			if (configIF::getInst().isProfileChangeAllowed(m_NewUser,m_OldUser)==false)
				{
					m_Result=asDenied;
					ETG_TRACE_FATAL(("Profile Change Denied"));
					finish();
					return false;
				}
				m_State=Preparing;
				sendPrepare();
				return true;
			break;
		case Preparing:
				if (m_ClientsOpen!=0)
					return false;
				for (int k=0;k < m_NumClients;++k)
					if (m_aClientStatus[k]!= csuPrepareChange)
					{
						ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
						bSuccess=false;
					}
				if (bSuccess)
					bSuccess=change(newUser());
				if (bSuccess)
					m_State=Changing;
				else
				{m_Result=asFailed;finish();return false;}
				return true;
			break;
		case skipPrepare:
			if (configIF::getInst().isProfileChangeAllowed(m_NewUser,m_OldUser)==false)
			{
				m_Result=asDenied;
				ETG_TRACE_FATAL(("Profile Change Denied"));
				return false;
			}
			bSuccess=change(newUser());
			if (bSuccess)
				m_State=Changing;
			else
				{m_Result=asFailed;finish();return false;}
			return true;
			break;
		case Changing:
			if (m_ClientsOpen!=0)
				return false;
			for (int k=0;k < m_NumClients;++k)
				if (m_aClientStatus[k]!= csuUserChanged)
				{
					ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
					bSuccess=false;
				}
			if (bSuccess)
			  {
					m_State=Done;
					finish();
			  }
			else
			  {
				ETG_TRACE_COMP(("Failure of the changing "));

				//setState as Idle
				m_IF.sendDataUpdate(dsIdle);
				bSuccess=change(oldUser());
				if(bSuccess)
				{
				   ETG_TRACE_COMP(("State changed RecoverFromError "));
				   m_State=RecoverFromError;
				   return true;
				}
				else
				   {
					 ETG_TRACE_COMP(("State changed error RecoverFromError "));
					 m_Result=asFailed;finish();
				   }
			}
			return false;
		case RecoverFromError:
		{
			ETG_TRACE_COMP(("RecoverFromError"));

		     if (m_ClientsOpen!=0)
		    		return false;


		    for (int k=0;k < m_NumClients;++k)
			    if (m_aClientStatus[k]!= csuUserChanged)
			     {
					ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
					bSuccess=false;
			      }
		   // here irrespective of the  bSucsess is true or false sending failed to HMI as it is just the
		   // recovery from the error but datachange process has already been failed by this time

			 m_State=Done;
			 m_Result=asFailed;
			 finish();

			 return false; //end now

			break;
		}
		}
	return false;
}

void ChangeUserJob::sendPrepare()
{
	m_IF.sendProfileStatus(psLoading);
	m_IF.sendDataUpdate(dsPrepare);
}

bool ChangeUserJob::change(uint8_t userId)
{
	reset();
	if (m_IF.lockDP()!=true)
		return false;
	if(m_IF.setDPUser(newUser()))
	{
		m_IF.unlockDP();
		m_IF.loadUser(userId);
		m_IF.sendDataUpdate(dsChanged);
	}
	else
		{m_Result=asFailed;m_IF.unlockDP();return false;}

	return true;
}

void ChangeUserJob::finish()
{
	if (m_State!= Done && m_Result==asSuccess)
		m_Result=asFailed;
	ETG_TRACE_COMP(("changeUserJob::Finish %u",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result)));

	if (m_Result==asSuccess)
	{
		//check if valet mode is there,disable it
		if(m_IF.getData().getValetModeStatus()==true && m_IF.getData().getProfileStatus()[m_NewUser]==usProtectedPin)
			m_IF.getData().setValetModeStatus(false);
     }

	m_IF.sendProfileStatus(psUnlocked);
	m_IF.sendDataUpdate(dsIdle);

	if (m_pRequester)
		m_pRequester->sendChangeProfileResult(m_Act,m_Result);
	m_pRequester=0;//make sure, result message is only sent once otherwise ASF reset
	if(asSuccess == m_Result)
		configIF::getInst().changeToProfileCompetionStatus(m_Result,m_OldUser,m_NewUser);
}

void ChangeUserJob::HandleTimerExpired()
{
	if (m_State== Changing && m_Result==asSuccess)
	{
		ETG_TRACE_COMP(("HandleTimerExpired"));
		m_ClientsOpen=0;
		do 	{} while (stateFunction()==true);
	}
	else
	  finish();
}



}
