#include "ServiceProfileMngrDBUS.h"

#include "core/profileApp.h"
#include <sstream>

#include "asfComp/app/core/ProfileMngrComp.h"

namespace app { namespace core {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::bosch::cm::profile;
using namespace profileMngr;

unsigned int ServerProfileMngrDBUS::m_NextAppID =1;

DEFINE_CLASS_LOGGER_AND_LEVEL("app/core/ServerProfileMngrDBUS", ServerProfileMngrDBUS, Info);

serverResult ServerProfileMngrDBUS::mapAsResult(profileMngr::actionState result)
{
	switch (result)
	{
		case profileMngr::asFailed:return serverResult__FAILED;
		case profileMngr::asSuccess:return serverResult__SUCCESS;
		case profileMngr::asPending:return serverResult__ONGOING;
		case profileMngr::asLocked:return serverResult__PROFILE_BLOCKED;
		case profileMngr::asInitializing:return serverResult__INTIALIZING;
		case profileMngr::asFileError:return serverResult__IMAGE_FILE_ERROR;
		case profileMngr::asDenied:return serverResult__ACCESS_DENIED;
		case profileMngr::asDeniedWaiting: return serverResult__DENIED_WAITING;
		case profileMngr::asDeniedDelayed: return serverResult__DENIED_DELAYED;
		case profileMngr::asCancelled: return serverResult__CANCELLED;

		default:return serverResult__FAILED;
	}
}


void ServerProfileMngrDBUS::updateProfileID()
{
	 setActiveProfile(m_Data.currentProfile());
}

void ServerProfileMngrDBUS::updateProfileStatus()
{
	switch (m_Data.getAppState())
	{
		case profileMngr::psInitalize:setStatus(ProfileStatus__INITIALIZING);break;
		case profileMngr::psLoading:setStatus(ProfileStatus__LOADING);break;
		case profileMngr::psLocked:setStatus(ProfileStatus__LOCKED);break;
		case profileMngr::psUnlocked:setStatus(ProfileStatus__UNLOCKED);break;
		case profileMngr::psValetMode:setStatus(ProfileStatus__VALET_MODE);break;
	}
}

void ServerProfileMngrDBUS::sendCreateProfileResult(uintptr_t act,actionState result)
{
		unsigned char newUserID = ((result == profileMngr::asSuccess)?(getCreateProfile()):(0));
		sendDoCreateProfileResponse(mapAsResult(result),newUserID,act);
}

void ServerProfileMngrDBUS::senddoImportImageResult(uintptr_t act,profileMngr::actionState result)
{
	sendDoImportProfileImageResponse(mapAsResult(result),act);
}

void ServerProfileMngrDBUS::sendDeleteProfileResult(uintptr_t act, profileMngr::actionState result)
{
	sendDoDeleteProfileResponse(mapAsResult(result),act);
}

void ServerProfileMngrDBUS::sendCopyProfileResult(uintptr_t act, profileMngr::actionState result)
{
	sendDoCopyProfileResponse(mapAsResult(result),act);
}
void ServerProfileMngrDBUS::sendRemoveUserImageResult(uintptr_t act,profileMngr::actionState result)
{
	sendRemoveUserImageResponse(mapAsResult(result),act);
}
void ServerProfileMngrDBUS::sendSetValetModeResult(uintptr_t act,profileMngr::actionState result)
{
	sendSetValetModeResponse(mapAsResult(result),act);
}

void ServerProfileMngrDBUS::sendCopyProfile(unsigned char Source,unsigned char Dest)
{
	 copyInfo ci(Source,Dest);
	 setCopyProfile(ci);
}
void ServerProfileMngrDBUS::sendDeleteProfile(unsigned char User)
{
	 setDeleteProfile(User);
}

void ServerProfileMngrDBUS::sendCreateProfile(unsigned char User)
{
	 setCreateProfile(User);
}

void ServerProfileMngrDBUS::updateProfileImage()
{
	 setProfileImage(m_Data.getImage());
}

void ServerProfileMngrDBUS::updateProfileName()
{
	 setProfileName(m_Data.getName());
}

void ServerProfileMngrDBUS::updateActiveProfileType()
{
	profileType iActiveProfileType;

	switch(m_Data.getStatus())
	{
			case profileMngr::usEmpty:
				iActiveProfileType=profileType__EMPTY;break;
			case profileMngr::usGuest:
				iActiveProfileType=profileType__GUEST;break;
			case profileMngr::usNormal:
				iActiveProfileType=profileType__NORMAL;break;
			case profileMngr::usProtectedPin:
			case profileMngr::usProtectedRemember:
				iActiveProfileType=profileType__PROTECTED;break;
			case profileMngr::usLinkedPin:
			case profileMngr::usLinkedRemember:
				iActiveProfileType=profileType__LINKED;break;
			case profileMngr::usBlocked:
			default:
				iActiveProfileType=profileType__BLOCKED;break;
	}
	setActiveProfileType(iActiveProfileType);
}
void ServerProfileMngrDBUS::sendDataUpdate(profileMngr::dataChangeStatus state)
{
	switch (state)
	{
		case dsPrepare:setDataChanged(dataChangeReason__PREPARE);break;
		case dsChanged:setDataChanged(dataChangeReason__PROFILE_CHANGED);break;
		case dsIdle:setDataChanged(dataChangeReason__IDLE);break;
		case dsProfileReset:setDataChanged(dataChangeReason__PROFILE_RESET);break;
	}
}

void ServerProfileMngrDBUS::updatePinRequested()
{
	setPinRequested(m_Data.getPinRequest());
}

void ServerProfileMngrDBUS::updatePrivacyMode()
{
	setPrivacyMode(m_Data.getPrivacyMode());
}

void ServerProfileMngrDBUS::sendChangeProfileResult(uintptr_t act,profileMngr::actionState result)
{
		switch (result)
		{
		case profileMngr::asFailed:sendDoChangeToProfileResponse(serverResult__FAILED,act);break;
		case profileMngr::asSuccess:sendDoChangeToProfileResponse(serverResult__SUCCESS,act);break;
		}//TODO missing enums
}


profileMngr::enInterfaceID ServerProfileMngrDBUS::getInterface()
{
	return profileMngr::iidDBUS;
}

ServerProfileMngrDBUS::ServerProfileMngrDBUS(profileMngr::ProfileAppIF & IF) : ProfileStub("profileMngrDBUSPort")
,m_Data(IF.getData())
{

	ProfileApp::getInst().AddInterface(this);
	tU8 user=m_Data.currentProfile();
	setActiveProfile(user);
	setProfileName(m_Data.getName());
	setProfileImage(m_Data.getImage());
	setPinRequested(m_Data.getPinRequest());
	updateProfileStatus();
	setPinAuthenticationDelayTime(m_Data.getPINAuthenticationDelay());
	setMaxPINAttemptsBeforeDelay(m_Data.getMaxPINAttemptsBeforeDelay());
	setMaxPINAttempts(m_Data.getMaxPINAttemptsTotal());
	setPinVerificationValidityTime(m_Data.getPinVerificationValidity());
	updateActiveProfileType();
}

ServerProfileMngrDBUS::~ServerProfileMngrDBUS()
{

}

void ServerProfileMngrDBUS::onDoRegisterAppRequest (const ::boost::shared_ptr< DoRegisterAppRequest >& request)
{
	std::ostringstream s;
	s << "ASF:" << request->getAppName();
	std::string str(s.str());
	uint32_t appID= ProfileApp::getInst().onNewClient(str);
	sendDoRegisterAppResponse(appID,request->getAppName(),m_Data.getStartupUserChange());
}

void ServerProfileMngrDBUS::onOnDataChangedRequest (const ::boost::shared_ptr< OnDataChangedRequest >& request)
{
	ClientStatusUpdate upd=csuFailed;
	switch (request->getResult())
	{
		case dataChangedResult__PREPARED:upd=csuPrepareChange;break;
		case dataChangedResult__PROFILE_CHANGED:upd=csuUserChanged;break;
	}
	ProfileApp::getInst().onClientStatus(request->getApplicationPID(),upd);
}

void ServerProfileMngrDBUS::onOnProfileDeletedRequest (const ::boost::shared_ptr< OnProfileDeletedRequest >& request)
{
	ClientStatusUpdate upd=csuUserDeleted;
		if (request->getResult()== clientResult__FAILED)
			upd=csuFailed;
   	ProfileApp::getInst().onClientStatus(request->getApplicationPID(),upd);
}

void ServerProfileMngrDBUS::onOnProfileCopiedRequest(const ::boost::shared_ptr<OnProfileCopiedRequest>& request)
{
	ClientStatusUpdate upd=csuUserCopied;
			if (request->getResult()== clientResult__FAILED)
				upd=csuFailed;
	   	ProfileApp::getInst().onClientStatus(request->getApplicationPID(),upd);
}

void ServerProfileMngrDBUS::onOnProfileCreatedRequest (const ::boost::shared_ptr< OnProfileCreatedRequest >& request)
{
	ClientStatusUpdate upd=csuUserCreated;
			if (request->getResult()== clientResult__FAILED)
				upd=csuFailed;
	   	ProfileApp::getInst().onClientStatus(request->getApplicationPID(),upd);
}

void ServerProfileMngrDBUS::onDoDeleteProfileRequest(const ::boost::shared_ptr<DoDeleteProfileRequest>& request)
{
	profileMngr::actionState res=profileMngr::asLocked;
		res=profileMngr::ProfileApp::getInst().doDeleteProfile(*this,request->getAct(),request->getUserID());
	if (res== profileMngr::asPending || res==profileMngr::asInitializing)
	    sendDoDeleteProfileResponse(mapAsResult(res));
}

void ServerProfileMngrDBUS::onDoChangeToProfileRequest(	const ::boost::shared_ptr<DoChangeToProfileRequest>& request)
{
	profileMngr::actionState res=profileMngr::ProfileApp::getInst().doSwitchToProfile(this,request->getAct(),request->getUserID());
	if (res != profileMngr::asSuccess)
		sendDoChangeToProfileResponse(mapAsResult(res));
}

void ServerProfileMngrDBUS::onDoCopyProfileRequest(	const ::boost::shared_ptr<DoCopyProfileRequest>& request)
{
	profileMngr::actionState res=profileMngr::ProfileApp::getInst().doCopyProfile(*this,request->getAct(),request->getSourceUserID(),request->getDestUserID());
	if (res == profileMngr::asPending || res==profileMngr::asInitializing)
		sendDoCopyProfileResponse(mapAsResult(res));
}

void ServerProfileMngrDBUS::onDoCreateProfileRequest (const ::boost::shared_ptr< DoCreateProfileRequest >& request)
{
	profileMngr::actionState res=profileMngr::ProfileApp::getInst().doCreateProfile(*this,request->getAct(),request->getNewName(),request->getImageID());
	if (res == profileMngr::asPending || res==profileMngr::asInitializing)
		sendDoCreateProfileResponse(mapAsResult(res),0);
}

//New Interface as per pivi
void ServerProfileMngrDBUS::onDo_SetProfileNameRequest(const ::boost::shared_ptr<Do_SetProfileNameRequest>& request)
{
	sendDo_SetProfileNameResponse(mapAsResult(profileMngr::ProfileApp::getInst().setProfileName(request->getNewName(),request->getUserID())));
}

void ServerProfileMngrDBUS::onGetProfileNamesRequest(const ::boost::shared_ptr<GetProfileNamesRequest>& request)
{
	const std::vector<std::string>& names =profileMngr::ProfileApp::getInst().getProfileNames();
	sendGetProfileNamesResponse(names, request->getAct());
}


//New Interface as per pivi
void ServerProfileMngrDBUS::onDoSetProfileImageRequest(const ::boost::shared_ptr<DoSetProfileImageRequest>& request)
{
	sendDoSetProfileImageResponse(mapAsResult(profileMngr::ProfileApp::getInst().setProfileImage(request->getImageID(),request->getUserID())));
}


void ServerProfileMngrDBUS::onGetProfileImagesRequest(const ::boost::shared_ptr<GetProfileImagesRequest>& request)
{
    const std::vector<uint8>& imageList = profileMngr::ProfileApp::getInst().getProfileImages();
    sendGetProfileImagesResponse(imageList,request->getAct());
}

void ServerProfileMngrDBUS::onDoImportProfileImageRequest(const ::boost::shared_ptr<DoImportProfileImageRequest>& request)
{
	actionState as=ProfileApp::getInst().doLoadImage(*this,request->getAct(),request->getSourcePath(), request->getWidth(),request->getHeight(),request->getSlotIdx(),request->getBSetForCurrentProfile());
	if (as!= profileMngr::asSuccess)
		sendDoImportProfileImageResponse(mapAsResult(as));
}

void ServerProfileMngrDBUS::onRemoveUserImageRequest (const ::boost::shared_ptr< RemoveUserImageRequest >& request)
{
	sendRemoveUserImageResponse(mapAsResult(profileMngr::ProfileApp::getInst().doDeleteUserImage(request->getSlotIdx())));
}

void ServerProfileMngrDBUS::onPrivacyModeSet(const ::boost::shared_ptr< PrivacyModeSet >& payload)
{
	ProfileApp::getInst().setPrivacyMode(payload->getPrivacyMode());
}

void ServerProfileMngrDBUS::onMaxPINAttemptsSet(const ::boost::shared_ptr< MaxPINAttemptsSet >& payload)
{
	m_Data.setMaxPINAttemptsTotal(payload->getMaxPINAttempts());
	setMaxPINAttempts(m_Data.getMaxPINAttemptsTotal());
}
void ServerProfileMngrDBUS::onMaxPINAttemptsBeforeDelaySet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelaySet >& payload)
{
	m_Data.setMaxPINAttemptsBeforeDelay(payload->getMaxPINAttemptsBeforeDelay());
	setMaxPINAttemptsBeforeDelay(m_Data.getMaxPINAttemptsBeforeDelay());
}
void ServerProfileMngrDBUS::onPinAuthenticationDelayTimeSet(const ::boost::shared_ptr< PinAuthenticationDelayTimeSet >& payload)
{
	m_Data.setPINAuthenticationDelay(payload->getPinAuthenticationDelayTime());
	setPinAuthenticationDelayTime(m_Data.getPINAuthenticationDelay());
}
void ServerProfileMngrDBUS::onPinVerificationValidityTimeSet(const ::boost::shared_ptr< PinVerificationValidityTimeSet >& payload)
{
	m_Data.setPinVerificationValidity(payload->getPinVerificationValidityTime());
	setPinVerificationValidityTime(m_Data.getPinVerificationValidity());
}


void ServerProfileMngrDBUS::onSetProfilePinRequest(const boost::shared_ptr<bosch::cm::profile::SetProfilePinRequest>& req)
{
	sendSetProfilePinResponse(mapAsResult(ProfileApp::getInst().setProfilePin(req->getProfileID(), req->getPin()) ));
}
void ServerProfileMngrDBUS::onSetRememberMeRequest(const boost::shared_ptr<bosch::cm::profile::SetRememberMeRequest>& req)
{
	sendSetRememberMeResponse(mapAsResult(ProfileApp::getInst().setRememberMe(req->getProfileID())));
}
void ServerProfileMngrDBUS::onCheckPinRequest(const boost::shared_ptr<bosch::cm::profile::CheckPinRequest>& req)
{
	sendCheckPinResponse(mapAsResult(ProfileApp::getInst().checkPin(req->getProfileID(),req->getPIN())));
}
void ServerProfileMngrDBUS::onUnProtectProfileRequest(const boost::shared_ptr<bosch::cm::profile::UnProtectProfileRequest>& req)
{
	sendUnProtectProfileResponse(mapAsResult(ProfileApp::getInst().unprotectProfile(req->getProfileID())));
}



void ServerProfileMngrDBUS::mapProfileTypes(const std::vector<enUserStatus> & userProfileType, std::vector<profileType> & profileTypeList)
{
	profileTypeList.clear();
	for(std::vector<enUserStatus>::const_iterator typeIter = userProfileType.begin();typeIter != userProfileType.end();typeIter++)
	{
		switch(*typeIter)
		{
		case profileMngr::usEmpty:
			profileTypeList.push_back(profileType__EMPTY);break;
		case profileMngr::usGuest:
			profileTypeList.push_back(profileType__GUEST);break;
		case profileMngr::usNormal:
			profileTypeList.push_back(profileType__NORMAL);break;
		case profileMngr::usProtectedPin:
		case profileMngr::usProtectedRemember:
			profileTypeList.push_back(profileType__PROTECTED);break;
		case profileMngr::usLinkedPin:
		case profileMngr::usLinkedRemember:
			profileTypeList.push_back(profileType__LINKED);break;
		case profileMngr::usBlocked:
		default://make sure, the number of items matches the number of profiles
			profileTypeList.push_back(profileType__BLOCKED);break;


		}
	}
}

void ServerProfileMngrDBUS::onGetProfileTypesRequest (const ::boost::shared_ptr< GetProfileTypesRequest >& request)
{
	std::vector<profileType> profileTypesList;
	const std::vector<enUserStatus>& userProfileType = profileMngr::ProfileApp::getInst().getProfileTypes();
	mapProfileTypes(userProfileType,profileTypesList);
	sendGetProfileTypesResponse(profileTypesList,request->getAct());
}

 void ServerProfileMngrDBUS::onLinkProfileRequest (const ::boost::shared_ptr< LinkProfileRequest >& request)
 {
	 sendLinkProfileResponse(mapAsResult(ProfileApp::getInst().setlinkProfileStatus(request->getBSetLink())));
 }

 void ServerProfileMngrDBUS::onSetValetModeRequest (const ::boost::shared_ptr< SetValetModeRequest >& request)
{
	 profileMngr::actionState res=profileMngr::ProfileApp::getInst().setValetMode(*this,request->getAct(),request->getBEnableValetMode());
	 	if (res != profileMngr::asSuccess)
	 		sendSetValetModeResponse(mapAsResult(res));
}

}
}

