/*****************************************************************************
* FILE:         pmAsfComponent.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* DESCRIPTION:  ASF Main component class
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef __PM_pmAsfComponent_H
#define __PM_pmAsfComponent_H

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"



#include "cca/CCAAppMain.h"
class ServiceProfileMngrCCA;

namespace profileMngr{
class ProfileApp;
class configInterface;
}

namespace app { namespace core {
class ServerProfileMngrDBUS;
class ServiceProfileMngrSysSettings;

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::core;
    using namespace::app::core;

    typedef const char * cString;


    class ProfileMngrComp : public BaseComponent
    {
    private:
    	bool loadConfig(cString File);

        ServerProfileMngrDBUS *m_pDBusServer;
        ServiceProfileMngrSysSettings *m_pSysSettingsDBusServer;
        static ProfileMngrComp * m_pInst;



        DECLARE_CLASS_LOGGER();

    public:
        ProfileMngrComp();
        virtual ~ProfileMngrComp();
        static ProfileMngrComp & inst();
    };

}} // namespace org { namespace bosch { namespace cm { namespace pm {

#endif // ifndef __PM_pmAsfComponent_H
