/*****************************************************************************
* FILE:         pmAsfComponent.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* DESCRIPTION:  ASF Main component class
* 				includes an ASF Service and also strat up the CCA Service
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#include "ProfileMngrComp.h"
#include "asfComp/cca/ServiceProfileMngrCCA.h"
#include "asfComp/dbus/ServiceProfileMngrDBUS.h"
#include "asfComp/dbus/ServiceProfileMngrSysSettings.h"
#include "core/configInterface.h"

#include "core/profileApp.h"

#include "core/profileTrace.h"

namespace app { namespace core {

ProfileMngrComp * ProfileMngrComp::m_pInst=NULL;

    using namespace::asf::core;
    using namespace::asf::stream;

    DEFINE_CLASS_LOGGER_AND_LEVEL("app/core/profileMngrComp", ProfileMngrComp, Info);


    ProfileMngrComp & ProfileMngrComp::inst()
    {
    	if (m_pInst==NULL) exit(excNoInstane);
    	return *m_pInst;
    }

    ProfileMngrComp::ProfileMngrComp(): BaseComponent()
    {
    	m_pInst=this;
      
        m_pDBusServer = new (std::nothrow) ServerProfileMngrDBUS(ProfileApp::getInst());
        m_pSysSettingsDBusServer = new (std::nothrow) ServiceProfileMngrSysSettings();

    }


    ProfileMngrComp::~ProfileMngrComp()
    {
        m_pDBusServer   = NULL;
        m_pSysSettingsDBusServer = NULL;
    }

}} // namespace org { namespace bosch { namespace cm { namespace pm {
