/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "app/core/ProfileMngr.h"
#include "app/core/ProfileMngrComp.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>

#include "core/configInterface.h"
#include "core/profileApp.h"

/**
 * If the meaning of "ProfileMngr" isn't clear, then there should be a description here.
 */
using namespace profileMngr;
namespace app {
namespace core {


DEFINE_LOGGER_AND_LEVEL (_logger, "/app/core/ProfileMngr", Info);

/* static */ const char* ProfileMngr::piviService = "piviService";
/* static */ const char* ProfileMngr::profileService = "profileService";

static const char* helpMessage =
	"--logconfig <file>		Read the logging configuration from <file>\n"
	"						see https://inside-wiki.bosch.com/confluence/display/cmaicfnavi/ASF+Logging+API\n"
	"--help 				Print this help message\n";
	
bool ProfileMngr_enabledASFSignalHandler = false;
	
void importProfileMngr() {
	::asf::core::Application* app = ::asf::core::Application::getApplication();
	LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProfileMngr, because no Application is instantiated");
	
	// Expression
	
	::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
	{
		::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
		{
			__expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
		}
		dbusConnector = __expression0;
	}
	{
		std::string jsonPayload;
		serializeJson (dbusConnector, jsonPayload);
		LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
	}
	::boost::shared_ptr< asf::dbus::DBusConnector > dbusConnector_(new asf::dbus::DBusConnector(*app, dbusConnector));
	app->addStarter(dbusConnector_);
	
	// Thread 'ProfileThread'
	
	::asf::core::ComponentContainerSharedPtr ProfileThread(new ::asf::core::ComponentContainer("ProfileThread", ::asf::core::ThreadConfiguration(1)));
	app->addContainer (ProfileThread);
		
	// Component 'ProfileMngrComp asfComponent'

	::boost::shared_ptr< ::asf::core::ComponentFactory< ::app::core::ProfileMngrComp > > profileServiceFactory(new ::asf::core::ComponentFactory< ::app::core::ProfileMngrComp >);
	::asf::core::ComponentDescriptionSharedPtr profileServiceDescription(new ::asf::core::ComponentDescription(3, "profileService", /* immediate = */ true, /* threadBridge = */ false, profileServiceFactory));
	ProfileThread->addComponentDescription(profileServiceDescription);

		// Port 'profileMngrDBUSPort'

		::asf::core::ProvidedPort& profileService_profileMngrDBUSPort = profileServiceDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.profile", "profileMngrDBUSPort"));
		(void)profileService_profileMngrDBUSPort; // prevent unused variable warning

		// Port 'profileMngrSysSettingsPort'

		::asf::core::ProvidedPort& asfComponent_profileMngrSysSettingsPort = profileServiceDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "profileMngrSysSettingsPort"));
		(void)asfComponent_profileMngrSysSettingsPort; // prevent unused variable warning

        // Expression
        dbusConnector_->exportByName (profileService_profileMngrDBUSPort, "/com/bosch/cm/profileMngr");

        // Expression
        dbusConnector_->exportByName (asfComponent_profileMngrSysSettingsPort, "/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/ProfileMngrSysSettingsService");
	
	    configIF::getInst().startASFClients(dbusConnector_,ProfileThread);
	
	    LOG_INFO_STATIC("Starting application 'ProfileMngr' version 1.0.0");
	
	    app->start();
}

int executeProfileMngr(int argc, char* argv[]) {
	::asf::core::ContextData context;

	const char* logConfigFile = 0;
	std::vector<std::string> arguments;
	
	for (int i=1; i<argc; i++) {
		if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
			// ignore lint warning e850: modification of i inside loop is safe 
			logConfigFile = argv[++i];
		} else {
			if (std::string(argv[i]) == "--help") {
				printf ("%s", helpMessage);
				exit (0);
			} else {
				arguments.push_back (argv[i]);
			}
		}
	}

	if (logConfigFile == 0) {  //lint !e850
		asf::core::Logger::setupLogging ("app.core", "ProfileMngr");
	} else {
		asf::core::Logger::setupLogging ("app.core", "ProfileMngr", logConfigFile);
	}
	
	LOG_INFO_STATIC("%s ASF signal handler", ProfileMngr_enabledASFSignalHandler ? "Enabled" : "Disabled" );

	::asf::core::Application* app = ::asf::core::Application::createApplication("app.core", "ProfileMngr", ::asf::core::Version(1, 0, 0, ""), arguments);

	LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProfileMngr");
	
	app->enableExceptionHandler(false);
	
	importProfileMngr();

	int exitCode = app->waitForCompletion();
	::asf::core::Application::deleteApplication();

	LOG_INFO_STATIC("Exiting from application 'ProfileMngr', exit code=%d", exitCode);
	return exitCode;
}

} // namespace core
} // namespace app
