/*!
*******************************************************************************
* \file               watchdog.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for watchdog
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
30.11.2017 | rhk6kor                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef _IPCM_WATCHDOG_H_
#define _IPCM_WATCH_DOG_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <glib.h>
#include <stdlib.h>
#include <systemd/sd-daemon.h>
#include <string.h>
#include "dlt/dlt.h"

/******************************************************************************
** FUNCTION   : bInitWatchDog
*******************************************************************************
* \fn     bInitWatchDog
* \brief  Function to initialize the watchdog
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitWatchDog();

/******************************************************************************
** FUNCTION   : vStopWatchDog
*******************************************************************************
* \fn     vStopWatchDog
* \brief  Function to stop the watchdog
* \param  None.
* \retval void.
******************************************************************************/
void vStopWatchDog();

#endif //_IPCMWATCHDOG_H_
