/*!
*******************************************************************************
* @file             : SmartProxyInterface.h
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : IPCM
*  - DESCRIPTION    : Interface file for smartproxy
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|------------------------
*  10.05.2017 | Deepa Jose(RBEI/ECO2)  | 1.0           | Smart proxy main file
*
******************************************************************************/
#ifndef SMARTPROXY_INTERFACE_H
#define SMARTPROXY_INTERFACE_H

#include <glib.h> 			// for GVariant data types
#include "system_types.h" 	//for tString

/** @enum MessageType
 *  @brief This enumuration defines message type
 */
typedef enum
{
    MT_REQUEST,     // REQUEST
    MT_RESPONSE,    // RESPONSE
    MT_SIGNAL       // SIGNAL
}MessageType;

typedef enum eTopicType; //Forward declaration

/** @struct Header
 *  @brief This structure defines header information on message struct
 */
typedef struct
{
    MessageType messageType;
    guint16  topicType;
    guint64 requestHandle;
    const char* name;
    const char* sender;
    char* intent;
}Header;



/** @struct Message
 *  @brief This structure defines the message sruct
 */
typedef struct
{
    Header* header;
    GVariant* payload;
}Message;






typedef enum
{
    PRIO_LOW,
    PRIO_HIGH
}MessagePriority;


/**
*******************************************************************************
** FUNCTION   : sGetDBusInterfaceSignals
*******************************************************************************
* \fn     sGetDBusInterfaceSignals
* \brief  function to get a list of signals
* \param  None.
* \retval tString.
******************************************************************************/
tString* sGetDBusInterfaceSignals();

tVoid sGetInterfaceArguments();


#endif //SMARTPROXY_INTERFACE_H
