/*!
*******************************************************************************
* @file             : SmartProxy_main.c
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : IPCM
*  - DESCRIPTION    : Main file for smart proxy
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|------------------------
*  10.05.2017 | Deepa Jose(RBEI/ECO2)  | 1.0           | Smart proxy main file
*
******************************************************************************/

#ifndef MESSAGE_DISPATCHER_H
#define MESSAGE_DISPATCHER_H

#include <stdbool.h>

#include "SmartProxyInterface.h"

/* a link in the queue, holds the info and point to the next Node
closer to front*/

/*typedef enum
{
    PRIO_LOW,
    PRIO_HIGH
}MessagePriority;*/

/** @struct Header
 *  @brief This structure defines
 *  @var foreignstruct::a
 *  Member 'a' contains...
 *  @var foreignstruct::b
 *  Member 'b' contains...
 */
typedef struct Msg_item
{
    Message* data;
    MessagePriority umsg_priority;
    struct Msg_item *ptr;

} Node_msg_item;


void vMessagePrint(Message* msg);




/******************************************************************************
 * FUNCTION         :      bInitMessageDispatcher
*******************************************************************************
 * Description      :      bInitMessageDispatcher
 * Parameters       :      (void)
 * Return           :      gboolean
*******************************************************************************/
gboolean bInitMessageDispatcher();



/******************************************************************************
 * FUNCTION         :      vStopMessageDispatcher
*******************************************************************************
 * Description      :      vStopMessageDispatcher
 * Parameters       :      (void)
 * Return           :      void
*******************************************************************************/
void vStopMessageDispatcher();



/******************************************************************************
 * FUNCTION         :      vpDispatcherRoutine
*******************************************************************************
 * Description      :      vpDispatcherRoutine
 * Parameters       :      (void *)
 * Return           :      void
*******************************************************************************/
void *vpDispatcherRoutine(void *l_poThreadParams);



/******************************************************************************
 * FUNCTION         :      bHandleMessageRequest
*******************************************************************************
 * Description      :      bHandleMessageRequest
 * Parameters       :      (Message*)
 * Return           :      void
*******************************************************************************/
void bHandleMessageRequest(Message *pMsgData);



/******************************************************************************
 * FUNCTION         :      Dequeue
*******************************************************************************
 * Description      :      Dequeue
 * Parameters       :      (void)
 * Return           :      Message*
*******************************************************************************/
Message* Dequeue();











/**
*******************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  Function to init smart proxy
* \param  None.
* \retval gboolean.
******************************************************************************/
void *vpDispatcherRoutine(void *l_poThreadParams);


/******************************* Message queues methods ********************/

/**
*******************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  Function to init smart proxy
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean Enqueue(Message* data);

/**
*******************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  Function to init smart proxy
* \param  None.
* \retval gboolean.
******************************************************************************/
void display();



/******************************* hash table methods ********************/



/**
*******************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  Function to init smart proxy
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean search(guint64 requestHandle);

/**
*******************************************************************************
** FUNCTION   : destroy_pendingmessage_hash_table
*******************************************************************************
* \fn     destroy_pendingmessage_hash_table
* \brief  Function to init smart proxy
* \param  None.
* \retval gboolean.
******************************************************************************/
void destroy_pendingmessage_hash_table();



#endif //MESSAGE_DISPATCHER_H
