/*!
*******************************************************************************
* \file               rpcserver.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for RPC server
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | rhk6kor                  | Initial Version
28.09.2017 | Naveen D R (RBEI/ECO2) | 0.0.1    | Initial version
\endverbatim
******************************************************************************/
#ifndef _RPCSERVER_H_
#define _RPCSERVER_H_

#include "../ATL/interface/system_types.h"
#include "../ATL/interface/atl_if.h"
#include "dlt/dlt.h"
#include <stdio.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <glib/gprintf.h>
#include <stdlib.h>


#ifdef __cplusplus
#endif

typedef struct 
{
  int caller_handle;
  int client_state; 
} CallParams;

/******************************************************************************
** FUNCTION   : typedef
*******************************************************************************
* \fn     typedef
* \brief  Function pointer to define function type
* \param  None.
* \retval None.
******************************************************************************/
typedef tVoid (*HandleE2EResponse)(GVariant*, GError**,gint64, eTopicType );
typedef GVariant*  (*HandleE2EMessageSync) (GVariant*,
                                            CallParams*, GError** error);
typedef tVoid  (*HandleE2EMessageAsync) (GVariant*,
                                         CallParams*, GError** error,
                                         HandleE2EResponse,gint64);

typedef struct 
{
    tString    service;
    tInt   major_version;
    tInt   minor_version;
    HandleE2EMessageAsync handleE2EMessageCBAsync;
} service;

/******************************************************************************
** FUNCTION   : bInitRPCServer
*******************************************************************************
* \fn     bInitRPCServer
* \brief  Function to init RPC Client
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitRPCServer();



/******************************************************************************
** FUNCTION   : vCleanUpRPCServer
*******************************************************************************
* \fn     vCleanUpRPCServer
* \brief  Function to cleanup rpcserver
* \param  None.
* \retval void.
******************************************************************************/
tVoid vCleanUpRPCServer();

/******************************************************************************
** FUNCTION   : vRegister_RPCServer
*******************************************************************************
* \fn     vRegister_RPCServer
* \brief  Function to handle registration request from plugins
* \param  None.
* \retval service.
******************************************************************************/
tVoid vRegister_RPCServer  (service ** services_list_arg,tInt services_len);

/******************************************************************************
** FUNCTION   : vUnRegister_RPCServer
*******************************************************************************
* \fn     vUnRegister_RPCServer
* \brief  Function to handle unregistration request from plugins
* \param  None.
* \retval service.
******************************************************************************/
tVoid vUnRegister_RPCServer  (service ** services_list_arg,tInt services_len);

/******************************************************************************
** FUNCTION   : iHandleATLResponse
*******************************************************************************
* \fn     iHandleATLResponse
* \brief  Function to handle senddestination request from atl
* \param  None.
* \retval none.
******************************************************************************/

tVoid iHandleATLResponse(tCString arg_appid,tCString arg_payload);


void* vGetServiceList(tUInt size);

#endif //_RPCSERVER_H_
