/*
*******************************************************************************
* file               agentplugin.h
*******************************************************************************
verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for agent plugin which handles message routing b/w
 smartproxy and ATL
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | svs7kor                  | Initial Version
endverbatim
******************************************************************************/
#ifndef _AGENTPLUGIN_H_
#define _AGENTPLUGIN_H_

#include "dlt/dlt.h"
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "atl_if.h"

#include "SmartProxyInterface.h"

typedef void (*startTimerFun)(void *);

typedef struct
{
    gchar* serviceName;
    guint64 uId;
    guint64 uRequestHandle;
    startTimerFun vTimerFun;

}requestMessage;


typedef struct
{
    gchar* serviceName;
    guint16 id;
    void (*startTimerFun)(void*);//take a function

}responseMatch;



typedef guint64(*pHandleResponse)(const char* identity,const char* data,guint64 request_handle);

gboolean bRegisterRPCClinet(const char* peer,pHandleResponse fresponseCB);

void HandleRequestFromSmartProxy(Message *message_info);
gboolean bDeregisterRPCClinet();
pHandleResponse responseCB;
GHashTable *hRequestMessage_hashTable;
gboolean bInitAgentPlugin();


#endif //_AGENTPLUGIN_H_
