/******************************************************************************
* file               agentplugin.c
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Implementation for agent plugin
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | svs7kor                  | Initial Version
\endverbatim
******************************************************************************/

#include "agentplugin.h"
#include "jsoncutils.h"
DLT_DECLARE_CONTEXT(RPCCLIENT);




#define TIMEOUT 3
static guint64 counter = 0; 

void timerLogic();
void startTimer(void* fcounter);
gboolean searchHash(gpointer requestID);
gboolean TimeoutCallBack(gpointer user_data);
void ATL_SendMessage(char* peer,char * appid, char* jsonObject);

/******************************************************************************
** FUNCTION   : bRegisterRPCClinet();
*******************************************************************************
* brief  Function for smart proxy to register to RPCCLIENT
* param  const char* peer,fpHandleResponse fResponseCB
* retval gboolean.
******************************************************************************/
gboolean bRegisterRPCClinet(const char* peer,pHandleResponse fResponseCB)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- bRegisterRPCClinet"));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- bRegisterRPCClinet:: peer")
            ,DLT_STRING(peer));
    responseCB = fResponseCB;
    return TRUE;
}



/******************************************************************************
** FUNCTION   : bDeregisterRPCClinet();
*******************************************************************************
* brief  Function to deregister RPCCLIENT from smart proxy
* param  None
* retval gboolean.
******************************************************************************/
gboolean bDeregisterRPCClinet()
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- bDeregisterRPCClinet"));
    return TRUE;
}

/******************************************************************************
** FUNCTION   : iterator();
*******************************************************************************
* brief  Function print hash table values
* param  gpointer key, gpointer value, gpointer user_data.
* retval void.
******************************************************************************/
void iterator(gpointer key, gpointer value, gpointer user_data) {
    printf(user_data, *(gint*)key, value);
}

/******************************************************************************
** FUNCTION   : ATL_SendMessage();
*******************************************************************************
* brief  Function send signal update or method request from smart proxy
* param  char* peer,char * appid, char* jsonObject.
* retval void.
******************************************************************************/
void ATL_SendMessage(char* peer,char * appid, char* jsonObject)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN ATL_SendMessage\n"));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Peer::\n"),DLT_STRING(peer));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Appid ::\n"),DLT_STRING(appid));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("jsonObject ::\n")
            ,DLT_STRING(jsonObject));
}

/******************************************************************************
** FUNCTION   : searchHash();
*******************************************************************************
* brief  Function to search for a key in hash table
* param  gpointer requestID.
* retval gboolean.
******************************************************************************/
gboolean searchHash(gpointer requestID)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN searchHash\n"));
    GHashTableIter iter;
    guint64 key;
    requestMessage* value;
    gboolean iMatchFound = FALSE;
    guint64 iCounterId = GPOINTER_TO_UINT(requestID); //DLT_UINT32

    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("iCounterId is ::\n")
            ,DLT_UINT64(iCounterId));
    g_hash_table_iter_init(&iter, hRequestMessage_hashTable);

    // g_hash_table_foreach(hRequestMessage_hashTable,
    // (GHFunc)iterator, "The square of %d is %s\n");

    while(g_hash_table_iter_next (&iter, (gpointer)&key,(gpointer)&value))
    {

        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
                ,DLT_STRING("Message - counterID val: \n"),DLT_UINT64(key));
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Message - Id is : \n")
                ,DLT_UINT64(value->uId));
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Message - request handle: \n")
                ,DLT_UINT64(value->uRequestHandle));
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Message -serviceName : \n")
                ,DLT_STRING(value->serviceName));

        if(iCounterId == value->uId)
        {
            DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Match found\n"));
            iMatchFound = TRUE;
        }
    }
    return iMatchFound;
}

/******************************************************************************
** FUNCTION   : bRemoveFromHashTable();
*******************************************************************************
* brief  Function to remove a key from hash table
* param  gpointer user_data
* retval gboolean.
******************************************************************************/
gboolean bRemoveFromHashTable(gpointer user_data)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN bRemoveFromHashTable\n"));
    guint64 key = GPOINTER_TO_UINT(user_data);

    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Key is : \n"),DLT_UINT64(key));
    DLT_LOG(RPCCLIENT, DLT_LOG_INFO
            , DLT_STRING("Hash table size:: ")
            , DLT_UINT32(g_hash_table_size(hRequestMessage_hashTable)));
    gboolean bRemove = g_hash_table_remove(hRequestMessage_hashTable
                                           ,(gpointer)&key);
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Removed successfully: \n")
            ,DLT_INT(bRemove));
    DLT_LOG(RPCCLIENT, DLT_LOG_INFO
            , DLT_STRING("Hash table size:: ")
            , DLT_UINT32(g_hash_table_size(hRequestMessage_hashTable)));
    if(bRemove)
    {
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Remove success \n"));
        return TRUE;
    }
    else
    {
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Remove failure \n"));
        return FALSE;
    }
}

/******************************************************************************
** FUNCTION   : TimeoutCallBack();
*******************************************************************************
* brief  Timeout callback 
* param  gpointer user_data
* retval gboolean.
******************************************************************************/
gboolean TimeoutCallBack(gpointer user_data)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN TimeoutCallBack\n"));

    return FALSE;// to make timer singleshot

}

/******************************************************************************
** FUNCTION   : startTimer();
*******************************************************************************
* brief  Function to start a timer
* param  int fcounterID
* retval void.
******************************************************************************/
void startTimer(void* fcounterID)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN startTimer\n"));
    //DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
    // ,DLT_STRING("fcounterID is: \n"),DLT_UINT64(fcounterID));
    g_timeout_add_seconds (TIMEOUT, TimeoutCallBack, GINT_TO_POINTER(fcounterID));

}

void vDestroy_RequestMessage(gpointer data)
{
	
	requestMessage * l_value_messageItem = (requestMessage*)data;
	g_free(l_value_messageItem->serviceName);
	g_free(l_value_messageItem);
	
}

gboolean bInitAgentPlugin()
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- bInitAgentPlugin"));
    hRequestMessage_hashTable =NULL;
    hRequestMessage_hashTable = g_hash_table_new_full(g_direct_hash,g_direct_equal
                                                      ,g_free,vDestroy_RequestMessage);
    return TRUE;
}

/******************************************************************************
 * Function:       HandleRequestFromSmartProxy
 * Description:    HandleRequestFromSmartProxy
 * Parameters:     (Message *)
 * Return:         void
 *****************************************************************************/
void HandleRequestFromSmartProxy(Message *message)
{
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("RPCC- HandleRequestFromSmartProxy"));
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("RPCC- MESSAGE HEADER REQUESTHANDLE "),DLT_UINT64(message->header->requestHandle));
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("RPCC- MESSAGE HEADER REQUESTTYPE "),DLT_UINT32(message->header->messageType));
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("RPCC- MESSAGE HEADER NAME"),DLT_STRING(message->header->name));
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("RPCC- MESSAGE HEADER SENDER"),DLT_STRING(message->header->sender));
    char* Spayload = g_variant_print(message->payload,TRUE);
    DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_UINT32((unsigned int)pthread_self()),DLT_STRING("RPCC- PAYLOAD PARAMS"),DLT_STRING(Spayload));


    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
            ,DLT_STRING("IN- HandleRequestFromSmartProxy"));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
            ,DLT_STRING("mType::"),DLT_INT(message->header->messageType));

    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO, DLT_STRING(__FUNCTION__),
            DLT_STRING("topic type::"),DLT_INT(message->header->topicType));

    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
            ,DLT_STRING("Service name::"),DLT_STRING(message->header->name));

    eTopicType topicType =  message->header->topicType;
    if(message->header->messageType == MT_SIGNAL)
    {
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Type is signal with name:")
                ,DLT_STRING(message->header->name));
        GVariant *gJsonConstruct = NULL;
        GVariantBuilder *builderJson;
        builderJson = g_variant_builder_new(G_VARIANT_TYPE("a{sv}"));
        g_variant_builder_add(builderJson, "{sv}", "jsonrpc",g_variant_new("s","2.0"));
        g_variant_builder_add(builderJson, "{sv}", "method",g_variant_new("s",message->header->name));
        g_variant_builder_add(builderJson, "{sv}", "params",g_variant_new("v",message->payload));
        gJsonConstruct = g_variant_builder_end (builderJson);
        g_variant_builder_unref (builderJson);
        // auto variant = gJsonConstruct;
        // auto variantString = g_variant_print(variant, TRUE);
        // DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("RPC CLIENT : Constructed gvariant:: ")
                // ,DLT_STRING(variantString));
        // printf( "RPC CLIENT : Constructed gvariant:: %s",variantString);

        const char* strJson = sGvarianttoJson(gJsonConstruct);
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- converted json =")
                ,DLT_STRING(strJson));
        iATL_SendMessage(RPC_CLIENT,"APPID",strJson, topicType);
    }
    else if(message->header->messageType == MT_REQUEST)
    {
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("METHOD REQUEST"));
        GVariant *gJsonConstruct = NULL;
        counter++;
        // guint64 key_req_ID = g_new(guint64, 1);
        guint64 key_req_ID = counter;
        requestMessage * value_messageItem =NULL;
        value_messageItem =g_new0(requestMessage, 1);
        value_messageItem->uId = counter;
        value_messageItem->uRequestHandle = message->header->requestHandle;

        DLT_LOG(RPCCLIENT, DLT_LOG_INFO
                , DLT_STRING("Header name ")
                , DLT_STRING(message->header->name));
        value_messageItem->serviceName = g_strdup(message->header->name);
        value_messageItem->vTimerFun = &startTimer;
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO
                ,DLT_STRING("key_req_ID : \n"),DLT_UINT64(key_req_ID));

        // requestMessage* value_messageItem  =
        // (requestMessage*)malloc(sizeof(requestMessage));
        // memset((void*)value_messageItem, 0 , sizeof(requestMessage));
        // g_hash_table_insert (hash_requestmessagelist
        // ,GINT_TO_POINTER (l_RequestId),value_messageItem);


        g_hash_table_insert(hRequestMessage_hashTable, GINT_TO_POINTER (key_req_ID), value_messageItem);
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Here's the list:\n"));
        // g_hash_table_foreach(hRequestMessage_hashTable,
        // (GHFunc)iterator, "The value of key %d is %s\n");
        // DLT_LOG(RPCCLIENT, DLT_LOG_INFO
        // , DLT_STRING("Hash table size:: ")
        // , DLT_UINT32(g_hash_table_size(hRequestMessage_hashTable)));
        value_messageItem->vTimerFun(GUINT_TO_POINTER(value_messageItem->uId)) ;
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("*******END*********\n"));

        GVariantBuilder *builderJson;
        builderJson = g_variant_builder_new(G_VARIANT_TYPE("a{sv}"));
        g_variant_builder_add(builderJson, "{sv}", "jsonrpc",g_variant_new("s","2.0"));
        g_variant_builder_add(builderJson, "{sv}", "method",g_variant_new("s",message->header->name));
        gchar *service_name = "",*params = "";
        g_variant_get(message->payload, "(ss)", &service_name, &params);
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- service_name"),DLT_STRING(service_name));
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- params"),DLT_STRING(params));
        g_variant_builder_add (builderJson, "{sv}", "service_name",g_variant_new("s",service_name));
        g_variant_builder_add (builderJson, "{sv}", "params",g_variant_new("s",params));
        g_variant_builder_add(builderJson, "{sv}", "id",g_variant_new("t",counter));
        gJsonConstruct = g_variant_builder_end (builderJson);
        g_variant_builder_unref (builderJson);


        // auto variant = gJsonConstruct;
        // auto variantString = g_variant_print(variant, TRUE);
        // DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("RPC CLIENT : Constructed gvariant:: ")
                // ,DLT_STRING(variantString));
        // printf( "RPC CLIENT : Constructed gvariant:: %s",variantString);
        const char* strJson = sGvarianttoJson(gJsonConstruct);
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- converted json =")
                ,DLT_STRING(strJson));
        iATL_SendMessage(RPC_CLIENT,"DEFAULT_APPID",strJson, topicType);

    }
    else
    {
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,
                DLT_STRING("Neither a SIGNAL nor a METHOD"));
    }
}

