/*!
*******************************************************************************
* @file             : pluginmanager.h
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : Plugin Manager
*  - DESCRIPTION    : Plugin Manager loads and validates the plugins 
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          | Version  | Modification
* ----------|---------------|----------|---------------------------------------
* 8.11.2017 | Ashsih Kumar  (RBEI/ECO2)| 0.0.1    | Initial version
******************************************************************************/
#ifndef _PLUGINMANAGER_H_
#define _PLUGINMANAGER_H_

//Headers
#include <stdlib.h>
#include <glib.h>
#include <gio/gio.h>
#include <gmodule.h>
#include "dlt/dlt.h"
#include "HelloService.h" 

//Plugin Init function
#define IPCM_PLUGIN_FUNC_INIT       (const gchar*)  "bInit"
//Plugin Deinit function
#define IPCM_PLUGIN_FUNC_DEINIT     (const gchar*)  "bDeinit"

//PROTOTYPE FUNCTION
typedef gboolean (*func_Init)(const gchar* sIpcmVersion);
typedef gboolean (*func_Deinit)();



/******************************************************************************
* FUNCTION         :      poLoadDynamicLibrary
*******************************************************************************
* Description      :      poLoadDynamicLibrary
* Parameters       :      (const gchar*)
* Return           :      GModule*
*******************************************************************************/
GModule* poLoadDynamicLibrary(const gchar* filename);



/******************************************************************************
* FUNCTION         :      bLoadPlugins
*******************************************************************************
* Description      :      Plugin Manager initialization
* Parameters       :      const gchar*
* Return           :      (gboolean)
*******************************************************************************/
gboolean bLoadPlugins(void);



/******************************************************************************
* FUNCTION         :      bInitPluginmanager
*******************************************************************************
* Description      :      Plugin Manager initialization
* Parameters       :      (void)
* Return           :      gboolean
*******************************************************************************/
gboolean bInitPluginmanager();



/******************************************************************************
* FUNCTION         :      vStopPlugins
*******************************************************************************
* Description      :      vStopPlugins
* Parameters       :      (void)
* Return           :      void
*******************************************************************************/
void vStopPlugins();



/******************************************************************************
* FUNCTION         :      vDeinitPluginManager
*******************************************************************************
* Description      :      Plugin Manager Deinitialization
* Parameters       :      (void)
* Return           :      void
*******************************************************************************/
void vDeinitPluginManager();



#endif //_PLUGINMANAGER_H_