/********************************************************************************
* \file               jsoncutils.cpp
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Handler for json conversion library
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
10.11.2017 | Naveen D R (RBEI/ECO2) | 0.0.1    | Initial version
\endverbatim
******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#include "jsoncutils.h"

#ifdef __cplusplus
}
#endif

using namespace std;

#include <json/value.h>
#include <json/writer.h>
#include <json/reader.h>

#include "jsoncppgvariant.h"
#include <json/json.h>

DLT_DECLARE_CONTEXT(JSONCONV);

/******************************************************************************
** FUNCTION   : sParseJsonStr
*******************************************************************************
* \fn     sParseJsonStr
* \brief  Handler function to parse json string
* \param  Parsed String.
* \retval Json String,key.
******************************************************************************/
tCString sParseJsonStr(tCString arg_jsonstr,tCString arg_key)
{
    DLT_REGISTER_CONTEXT(JSONCONV,"JSON","RPCC context for logging");
    DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- sParseJsonStr"));
    Json::Reader reader;
    Json::Value root;
    std::string str(arg_jsonstr);
    std::string key(arg_key);
    bool parsedSuccess = reader.parse(str.c_str(), root);

    if(!parsedSuccess)
    {
        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- Failed to parse JSON"));
        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING(reader.getFormattedErrorMessages().c_str()));
    }
    else{

        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- Success"));
    }

    Json::FastWriter fastWriter;
    Json::Value params = root[arg_key];
    std::string output = fastWriter.write(params);
    output.erase( std::remove_if( output.begin(), output.end(), ::isspace ), output.end() );
    DLT_LOG(JSONCONV,DLT_LOG_INFO,DLT_STRING("-out parse"));

    return g_strdup(output.c_str());

}

/******************************************************************************
** FUNCTION   : sJsontoGvariant
*******************************************************************************
* \fn     sJsontoGvariant
* \brief  Handler function to convert json to Gvariant
* \param  Json String
* \retval Gvariant
******************************************************************************/
GVariant* sJsontoGvariant(tCString arg_jsonstr)
{
    DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- sJsontoGvariant"));

    Json::Value root;
    Json::Reader reader;
    bool parsedSuccess = reader.parse(arg_jsonstr, root);

    if(!parsedSuccess)
    {
        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- Failed to parse JSON"));
        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING(reader.getFormattedErrorMessages().c_str()));
    }
    else{

        DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- Success"));
    }
    GVariant* g_variant = jsonToGVariant(root);

    return g_variant;
}

/******************************************************************************
** FUNCTION   : sGvarianttoJson
*******************************************************************************
* \fn     sGvarianttoJson
* \brief  Handler function to convert json to Gvariant
* \param  Json String
* \retval Gvariant
******************************************************************************/
tCString sGvarianttoJson(GVariant *variant)
{
    DLT_LOG(JSONCONV ,DLT_LOG_INFO,DLT_STRING("IN- sGvarianttoJson"));
    Json::Value value = gvariantToJson(variant);
    Json::FastWriter fastWriter;
    std::string output = fastWriter.write(value);
    return g_strdup(output.c_str());
}






