/*!
*******************************************************************************
* \file               dbuscommmanager.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for DBUS Communication manager
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | rhk6kor                  | Initial Version
28.09.2017 | Naveen D R (RBEI/ECO2) | 0.0.1    | Initial version
\endverbatim
******************************************************************************/

#ifndef _DBUSCOMMMGR_H_
#define _DBUSCOMMMGR_H_

#include <glib.h>
#include <gio/gio.h>
#include <unistd.h>
#include <string.h>
#include "dlt/dlt.h"
#include "../ATL/interface/system_types.h"

typedef tVoid (*HandleMethodResponse)(GVariant*, GError**,void*);

typedef struct _interface_agents interface_agents;

typedef tVoid (*RegisterClient_cb) (interface_agents* l_interface_agents);

typedef tVoid (*GenericMethodCall) (tCString sender, tCString method_name, 
GVariant *parameters
,const void* request_handle);
typedef void (*dbus_signal_cb)(const gchar* sendername ,GVariant* parameters);


typedef struct 
{
	HandleMethodResponse handleMethodResponseCBAsync;
	tVoid* request_id;
} method_request_info;

/******************************************************************************
** FUNCTION   : bInitDBusCommMgr
*******************************************************************************
* \fn     bInitDBusCommMgr
* \brief  Function to initialize the DBUS communication manager
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitDBusCommMgr();

/******************************************************************************
** FUNCTION   : vStopDBusCommMgr
*******************************************************************************
* \fn     vStopDBusCommMgr
* \brief  Function to cleanup DBus communication manager.
* \param  None.
* \retval void.
******************************************************************************/
tVoid vStopDBusCommMgr();

/******************************************************************************
** FUNCTION   : iTriggerMethodAsync
*******************************************************************************
* \fn     iTriggerMethodAsync
* \brief  Function to handle method request to AGW
* \param  None.
* \retval None.
******************************************************************************/

tVoid     iTriggerMethodAsync(interface_agents* arg_agents, tString name
,  GVariant* g_methodRequestparams
, method_request_info* request_info);

/******************************************************************************
** FUNCTION   : TriggerMethodSync
*******************************************************************************
* \fn     TriggerMethodSync
* \brief  Function to handle method request to AGW
* \param  None.
* \retval GVariant.
******************************************************************************/
GVariant* TriggerMethodSync(interface_agents* arg_agents, tString name
,  GVariant* g_methodRequestparams, GError**);

/******************************************************************************
** FUNCTION   : RegisterServer
*******************************************************************************
* \fn     RegisterServer
* \brief  Function to handle server request
* \param  None.
* \retval None.
******************************************************************************/
interface_agents* RegisterServer(tString arg_xml,tString arg_bus_name
, tString arg_obj_path, GError**
, GenericMethodCall fnptr);
//called from smart proxy.


tVoid GenericMethodResponse(const void* request_handle,GVariant *parameters,GError** err);

/******************************************************************************
** FUNCTION   : vUnRegisterServer
*******************************************************************************
* \fn     vUnRegisterServer
* \brief  Function to handle client request
* \param  None.
* \retval None.
******************************************************************************/

tVoid vUnRegisterServer(interface_agents* arg_agents,GError **l_poError);

/******************************************************************************
** FUNCTION   : RegisterClient
*******************************************************************************
* \fn     RegisterClient
* \brief  Function to handle client request
* \param  None.
* \retval None.
******************************************************************************/

interface_agents* RegisterClient(tString arg_xml,tString arg_bus_name
, tString arg_obj_path,GError **l_poError
,RegisterClient_cb f_registerclient_cb);



/******************************************************************************
** FUNCTION   : vUnRegisterClient
*******************************************************************************
* \fn     vUnRegisterClient
* \brief  Function to handle client request
* \param  None.
* \retval None.
******************************************************************************/

tVoid vUnRegisterClient(interface_agents* arg_agents,GError **l_poError);

/******************************************************************************
** FUNCTION   : bSubscribesignal
*******************************************************************************
* \fn     bSubscribesignal
* \brief  function to unsubsribe connected signal
* \param  interface agents.
* \retval gboolean.
******************************************************************************/
gboolean bSubscribesignal(interface_agents* arg_agents,tString arg_signalname
, dbus_signal_cb DbusresponseCB);

/******************************************************************************
** FUNCTION   : bUnSubscribesignal
*******************************************************************************
* \fn     bUnSubscribesignal
* \brief  function to unsubsribe connected signal
* \param  interface agents.
* \retval gboolean.
******************************************************************************/
gboolean bUnSubscribesignal(interface_agents* arg_agents
, tString arg_signalname);

#endif //_DBUSCOMMMGR_H_
