/*!
*******************************************************************************
* @file             : E2EService.h
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : E2E Plugin
*  - DESCRIPTION    : E2E plugin implementation
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          | Version  | Modification
* ----------|---------------|----------|---------------------------------------
* 8.11.2017 | Ashsih Kumar (RBEI/ECO2) | 0.0.1    | Initial version
******************************************************************************/
#ifndef _E2ESERVICE_H_
#define _E2ESERVICE_H_


//Headers
#include <glib.h>
#include <gio/gio.h>
//#include <gmodule.h>   //AUA8KOR-DONE  REMOVE THIS 
#include "dlt/dlt.h"

#include "dbuscommmanager.h"
#include "rpcserver.h"              //AUA8KOR NEED AN INTERFACE HEADWER FILE OR REMOVE OTHER STUFFS FILE
#include "ipcmversion.h"

// Location
#define XML_PATH                (const gchar*) "/var/opt/bosch/static/com.bosch.AutomotiveProxy.E2ENavigation.xml"
#define E2E_AGW_BUSNAME         (gchar*) "com.bosch.AutomotiveProxy"
#define E2E_AGW_OBJECT_PATH     (gchar*) "/com/bosch/AutomotiveProxy/E2ENavigation"

//E2E Version
#define E2E_MAJOR_VERSION               (gint) 1
#define E2E_MINOR_VERSION               (gint) 0

//Method Name
//#define E2E_FUNC_IPCM_SEND_DEST     (const gchar*) "sendDestination_1"   
#define E2E_FUNC_AGW_SEND_DEST      (gchar*) "SendDestinationToCar"

//AGW Parama Keys
//#define AGW_SEND_DEST_     (const gchar*) "id"    

/******************************************************************************
 * FUNCTION         :      handel_sendDestination
*******************************************************************************
 * Description      :      Handler function for SendDestination call
 * Parameters       :      (GVariant*, GError**)
 * Return           :      gint
*******************************************************************************/
void handel_sendDestination(GVariant* pFuncParams,CallParams*, GError** error,
                           HandleE2EResponse,gint64);


/******************************************************************************
 * FUNCTION         :      vE2EServicelist
*******************************************************************************
 * Description      :      Service list formulation
 * Parameters       :      (void)
 * Return           :      gboolean
*******************************************************************************/
gboolean vE2EServicelist();



/******************************************************************************
 * FUNCTION         :      sOpenXML
*******************************************************************************
 * Description      :      Load and parse the interface XML
 * Parameters       :      (const gchar*)
 * Return           :      gchar*
*******************************************************************************/
gchar*  sOpenXML(const gchar* sXMLpath);



/******************************************************************************
 * FUNCTION         :      bInit
*******************************************************************************
 * Description      :      E2E Plugin initialization
 * Parameters       :      (void)
 * Return           :      gboolean
*******************************************************************************/
gboolean bInit(const gchar* sIpcmVersion);



/******************************************************************************
 * FUNCTION         :      bDeinit
*******************************************************************************
 * Description      :      E2E Plugin cleanup before exit.
 * Parameters       :      (void)
 * Return           :      void
*******************************************************************************/
gboolean bDeinit();


#endif //_E2ESERVICE_H_


/******************************************************************************
** FUNCTION   : HandleResponseFromRPCServer
*******************************************************************************
* \fn     HandleResponseFromRPCServer
* \brief  Function to response from RPC Server
* \param  None.
* \retval int.
******************************************************************************/
/*int HandleResponseFromRPCServer(GVariant* var, GError** err)
{
	
	
}*/

