/*!
*******************************************************************************
* @file             : E2EService.c
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : E2E Plugin
*  - DESCRIPTION    : E2E plugin implementation
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          | Version  | Modification
* ----------|---------------|----------|---------------------------------------
* 8.11.2017 | Ashsih Kumar (RBEI/ECO2) | 0.0.1    | Initial version
******************************************************************************/
//HEADERS
#include "E2EService.h"

//DLT CONTEXT DECLARATION
DLT_DECLARE_CONTEXT(E2EL);

//Variable
interface_agents* poAgent;

//service* l_E2EServices;
//GList* l_serviceList;
//(*HandleE2EResponse)(GVariant*, GError**,gint64);
HandleE2EResponse RPCServerResponse = NULL;

//Req id
//gint64 r_id;


/******************************************************************************
 * FUNCTION         :      handle_DbusComMgr_Response_sendDestination
*******************************************************************************
 * Description      :      Handler function for SendDestination call
 * Parameters       :      (GObject *source_object, GAsyncResult *res,
                                 gpointer user_data)
 * Return           :      void
*******************************************************************************/
void handle_DbusComMgr_Response_sendDestination(GVariant* var_data , GError** err,void* user_data)
{
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- handle_DbusComMgr_Response_sendDestination"));

   //request_id
   gint64 *t_requestId = ((method_request_info *) user_data)->request_id;  
   gint64 l_request_id = *t_requestId; 
    
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- REQUESTID METHOD RESPONSE= "),DLT_INT(l_request_id)); 
   GError *error = NULL; 
   
   if(var_data != NULL)
   {
	   //g_debug("E2E PLUGIN- DBUS-PARAM %s\n",g_variant_print (var_data, TRUE));  
      const gchar * gvaraintType = g_variant_get_type_string (var_data);
      g_print("E2E PLUGIN- GVARIANT TPYE %s\n",gvaraintType);           //(y)
      //g_print("E2E PLUGIN- DBUSCOMMAN RESPONSE\n %s\n",g_variant_print(var_data, TRUE));
      //(byte 0x01,)   
      RPCServerResponse(var_data,&error,l_request_id, IPCM_DEFAULT_TOPIC);
   }
   else
      g_print("E2E PLUGIN- RESPONSE SEND BY DBUS COMMAN IS NULL\n");
}



/*******************************************************************************
 * FUNCTION         :      handle_sendDestination
********************************************************************************
 * Description      :      Handler function for SendDestination call
 * Parameters       :      (GVariant*, GError**)
 * Return           :      gint
*******************************************************************************/
void handle_sendDestination(GVariant* pFuncParams,CallParams* cal,
                           GError** error,HandleE2EResponse cb_func,gint64 request_id)

{
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- handle_sendDestination"));
   
   	char* Spayload = g_variant_print(pFuncParams,TRUE);
	DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Gvariant received ="),DLT_STRING(Spayload)); //Payload Print 		
   
   g_print("\n\nE2E PLUGIN- GVARIANT RECEIVED Type = %s\n",g_variant_get_type_string(pFuncParams));   //AUA8KOR TEMP
   g_print("E2E PLUGIN- GVARIANT RECEIVED Value = %s\n\n",g_variant_print(pFuncParams,TRUE));
   
   if(NULL == pFuncParams)
   {
      DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Arugment params is NULL"));
   }
   else
   {
      g_print("\nE2E PLUGIN- ***********FLAG***********\n");  //AUA8KOR TEMP
      if(!g_variant_is_of_type(pFuncParams,G_VARIANT_TYPE_VARDICT)) 
      {
         DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Arugment params not tpye a{sv}"));
      }
      else
      {       
         //Variables
         const gchar* pVIN = "DEFAULT";                  //VIN Code
         const gchar* pToken = "DEFAULT";                //Token
         const gchar* pTimeStamp = "DEFAULT";            //TimeStamp
         gboolean pSecuredOnly = FALSE;                  //SecuredOnly
         gboolean pDownloadTrafficInfo = FALSE;          //DownloadTrafficInfo
         gint16 pCalculationCondition = 99;              //CalculationCondition
         GVariant* pDestination = NULL;                  //Destination
         guchar pAcknowledgement = 99;                   //Return Type
         
         //InsideDestination
         gdouble pID  = 99.99;
         gdouble pLatitude = 99.99;
         gdouble pLongitude = 99.99;
         const gchar* pName = "DEFAULT";
         guint32 pTTS = 99;
         const gchar* pAddress = "DEFAULT";
         guint32 pLatitudeMode = 99;
         guint32 pLongitudeMode = 99;
         const gchar* pPhoneNumber = "DEFAULT";
         guint32 pLocationType = 99;
                  
         //Additional params
         GVariantBuilder *pmainBuilder = g_variant_builder_new(G_VARIANT_TYPE("aa{sv}"));
         GVariantIter iter;                              //Iterator
         GVariant* gVariantTemp1 = NULL;                 //TEMP GVariant
         GVariant* gVariantTemp2 = NULL;                 //TEMP GVariant                              
         GVariant *value;
         gchar *key;                                     //TEMP Key
         GVariant* temp_Destination = NULL;              //TEMP Destination
         GVariant* temp_Options1 = NULL;                 //TEMP Options
         GVariant* temp_Options2 = NULL;                 //TEMP Options
         
         g_print("\nE2E PLUGIN- ***********FLAG***********\n");  //AUA8KOR TEMP
         
         //VIN - 's'
         gVariantTemp1 = g_variant_lookup_value(pFuncParams,"VIN",G_VARIANT_TYPE_STRING);
         if(NULL == gVariantTemp1)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- VIN key not present/VIN type missmatch"));     
         }
         else
         {
            g_print("\nE2E PLUGIN- ***********FLAG=VIN***********\n");  //AUA8KOR TEMP
            pVIN = g_variant_get_string(gVariantTemp1,0);
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- VIN VALUE ="),DLT_STRING(pVIN));            
         }
         
         //TIMESTAMP - 's'
         gVariantTemp1 = g_variant_lookup_value(pFuncParams,"TimeStamp",G_VARIANT_TYPE_STRING);
         if(NULL == gVariantTemp1)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- TimeStamp key not present/TimeStamp type missmatch"));          
         }
         else
         {
            g_print("\nE2E PLUGIN- ***********FLAG=TIMESTAMP***********\n");  //AUA8KOR TEMP
            pTimeStamp = g_variant_get_string(gVariantTemp1,0);
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- TIMESTAMP VALUE ="),DLT_STRING(pTimeStamp));
         }
         
         //DOWNLOADTRAFFICINFO - 'b'
         gVariantTemp1 = g_variant_lookup_value(pFuncParams,"DownloadTrafficInfo",G_VARIANT_TYPE_BOOLEAN);
         if(NULL == gVariantTemp1)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- DownloadTrafficInfo key not present/DownloadTrafficInfo type missmatch"));          
         }
         else
         {
            g_print("\nE2E PLUGIN- ***********FLAG=DOWNLOADTRAFFICINFO***********\n");  //AUA8KOR TEMP
            pDownloadTrafficInfo = g_variant_get_boolean(gVariantTemp1);
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- DOWNLOADTRAFFICINFO VALUE ="),DLT_BOOL(pDownloadTrafficInfo));
         }       
         
         //OPTIONS  - 'a{sv}'  
         temp_Options1 = g_variant_lookup_value(pFuncParams,"Options",G_VARIANT_TYPE_VARDICT);
         if(NULL == temp_Options1)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Options key not present/Options type missmatch"));           
         }
         else
         {
            g_print("\nE2E PLUGIN- ***********FLAG=OPTIONS***********\n");  //AUA8KOR TEMP
            //Iteration for OPTIONS Variant
            g_print("\n\nE2E PLUGIN- GVARIANT Options Stirng Type = %s\n",g_variant_get_type_string(temp_Options1));
            g_print("E2E PLUGIN- GVARIANT Value is\n %s\n\n",g_variant_print(temp_Options1,TRUE));
                  
            //TOKEN - 's'   
            gVariantTemp2 = g_variant_lookup_value(temp_Options1,"Token",NULL);
            if(NULL == gVariantTemp2)
            {
               DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Token key not present/Token type missmatch"));         
            }
            else
            {
               pToken = g_variant_get_string(gVariantTemp2,0);
               DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- TOKEN VALUE ="),DLT_STRING(pToken));   
            }
         }        

         //DESTINATION  - 'aa{sv}'  aka-> locations
         temp_Destination = g_variant_lookup_value(pFuncParams,"Destination",((const GVariantType *) "aa{sv}"));
         if(NULL == temp_Destination)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Destination key not present/Destination type missmatch"));
            // return error            
         }
         else
         {
            g_print("\nE2E PLUGIN- ***********FLAG=DESTINATION***********\n");  //AUA8KOR TEMP
            //Iteration for DESTINATION Variant
            g_variant_iter_init(&iter,temp_Destination);
            while((gVariantTemp1 = g_variant_iter_next_value(&iter)))
            {
               char* Spayload = g_variant_print(gVariantTemp1,TRUE);
			   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Gvariant received ="),DLT_STRING(Spayload)); //Payload Print 	
			   
			   g_print("\n\nE2E PLUGIN- GVARIANT INSIDE Destination Stirng Type = %s\n",g_variant_get_type_string(gVariantTemp1));
               g_print("E2E PLUGIN- GVARIANT Value is\n %s\n\n",g_variant_print(gVariantTemp1,TRUE));
               
               if(!g_variant_is_of_type(gVariantTemp1,G_VARIANT_TYPE_VARDICT)) 
               {
                  DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Arugment inside Destination is not tpye a{sv}"));
               }
               else
               {
                  //ID - 'i'
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"id",G_VARIANT_TYPE_INT64);
                  if(NULL == gVariantTemp2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- id key not present/id id missmatch"));         
                  }
                  else
                  {
                     pID = (gdouble) g_variant_get_int64(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- ID VALUE ="),DLT_FLOAT64(pID));
                  }
                  
                  //LOCATIONTYPE - 'i'
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"LocationType",G_VARIANT_TYPE_INT64);
                  if(NULL == gVariantTemp2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LocationType key not present/LocationType type missmatch"));          
                  }
                  else
                  {
                     pLocationType = (guint32) g_variant_get_int64(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LOCATIONTYPE VALUE ="),DLT_UINT32(pLocationType));   
                  }
                  
                  //LATITUDE - 'd'				
				  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Latitude",G_VARIANT_TYPE_DOUBLE);				  
                  if(NULL == gVariantTemp2)
                  {
					 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Latitude is not type DOUBLE"));
					 gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Latitude",G_VARIANT_TYPE_INT64);
					 if(NULL == gVariantTemp2)
					 {
						 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Latitude key not present/Latitude type missmatch"));
						 //gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Latitude",NULL);
						 //gchar *sVariantType = g_variant_get_type_string(gVariantTemp2);
						 //DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LATITUDE GVARIANT TYPE="),DLT_STRING(sVariantType));				 			 
						 //gchar* Spayload = g_variant_print(gVariantTemp1,TRUE);
						 //DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LATITUDE="),DLT_STRING(Spayload));
					 }
					 else
					 {
						gint64 i_Latitude = g_variant_get_int64(gVariantTemp2);
						pLatitude = (gdouble)i_Latitude;
						DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- NEW LATITUDE VALUE ="),DLT_FLOAT64(pLatitude));  
					 }
                  }
                  else
                  {
					 pLatitude = g_variant_get_double(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LATITUDE VALUE ="),DLT_FLOAT64(pLatitude));  
                  }
                  
                  //LATITUDEMODE - 'i'    
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"LatitudeMode",G_VARIANT_TYPE_INT64);
                  if(NULL == gVariantTemp2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LatitudeMode key not present/LatitudeMode type missmatch"));          
                  }
                  else
                  {
                     pLatitudeMode = (guint32) g_variant_get_int64(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LATITUDEMODE VALUE ="),DLT_UINT32(pLatitudeMode));   
                  }               
                  
                  //LONGITUDE - 'd'      
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Longitude",G_VARIANT_TYPE_DOUBLE);
                  if(NULL == gVariantTemp2)
                  {
					 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Longitude is not type DOUBLE"));
					 gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Longitude",G_VARIANT_TYPE_INT64);
					 if(NULL == gVariantTemp2)
					 {
						 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Longitude key not present/Longitude type missmatch"));
						 //gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"Longitude",NULL);
						 //gchar *sVariantType = g_variant_get_type_string(gVariantTemp2);
						 //DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LONGITUDE GVARIANT TYPE="),DLT_STRING(sVariantType));				 			 
						 //gchar* Spayload = g_variant_print(gVariantTemp1,TRUE);
						 //DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LONGITUDE="),DLT_STRING(Spayload));
					 }
					 else
					 {
						gint64 i_Longitude = g_variant_get_int64(gVariantTemp2);
						pLongitude = (gdouble)i_Longitude;
						DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- NEW LONGITUDE VALUE ="),DLT_FLOAT64(pLongitude));  
					 }
                  }
                  else
                  {
                     pLongitude = g_variant_get_double(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LONGITUDE VALUE ="),DLT_FLOAT64(pLongitude));                       
                  }
                  
                  //LONGITUDEMODE - 'i'   
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"LongitudeMode",G_VARIANT_TYPE_INT64);
                  if(NULL == gVariantTemp2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LongitudeMode key not present/LongitudeMode type missmatch"));         
                  }
                  else
                  {
                     pLongitudeMode = (guint32) g_variant_get_int64(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- LONGITUDEMODE VALUE ="),DLT_UINT32(pLongitudeMode));   
                  }                
                  
                  //CALCULATIONCONDITION - 'i'  //AUA8KOR TEMP
                  gVariantTemp2 = g_variant_lookup_value(gVariantTemp1,"CalculationCondition",G_VARIANT_TYPE_INT64);
                  if(NULL == gVariantTemp2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- CalculationCondition key not present/CalculationCondition type missmatch"));        
                  }
                  else
                  {
                     pCalculationCondition = (gint16) g_variant_get_int64(gVariantTemp2);
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- CALCULATIONCONDITION VALUE ="),DLT_INT16(pCalculationCondition)); 
                  }               
                  
                  //OPTIONS  - 'a{sv}'  
                  temp_Options2 = g_variant_lookup_value(gVariantTemp1,"Options",G_VARIANT_TYPE_VARDICT);
                  if(NULL == temp_Options2)
                  {
                     DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Options key not present/Options type missmatch"));           
                  }
                  else
                  {
                     //Iteration for OPTIONS Variant
                     g_print("\n\nE2E PLUGIN- GVARIANT Options Stirng Type = %s\n",g_variant_get_type_string(temp_Options2));
                     g_print("E2E PLUGIN- GVARIANT Value is\n %s\n\n",g_variant_print(temp_Options2,TRUE));
                     
                     //NAME - 's'   
                     gVariantTemp2 = g_variant_lookup_value(temp_Options2,"Name",NULL);
                     if(NULL == gVariantTemp2)
                     {
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Name key not present/Name type missmatch"));         
                     }
                     else
                     {
                        pName = g_variant_get_string(gVariantTemp2,0);
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- NAME VALUE ="),DLT_STRING(pName));   
                     }
                     
                     //ADDRESS - 's'   
                     gVariantTemp2 = g_variant_lookup_value(temp_Options2,"Address",NULL);
                     if(NULL == gVariantTemp2)
                     {
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Address key not present/Address type missmatch"));         
                     }
                     else
                     {
                        pAddress = g_variant_get_string(gVariantTemp2,0);
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- ADDRESS VALUE ="),DLT_STRING(pAddress));    
                     }
                     
                     //PHONENUMBER - 's'   
                     gVariantTemp2 = g_variant_lookup_value(temp_Options2,"PhoneNumber",NULL);
                     if(NULL == gVariantTemp2)
                     {
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- PhoneNumber key not present/PhoneNumber type missmatch"));         
                     }
                     else
                     {
                        pPhoneNumber = g_variant_get_string(gVariantTemp2,0);
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- PHONENUMBER VALUE ="),DLT_STRING(pPhoneNumber));   
                     }
                     
                     //TTS1 - 's'   
                     gVariantTemp2 = g_variant_lookup_value(temp_Options2,"TTS1",NULL);
                     if(NULL == gVariantTemp2)
                     {
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- TTS1 key not present/TTS1 type missmatch"));         
                     }
                     else
                     {
                        const gchar* temp_pTTS = g_variant_get_string(gVariantTemp2,0);            //NEED DISCUSSION
                        DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- TTS1 VALUE ="),DLT_STRING(temp_pTTS));   
                     }
                  }              
               }
               g_print("E2E PLUGIN- ASHISH KUMAR\n\n");  //AUA8KOR
            
               //Destination Gvariant formulation
               GVariantBuilder *pinnerBuilder = g_variant_builder_new(G_VARIANT_TYPE("a{sv}"));
               
               g_variant_builder_add (pinnerBuilder,"{sv}","id",
                                                         g_variant_new_double(pID));
               
               g_variant_builder_add (pinnerBuilder,"{sv}","Latitude",
                                                         g_variant_new_double(pLatitude));
                                                         
               g_variant_builder_add (pinnerBuilder,"{sv}","Longitude",
                                                         g_variant_new_double(pLongitude));

               g_variant_builder_add (pinnerBuilder,"{sv}","Name",
                                                         g_variant_new_string(pName));
                                                         
               g_variant_builder_add (pinnerBuilder,"{sv}","TTS",
                                                         g_variant_new_uint32(pTTS));
                                                         
               g_variant_builder_add (pinnerBuilder,"{sv}","Address",
                                                         g_variant_new_string(pAddress));

               g_variant_builder_add (pinnerBuilder,"{sv}","LatitudeMode",
                                                         g_variant_new_uint32(pLatitudeMode));

               g_variant_builder_add (pinnerBuilder,"{sv}","LongitudeMode",
                                                         g_variant_new_uint32(pLongitudeMode));

               g_variant_builder_add (pinnerBuilder,"{sv}","PhoneNumber",
                                                         g_variant_new_string(pPhoneNumber));

               g_variant_builder_add (pinnerBuilder,"{sv}","LocationType",
                                                         g_variant_new_uint32(pLocationType));
                                                         
               g_variant_builder_add(pmainBuilder,"a{sv}",pinnerBuilder);
            }
            //Builder Completed
            pDestination = g_variant_builder_end(pmainBuilder);	
            g_print("E2E PLUGIN- FINAL DESTINATION GVARIANT\n %s\n\n",g_variant_print(pDestination,TRUE));           //AUA8KOR     
         }
         
         //AGW Param Gvariant formulation
         GVariant* g_params = g_variant_new("(sssbbn@aa{sv})",
                                             pVIN,
                                             pToken,
                                             pTimeStamp,
                                             pSecuredOnly,
                                             pDownloadTrafficInfo,
                                             pCalculationCondition,
                                             pDestination);

         g_print("E2E PLUGIN- GVARIANT SENT TO DBUSCOMMAN TYPE %s\n",g_variant_get_type_string(g_params));  //(sssbbnaa{sv})
         g_print("E2E PLUGIN- GVARIANT SENT TO DBUSCOMMAN\n %s\n",g_variant_print(g_params, TRUE)); 

         //he should sent me the initialized or created structure pointer.. i will maz populate it 
         method_request_info* l_Requestinfo =g_new0(method_request_info,1);
         l_Requestinfo->handleMethodResponseCBAsync = &handle_DbusComMgr_Response_sendDestination;
		 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- REQUEST ID METHOD CALL 1="),DLT_INT(request_id));
         gint32 t_requestId = (gint32)request_id;
		 DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- REQUEST ID METHOD CALL 2="),DLT_INT(t_requestId));
		 l_Requestinfo->request_id = (void*) &t_requestId;   //gint64 to void*
         
         iTriggerMethodAsync(poAgent,E2E_FUNC_AGW_SEND_DEST,      //AUA8KOR RETURN VALUE EVAL
                                          g_params,                   
                                          l_Requestinfo);              
                             
         RPCServerResponse = cb_func; //(*HandleE2EResponse)(GVariant*, GError**,gint64);
      }
   }
}



/******************************************************************************
 * FUNCTION         :      vE2EServicelist
*******************************************************************************
 * Description      :      Service list formulation
 * Parameters       :      (void)
 * Return           :      gboolean
*******************************************************************************/
gboolean vE2EServicelist()
{
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- vE2EServicelist"));
   
   static GList* l_serviceList = NULL;
   tInt size_service =1;   
    service **l_E2EServices =g_new0(service *, size_service);
    l_E2EServices[0] = g_new0(service, size_service);
    l_E2EServices[0]->service=g_strdup("\"sendDestination_1\"");
    l_E2EServices[0]->major_version = E2E_MAJOR_VERSION;
    l_E2EServices[0]->minor_version =E2E_MINOR_VERSION;
    l_E2EServices[0]->handleE2EMessageCBAsync =&handle_sendDestination;
   
   vRegister_RPCServer(l_E2EServices,size_service);
   
   //g_free(l_E2EServices);                                //UNCOMMMENT THIS COMPULSARY 
   //g_free(l_serviceList);
   return TRUE;
}



/******************************************************************************
 * FUNCTION         :      sOpenXML
*******************************************************************************
 * Description      :      Load and parse the interface XML
 * Parameters       :      (const gchar*)
 * Return           :      const gchar*
*******************************************************************************/
gchar* sOpenXML(const gchar* sXMLpath)
{
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- sOpenXML"));
   if (g_file_test (sXMLpath, G_FILE_TEST_EXISTS))
   {
      DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- XML file exists"));
      gsize ilength;
      gchar *sContent;
      if (g_file_get_contents (sXMLpath,&sContent,&ilength,NULL))
      {
         return g_strdup(sContent);
      }
      return NULL;
   }
   else
   {
      DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Unbale to open XML file"));
      return NULL;
   }
}

void vRegisterclient_cb(interface_agents* l_interface_agents)
{
	DLT_LOG(E2EL, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	
}

/******************************************************************************
 * Function:       bInit
 * Description:    E2E Plugin initialization
 * Parameters:     (void)
 * Return:         gboolean
 *****************************************************************************/
gboolean bInit(const gchar* sIpcmVersion)
{
   DLT_REGISTER_CONTEXT(E2EL,"E2EL","IPCM E2E PLUGIN");
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- bInit"));

   if(g_strcmp0 (sIpcmVersion,IPCM_VERSION))
   {
      DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("IPCM VERSION MISS-MATCH"),DLT_STRING(IPCM_VERSION));  
      return FALSE;
   }
   else
   {      
      GError *l_poError = NULL;
      //Loading the XML
      gchar* sIXML = sOpenXML(XML_PATH); 
      if(sIXML)
      {
         DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- XML Opened"));
         
         //Registration to DBusCommMan
         poAgent = RegisterClient(sIXML,E2E_AGW_BUSNAME,E2E_AGW_OBJECT_PATH,&l_poError,&vRegisterclient_cb); 
        
         if(poAgent)
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Registration with DbusComMan completed"));
            //Service List formulation & register with RPC Server
            return vE2EServicelist();
         }
         else
         {
            DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- Registration with DbusComMan failed"));
            return FALSE;
         }
      }
      else
      {
         DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- XML Parsing failed"));
         return FALSE;
      }
   }
}


/******************************************************************************
 * Function:       bDeinit
 * Description:    E2E Plugin cleanup before exit.
 * Parameters:     (void)
 * Return:         gboolean
 *****************************************************************************/
gboolean bDeinit()
{
   DLT_LOG(E2EL,DLT_LOG_INFO,DLT_STRING("E2E PLUGIN- bDeinit"));
   //Deregister from DbusComm Manager
   //Clean the Service list array 
   return TRUE;
}