/*****************************************************************************
* FILE:         videomanager_ServiceVdmSrvIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __videomanager_ServiceVdmSrvIf__IF__H_
#define __videomanager_ServiceVdmSrvIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_videomanager_ServiceVdmSrvIf.h"
#include "videomanager_AppMain.h"
#include "videomanager_ServiceVdmSrvCallbackIf.h"

// videomanager_tclServiceVdmSrvIf_Include: user specific code start
#include "videomanager_lookuptable.h"
#include "videomanager_videohandler.h"
// videomanager_tclServiceVdmSrvIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivideomanager_tclServiceVdmSrv;

class videomanager_tclServiceVdmSrvIf : public Ivideomanager_tclServiceVdmSrvIf, public videomanager_tclServiceVdmSrvCallbackIF
{
public:

   videomanager_tclServiceVdmSrvIf(tVoid); 
   videomanager_tclServiceVdmSrvIf(videomanager_tclAppMain* poMainAppl);
   virtual ~videomanager_tclServiceVdmSrvIf();

   // videomanager_tclServiceVdmSrvIfDeclarations: user specific code start
private:
   Ivideomanager_tclServiceVdmSrvIf* _pClientCallback;
   OSAL_tTimerHandle _hStateTimer;
   static OSAL_tpfCallback vStateTimer(tVoid *pArg);
   virtual tVoid vStartVideoSourceTimer(tU32 u32Time);

   static videomanager_tclServiceVdmSrvIf* _poMyStaticRef;

public:
   virtual void vActivateRVCA();
   virtual void vActivateRVCD();
   virtual void vActivateDTV();
   virtual void vActivateSPCX();
   virtual void vActivateDVD();
   virtual void vActivateUSB();
   virtual void vDeactivateSource(tU8 sourceToDeactivate);
   virtual void vPrintCurrentStatus();
   virtual void vEnterCriticalSection(tCString from);
   virtual void vReleaseCriticalSection(tCString from);
   virtual tU8  u8GetSourceWithRestrictedState();
   virtual void vRequestVectorHasEntries();
   virtual void vCheckForResetOfActiveSource();
   // videomanager_tclServiceVdmSrvIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "videomanager_tclServiceVdmSrvIf"; };
   
   virtual tVoid vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo);
   virtual tVoid sendRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo);
   virtual tVoid sendDTVStatus(videomanager_fi_tcl_e8_vdmSourceState DTV_StateInfo);
   virtual tVoid sendSPCXStatus(videomanager_fi_tcl_e8_vdmSourceState SPCX_StateInfo);
   virtual tVoid sendDVDStatus(videomanager_fi_tcl_e8_vdmSourceState DVD_StateInfo);
   virtual tVoid sendUSBStatus(videomanager_fi_tcl_e8_vdmSourceState USB_StateInfo);
   virtual tVoid sendDeserializerUsedByStatus(videomanager_fi_tcl_e8_vdmVideoSource Deserializer_SourceInfo);

   virtual tBool onRVCASet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onRVCDSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDTVSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSPCXSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDVDSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onUSBSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDeserializerUsedBySet(tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendRequestVideoSourceStateMResult(tBool bSourceChangeGranted);
   virtual tVoid sendRequestAccessToDeserializerMResult(tBool bAccessIsGranted);
   virtual tVoid sendAcknowledgeStateMResult();


   virtual tVoid onRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState);
   virtual tVoid onRequestAccessToDeserializerMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource);
   virtual tVoid onAcknowledgeStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmSourceState tVideoState);

   virtual void vGetRVCAMsg(videomanager_mainfi_tclMsgRVCAStatus& oStatus) {if (_poServerRef) _poServerRef->vGetRVCAMsg(oStatus);}
   virtual void vGetRVCDMsg(videomanager_mainfi_tclMsgRVCDStatus& oStatus) {if (_poServerRef) _poServerRef->vGetRVCDMsg(oStatus);}
   virtual void vGetDTVMsg(videomanager_mainfi_tclMsgDTVStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDTVMsg(oStatus);}
   virtual void vGetSPCXMsg(videomanager_mainfi_tclMsgSPCXStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSPCXMsg(oStatus);}
   virtual void vGetDVDMsg(videomanager_mainfi_tclMsgDVDStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDVDMsg(oStatus);}
   virtual void vGetUSBMsg(videomanager_mainfi_tclMsgUSBStatus& oStatus) {if (_poServerRef) _poServerRef->vGetUSBMsg(oStatus);}
   virtual void vGetDeserializerUsedByMsg(videomanager_mainfi_tclMsgDeserializerUsedByStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDeserializerUsedByMsg(oStatus);}

	virtual tU8 getS8NumberOfSourceToBeStored() const {	return _s8NumberOfSourceToBeStored;	}
	virtual void setS8NumberOfSourceToBeStored(tS8 s8NumberOfSourceToBeStored) { _s8NumberOfSourceToBeStored = s8NumberOfSourceToBeStored; }

	bool isVideomanagerWaiting() const { return _bVideomanagerWaiting; }
	void setVideomanagerWaiting(bool videomanagerWaiting) {	_bVideomanagerWaiting = videomanagerWaiting; }

private:
   Ivideomanager_tclServiceVdmSrv* _poServerRef;

// videomanager_tclServiceVdmSrvIfDeclarationsPart2: user specific code start
   virtual tVoid vResetFI();
   virtual void s8DeactivateRestrictedSources();
   videomanager_lookuptable* _poLookupTable;
   tS8 _s8NumberOfSourceToBeStored;
   OSAL_tSemHandle _hDataUpdateSemaphore;
   bool _bVideomanagerWaiting;
   bool _bTimerIsRunning;
   tS32 _s32TimerIndex;
   bool _bVectorHasEntriesChecking;

   struct _sRequestsToBeProcessed
   {
	   videomanager_fi_tcl_e8_vdmVideoSource tVideoSource;
	   videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState;
   };

   std::vector<_sRequestsToBeProcessed> _vRequestVector;
   std::vector<_sRequestsToBeProcessed>::iterator iter;

   struct _sNextSourceToBeAcknowledged
   {
	   videomanager_fi_tcl_e8_vdmVideoSource tVideoSource;
	   tS8 s8RequestedState;
   }sourceToBeAcknowledged;

// videomanager_tclServiceVdmSrvIfDeclarationsPart2: user specific code end

};

#endif // __videomanager_ServiceVdmSrvIf__IF__H_


