/*****************************************************************************
* FILE:         videomanager_ServiceVdmSrv.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// videomanager_tclServiceVdmSrvIncludes: user specific code start
// videomanager_tclServiceVdmSrvIncludes: user specific code end

#include "videomanager_ServiceVdmSrv.h"
#include "videomanager_ServiceVdmSrvCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_SERVER_VDMSRV
#include "trcGenProj/Header/videomanager_ServiceVdmSrv.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define VDMSRV_SERVICE_ID              229
#define VDMSRV_FI_MAJOR_VERSION        1
#define VDMSRV_FI_MINOR_VERSION        1

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(videomanager_tclServiceVdmSrv, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleRequestVideoSourceStateOpMStart)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_REQUESTACCESSTODESERIALIZER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleRequestAccessToDeserializerOpMStart)
   ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_ACKNOWLEDGESTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleAcknowledgeStateOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: videomanager_tclServiceVdmSrv::
*             videomanager_tclServiceVdmSrv(videomanager_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclServiceVdmSrv::videomanager_tclServiceVdmSrv(videomanager_tclAppMain* poMainAppl) : 
Ivideomanager_tclServiceVdmSrv(poMainAppl, VDMSRV_SERVICE_ID, VDMSRV_FI_MAJOR_VERSION, VDMSRV_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv() entered."));
   _poCallbackIf = OSAL_NULL;


   // videomanager_tclServiceVdmSrvConstructor: user specific code start
   // videomanager_tclServiceVdmSrvConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: videomanager_tclServiceVdmSrv::
*             ~videomanager_tclServiceVdmSrv(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclServiceVdmSrv::~videomanager_tclServiceVdmSrv(tVoid)
{
   ETG_TRACE_USR4(("~videomanager_tclServiceVdmSrv() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // videomanager_tclServiceVdmSrvDestructor: user specific code start
   // videomanager_tclServiceVdmSrvDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'videomanager_ServiceVdmSrv.h':
*     Add forward declaration:
*         class Ifc_vdm_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_vdm_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_vdm_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_vdm_app_tclObject2Get"));
*     VDMSRV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv::vGetReferences() entered."));
   // videomanager_tclServiceVdmSrvvGetReferences: user specific code start
   // videomanager_tclServiceVdmSrvvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv::vStartCommunication() entered."));
   // videomanager_tclServiceVdmSrvvStartCommunication: user specific code start
   // videomanager_tclServiceVdmSrvvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   videomanager_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // videomanager_tclServiceVdmSrvvHandleMessage: user specific code start
   // videomanager_tclServiceVdmSrvvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vHandleTraceMessage(const tUChar* puchData)
{
   VIDEOMANAGER_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // videomanager_tclServiceVdmSrvvHandleTraceMessage: user specific code start
   // videomanager_tclServiceVdmSrvvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      RVCA (VIDEOMANAGER_MAINFI_C_U16_RVCA) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      RVCD (VIDEOMANAGER_MAINFI_C_U16_RVCD) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DTV (VIDEOMANAGER_MAINFI_C_U16_DTV) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SPCX (VIDEOMANAGER_MAINFI_C_U16_SPCX) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DVD (VIDEOMANAGER_MAINFI_C_U16_DVD) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      USB (VIDEOMANAGER_MAINFI_C_U16_USB) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DeserializerUsedBy (VIDEOMANAGER_MAINFI_C_U16_DESERIALIZERUSEDBY) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      RequestVideoSourceState (VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE) -> Opcode: MethodStart, MethodResult, MethodAbort, Error, "));
   ETG_TRACE_FATAL(("Method   support:      RequestAccessToDeserializer (VIDEOMANAGER_MAINFI_C_U16_REQUESTACCESSTODESERIALIZER) -> Opcode: MethodStart, MethodResult, MethodAbort, Error, "));
   ETG_TRACE_FATAL(("Method   support:      AcknowledgeState (VIDEOMANAGER_MAINFI_C_U16_ACKNOWLEDGESTATE) -> Opcode: MethodStart, MethodResult, MethodAbort, Error, "));

   // videomanager_tclServiceVdmSrvvTraceInfo: user specific code start
   // videomanager_tclServiceVdmSrvvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // videomanager_tclServiceVdmSrvvOnServiceAvailable: user specific code start
   // videomanager_tclServiceVdmSrvvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrv::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrv::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // videomanager_tclServiceVdmSrvvOnServiceUnavailable: user specific code start
   // videomanager_tclServiceVdmSrvvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool videomanager_tclServiceVdmSrv
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool videomanager_tclServiceVdmSrv
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case VIDEOMANAGER_MAINFI_C_U16_RVCA:
      {
         videomanager_mainfi_tclMsgRVCAStatus oStatus;

         oStatus.RVCA_StateInfo = _tRVCA_RVCA_StateInfo;

         // CaseRVCAStatus_Pre: user specific code start
         // CaseRVCAStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseRVCAStatus: user specific code start
         // CaseRVCAStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_RVCD:
      {
         videomanager_mainfi_tclMsgRVCDStatus oStatus;

         oStatus.RVCD_StateInfo = _tRVCD_RVCD_StateInfo;

         // CaseRVCDStatus_Pre: user specific code start
         // CaseRVCDStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseRVCDStatus: user specific code start
         // CaseRVCDStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DTV:
      {
         videomanager_mainfi_tclMsgDTVStatus oStatus;

         oStatus.DTV_StateInfo = _tDTV_DTV_StateInfo;

         // CaseDTVStatus_Pre: user specific code start
         // CaseDTVStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseDTVStatus: user specific code start
         // CaseDTVStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_SPCX:
      {
         videomanager_mainfi_tclMsgSPCXStatus oStatus;

         oStatus.SPCX_StateInfo = _tSPCX_SPCX_StateInfo;

         // CaseSPCXStatus_Pre: user specific code start
         // CaseSPCXStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseSPCXStatus: user specific code start
         // CaseSPCXStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DVD:
      {
         videomanager_mainfi_tclMsgDVDStatus oStatus;

         oStatus.DVD_StateInfo = _tDVD_DVD_StateInfo;

         // CaseDVDStatus_Pre: user specific code start
         // CaseDVDStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseDVDStatus: user specific code start
         // CaseDVDStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_USB:
      {
         videomanager_mainfi_tclMsgUSBStatus oStatus;

         oStatus.USB_StateInfo = _tUSB_USB_StateInfo;

         // CaseUSBStatus_Pre: user specific code start
         // CaseUSBStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseUSBStatus: user specific code start
         // CaseUSBStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DESERIALIZERUSEDBY:
      {
         videomanager_mainfi_tclMsgDeserializerUsedByStatus oStatus;

         oStatus.Deserializer_SourceInfo = _tDeserializerUsedBy_Deserializer_SourceInfo;

         // CaseDeserializerUsedByStatus_Pre: user specific code start
         // CaseDeserializerUsedByStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VDMSRV_FI_MAJOR_VERSION);

         // CaseDeserializerUsedByStatus: user specific code start
         // CaseDeserializerUsedByStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool videomanager_tclServiceVdmSrv
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool videomanager_tclServiceVdmSrv
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrv:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case VIDEOMANAGER_MAINFI_C_U16_RVCA:
      {
         videomanager_mainfi_tclMsgRVCASet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onRVCASet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onRVCASet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseRVCASet: user specific code start
         // CaseRVCASet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_RVCD:
      {
         videomanager_mainfi_tclMsgRVCDSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onRVCDSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onRVCDSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseRVCDSet: user specific code start
         // CaseRVCDSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DTV:
      {
         videomanager_mainfi_tclMsgDTVSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDTVSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDTVSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDTVSet: user specific code start
         // CaseDTVSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_SPCX:
      {
         videomanager_mainfi_tclMsgSPCXSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onSPCXSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onSPCXSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseSPCXSet: user specific code start
         // CaseSPCXSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DVD:
      {
         videomanager_mainfi_tclMsgDVDSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDVDSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDVDSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDVDSet: user specific code start
         // CaseDVDSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_USB:
      {
         videomanager_mainfi_tclMsgUSBSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onUSBSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onUSBSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseUSBSet: user specific code start
         // CaseUSBSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VIDEOMANAGER_MAINFI_C_U16_DESERIALIZERUSEDBY:
      {
         videomanager_mainfi_tclMsgDeserializerUsedBySet oSet;

         if (oVisitorMsg.s32GetData(oSet, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDeserializerUsedBySet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDeserializerUsedBySet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDeserializerUsedBySet: user specific code start
         // CaseDeserializerUsedBySet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid videomanager_tclServiceVdmSrv::sendRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo)
{

   _tRVCA_RVCA_StateInfo = RVCA_StateInfo;


   ETG_TRACE_USR4(("sendRVCAStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_RVCA);
}
tVoid videomanager_tclServiceVdmSrv::sendRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo)
{

   _tRVCD_RVCD_StateInfo = RVCD_StateInfo;


   ETG_TRACE_USR4(("sendRVCDStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_RVCD);
}
tVoid videomanager_tclServiceVdmSrv::sendDTVStatus(videomanager_fi_tcl_e8_vdmSourceState DTV_StateInfo)
{

   _tDTV_DTV_StateInfo = DTV_StateInfo;


   ETG_TRACE_USR4(("sendDTVStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_DTV);
}
tVoid videomanager_tclServiceVdmSrv::sendSPCXStatus(videomanager_fi_tcl_e8_vdmSourceState SPCX_StateInfo)
{

   _tSPCX_SPCX_StateInfo = SPCX_StateInfo;


   ETG_TRACE_USR4(("sendSPCXStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_SPCX);
}
tVoid videomanager_tclServiceVdmSrv::sendDVDStatus(videomanager_fi_tcl_e8_vdmSourceState DVD_StateInfo)
{

   _tDVD_DVD_StateInfo = DVD_StateInfo;


   ETG_TRACE_USR4(("sendDVDStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_DVD);
}
tVoid videomanager_tclServiceVdmSrv::sendUSBStatus(videomanager_fi_tcl_e8_vdmSourceState USB_StateInfo)
{

   _tUSB_USB_StateInfo = USB_StateInfo;


   ETG_TRACE_USR4(("sendUSBStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_USB);
}
tVoid videomanager_tclServiceVdmSrv::sendDeserializerUsedByStatus(videomanager_fi_tcl_e8_vdmVideoSource Deserializer_SourceInfo)
{

   _tDeserializerUsedBy_Deserializer_SourceInfo = Deserializer_SourceInfo;


   ETG_TRACE_USR4(("sendDeserializerUsedByStatus() called."));
   eUpdateClients(VIDEOMANAGER_MAINFI_C_U16_DESERIALIZERUSEDBY);
}

tBool videomanager_tclServiceVdmSrv::onRVCASet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onRVCASet: user specific code start
   // onRVCASet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onRVCDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onRVCDSet: user specific code start
   // onRVCDSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onDTVSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDTVSet: user specific code start
   // onDTVSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onSPCXSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onSPCXSet: user specific code start
   // onSPCXSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onDVDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDVDSet: user specific code start
   // onDVDSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onUSBSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onUSBSet: user specific code start
   // onUSBSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrv::onDeserializerUsedBySet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDeserializerUsedBySet: user specific code start
   // onDeserializerUsedBySet: user specific code end
   return _bResult;
}


tVoid videomanager_tclServiceVdmSrv::vHandleRequestVideoSourceStateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tRequestVideoSourceState_tVideoSource = oMStart.tVideoSource;
            _tRequestVideoSourceState_tRequestedState = oMStart.tRequestedState;



            // Remember that we have to send an answer to this request
            _oMemRequestVideoSourceState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onRequestVideoSourceStateMStart(oMStart.tVideoSource, oMStart.tRequestedState);
            if (_poCallbackIf) _poCallbackIf->onRequestVideoSourceStateMStart(oMStart.tVideoSource, oMStart.tRequestedState);
            // vHandleRequestVideoSourceStateOpMStart: user specific code start
            // vHandleRequestVideoSourceStateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleRequestVideoSourceStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid videomanager_tclServiceVdmSrv::onRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState) {

   // onRequestVideoSourceStateMStart: user specific code start
   // onRequestVideoSourceStateMStart: user specific code end
}
tVoid videomanager_tclServiceVdmSrv::sendRequestVideoSourceStateMResult(tBool bSourceChangeGranted) {
   if (_oMemRequestVideoSourceState.bIsPending() == TRUE) {
      videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult  oMResult;
      //the data content

      oMResult.bSourceChangeGranted = bSourceChangeGranted;


      _oMemRequestVideoSourceState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemRequestVideoSourceState.u16GetSourceAppID(), 
         _oMemRequestVideoSourceState.u16GetRegisterID(), 
         _oMemRequestVideoSourceState.u16GetCMDCounter(), 
         (tU16) VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendRequestVideoSourceStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid videomanager_tclServiceVdmSrv::vHandleRequestAccessToDeserializerOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tRequestAccessToDeserializer_tVideoSource = oMStart.tVideoSource;



            // Remember that we have to send an answer to this request
            _oMemRequestAccessToDeserializer.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onRequestAccessToDeserializerMStart(oMStart.tVideoSource);
            if (_poCallbackIf) _poCallbackIf->onRequestAccessToDeserializerMStart(oMStart.tVideoSource);
            // vHandleRequestAccessToDeserializerOpMStart: user specific code start
            // vHandleRequestAccessToDeserializerOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleRequestAccessToDeserializerOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid videomanager_tclServiceVdmSrv::onRequestAccessToDeserializerMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource) {

   // onRequestAccessToDeserializerMStart: user specific code start
   // onRequestAccessToDeserializerMStart: user specific code end
}
tVoid videomanager_tclServiceVdmSrv::sendRequestAccessToDeserializerMResult(tBool bAccessIsGranted) {
   if (_oMemRequestAccessToDeserializer.bIsPending() == TRUE) {
      videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult  oMResult;
      //the data content

      oMResult.bAccessIsGranted = bAccessIsGranted;


      _oMemRequestAccessToDeserializer.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemRequestAccessToDeserializer.u16GetSourceAppID(), 
         _oMemRequestAccessToDeserializer.u16GetRegisterID(), 
         _oMemRequestAccessToDeserializer.u16GetCMDCounter(), 
         (tU16) VIDEOMANAGER_MAINFI_C_U16_REQUESTACCESSTODESERIALIZER, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendRequestAccessToDeserializerMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_REQUESTACCESSTODESERIALIZER, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid videomanager_tclServiceVdmSrv::vHandleAcknowledgeStateOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         videomanager_mainfi_tclMsgAcknowledgeStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VDMSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tAcknowledgeState_tVideoSource = oMStart.tVideoSource;
            _tAcknowledgeState_tVideoState = oMStart.tVideoState;



            // Remember that we have to send an answer to this request
            _oMemAcknowledgeState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onAcknowledgeStateMStart(oMStart.tVideoSource, oMStart.tVideoState);
            if (_poCallbackIf) _poCallbackIf->onAcknowledgeStateMStart(oMStart.tVideoSource, oMStart.tVideoState);
            // vHandleAcknowledgeStateOpMStart: user specific code start
            // vHandleAcknowledgeStateOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleAcknowledgeStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid videomanager_tclServiceVdmSrv::onAcknowledgeStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmSourceState tVideoState) {

   // onAcknowledgeStateMStart: user specific code start
   // onAcknowledgeStateMStart: user specific code end
}
tVoid videomanager_tclServiceVdmSrv::sendAcknowledgeStateMResult() {
   if (_oMemAcknowledgeState.bIsPending() == TRUE) {
      videomanager_mainfi_tclMsgAcknowledgeStateMethodResult  oMResult;
      //the data content



      _oMemAcknowledgeState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemAcknowledgeState.u16GetSourceAppID(), 
         _oMemAcknowledgeState.u16GetRegisterID(), 
         _oMemAcknowledgeState.u16GetCMDCounter(), 
         (tU16) VIDEOMANAGER_MAINFI_C_U16_ACKNOWLEDGESTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendAcknowledgeStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VIDEOMANAGER_MAINFI_C_U16_ACKNOWLEDGESTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// videomanager_tclServiceVdmSrvvideomanager_ServiceVdmSrv: user specific code start
// videomanager_tclServiceVdmSrvvideomanager_ServiceVdmSrv: user specific code end

//EOF
