/*****************************************************************************
* FILE:         videomanager_ClientSpm.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __videomanager_ClientSpm_H_
#define __videomanager_ClientSpm_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ivideomanager_ClientSpm.h"
#include "videomanager_AppMain.h"

// videomanager_tclClientSpm_Include: user specific code start
// videomanager_tclClientSpm_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class videomanager_tclClientSpmCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class videomanager_tclClientSpm : public Ivideomanager_tclClientSpm
{

public:
   virtual const tChar* getName() const { return "videomanager_tclClientSpm"; };
   
   virtual tVoid vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   videomanager_tclClientSpm(tVoid); 
   videomanager_tclClientSpm(videomanager_tclAppMain* poMainAppl);
   virtual ~videomanager_tclClientSpm();

   virtual tVoid vSetCallbackIf(videomanager_tclClientSpmCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // videomanager_tclClientSpmDeclarations: user specific code start
   // videomanager_tclClientSpmDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'videomanager_tclClientSpm' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   videomanager_tclClientSpm& operator = (const videomanager_tclClientSpm &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   videomanager_tclClientSpmCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/
   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData);

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState) {
      rSubState             = _SubState_SubStatesStatus;
      rHwSubState           = _HwSubState_SubStatesStatus;
      rInternSubState       = _InternSubState_SubStatesStatus;
   }

   virtual tBool sendSubStatesGet();
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent) {
      rCvmEvent             = _CvmEvent_CvmEventStatus;
   }

   virtual tBool sendCvmEventGet();


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleSubStatesOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandleCvmEventOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   tU32                                     _SubState_SubStatesStatus;
   tU32                                     _HwSubState_SubStatesStatus;
   tU32                                     _InternSubState_SubStatesStatus;
   spm_fi_tcl_SPM_e32_CVM_EVENT             _CvmEvent_CvmEventStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(videomanager_tclClientSpm) 

// videomanager_tclClientSpmDeclarationsPart2: user specific code start
// videomanager_tclClientSpmDeclarationsPart2: user specific code end

};

#endif // __videomanager_ClientSpm_H_


