
/*****************************************************************************
* FILE:         videomanager_ClientSpmIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// videomanager_tclClientSpmIfIncludes: user specific code start
// videomanager_tclClientSpmIfIncludes: user specific code end

#include "videomanager_ClientSpmIf.h"
#include "Ivideomanager_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_CLIENT_SPM
#include "trcGenProj/Header/videomanager_ClientSpmIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: videomanager_tclClientSpmIf::
*             videomanager_tclClientSpmIf(videomanager_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclClientSpmIf::videomanager_tclClientSpmIf(videomanager_tclAppMain* poMainAppl) : 
Ivideomanager_tclClientSpmIf(poMainAppl)
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // videomanager_tclClientSpmIfConstructor: user specific code start
   // videomanager_tclClientSpmIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: videomanager_tclClientSpmIf::
*             ~videomanager_tclClientSpmIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclClientSpmIf::~videomanager_tclClientSpmIf(tVoid)
{
   ETG_TRACE_USR4(("~videomanager_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // videomanager_tclClientSpmIfDestructor: user specific code start
   // videomanager_tclClientSpmIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'videomanager_ClientSpmIf.h':
*     Add forward declaration:
*         class Ifc_vdm_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_vdm_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_vdm_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_vdm_app_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivideomanager_tclClientSpm*>(_cpoMain->getHandler("Ivideomanager_tclClientSpm"));

   VIDEOMANAGER_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // videomanager_tclClientSpmIfvGetReferences: user specific code start
   // videomanager_tclClientSpmIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::vStartCommunication() entered."));
   // videomanager_tclClientSpmIfvStartCommunication: user specific code start
   // videomanager_tclClientSpmIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   videomanager_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // videomanager_tclClientSpmIfvHandleMessage: user specific code start
   // videomanager_tclClientSpmIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::vHandleTraceMessage(const tUChar* puchData)
{
   VIDEOMANAGER_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // videomanager_tclClientSpmIfvHandleTraceMessage: user specific code start
   // videomanager_tclClientSpmIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::vTraceInfo()
{
   // videomanager_tclClientSpmIfvTraceInfo: user specific code start
   // videomanager_tclClientSpmIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::onServiceAvailable() entered."));

   // videomanager_tclClientSpmIfvOnServiceAvailable: user specific code start
   // videomanager_tclClientSpmIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientSpmIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid videomanager_tclClientSpmIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("videomanager_tclClientSpmIf::onServiceUnavailable() entered."));

   // videomanager_tclClientSpmIfvOnServiceUnavailable: user specific code start
   // videomanager_tclClientSpmIfvOnServiceUnavailable: user specific code end
}

tVoid videomanager_tclClientSpmIf::onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState) {
   ETG_TRACE_USR1( ( "videomanager_tclClientSpmIf::onSubStatesStatus(): CALLED" ) );

   // onSubStatesStatus: user specific code start
   // onSubStatesStatus: user specific code end
}
tVoid videomanager_tclClientSpmIf::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {
   ETG_TRACE_USR1( ( "videomanager_tclClientSpmIf::onCvmEventStatus(): CALLED" ) );

   // onCvmEventStatus: user specific code start
   // onCvmEventStatus: user specific code end
}




// videomanager_tclClientSpmIfvideomanager_ClientSpmIf: user specific code start
// videomanager_tclClientSpmIfvideomanager_ClientSpmIf: user specific code end

//EOF
