/************************************************************************
* FILE:        	I_videomanager_videohandler.h
* PROJECT:		Nissan / Renault A-IVI
* SW-COMPONENT:	fc_videomanager
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to handle video sources
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 16.03.2017| CM-CI1/ERN4-E Schurig | initial introduction
*
*************************************************************************/

#ifndef _I_VIDEOMANAGER_VIDEOHANDLER_H_
#define _I_VIDEOMANAGER_VIDEOHANDLER_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "videomanager_AppMain.h"

class I_videomanager_videohandler : public videomanager_tclBaseIf
{
public:
	I_videomanager_videohandler(void);
	I_videomanager_videohandler(const videomanager_tclAppMain* poMainAppl) : videomanager_tclBaseIf (poMainAppl){;};

	virtual ~I_videomanager_videohandler(){};

	virtual const tChar* getIfName() const { return "Ivideomanager_videohandler"; };

	virtual void vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg) = 0;
	virtual void vHandleTraceMessage(const tUChar* puchData) = 0;
	virtual void vGetReferences() = 0;
	virtual void vStartCommunication() = 0;
	virtual void vTraceInfo() = 0;

};

#endif // _I_VIDEOMANAGER_VIDEOHANDLER_H_
