/************************************************************************
* FILE:        	videomanager_lookuptable.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	videomanager
*----------------------------------------------------------------------
*
* DESCRIPTION: class for lookuptable 
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 16.02.2017| CM-CI1/ERN4-E Schurig | initial version
*
*************************************************************************/

#ifndef _VIDEOMANAGER_LOOKUPTABLE_H_
#define _VIDEOMANAGER_LOOKUPTABLE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// include base class
#include "I_videomanager_lookuptable.h"

class videomanager_lookuptable : public I_videomanager_lookuptable
{
private:
	I_videomanager_lookuptable* _pClientCallback;
public:
	videomanager_lookuptable(void){;};
	videomanager_lookuptable(const videomanager_tclAppMain* poMainAppl);
	virtual ~videomanager_lookuptable();

	virtual const tChar* getName() const {return "videomanager_lookuptable";};

	virtual void  vSetCurrentSource(tU8 currentSource);
	virtual tBool bSourceChangeApproved(tU8 newSource);

	// To be implemented
	virtual void vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
	virtual void vHandleTraceMessage(const tUChar* puchData);
	virtual void vGetReferences();
	virtual void vStartCommunication();
	virtual void vTraceInfo();

	tS8 gets8NumOfActiveVideoSource() const {	return s8NumOfActiveVideoSource; }
	void sets8NumOfActiveVideoSource(tU8 NumOfActiveVideoSource) { this->s8NumOfActiveVideoSource = NumOfActiveVideoSource; }

	tS8 getS8NumOfSourceWhileRvc() const { return s8NumOfSourceWhileRVC; }
	void setS8NumOfSourceWhileRvc(tS8 s8NumOfSourceWhileRvc) { s8NumOfSourceWhileRVC = s8NumOfSourceWhileRvc; }

    tS8 getS8NumOfRequestingSoure() const { return s8NumOfRequestingSource; }
	void setS8NumOfRequestingSource(tS8 s8NumOfRequestingSource) { this->s8NumOfRequestingSource = s8NumOfRequestingSource; }

	// This enum makes sure that a possibly new source may added
	// to the current implementation
	enum eListOfVideoSources
	{
		eNoSource = 0,
		eRVCA,
		eRVCD,
		eDTV,
		eSPCX,
		eDVD,
		eUSB,
		eMaxSource
	};

private:
	// -1=not used 0=RVCA, 1=RVCD, 2=DTV, 3=SPCX, 4=DVD, 5=USB
	tS8 s8NumOfActiveVideoSource;
	tS8 s8NumOfSourceWhileRVC;
	tS8 s8NumOfRequestingSource;
}; // end of class videomanager_lookuptable

/*
 * This is a structure of boolean values which is base to
 * construct the switch matrix.
 */
struct FC_VIDEOMANAGER_SOURCES
{
	tBool bSourceRVCA;
	tBool bSourceRVCD;
	tBool bSourceDTV;
	tBool bSourceSPCX;
	tBool bSourceDVD;
	tBool bSourceUSB;
};

/*
 * This is the switch matrix. It is the lookuptable what to do when
 * a new video source has been activated. Should be switched to the
 * new source or keep the old one running? This can be seen here.
 *
 *              active source           0 = no switch to new source
 *              ==============>         1 = switch to new source
 *
 *   new      +------+------+------+------+------+------+------+
 *  source    |      | RVCA | RVCD |  DTV | SPCX |  DVD |  USB |
 *            +------+------+------+------+------+------+------+
 *    ||      | RVCA |   0  |   1  |   1  |   1  |   1  |   1  |
 *    ||      +------+------+------+------+------+------+------+
 *    ||      | RVCD |   1  |   0  |   1  |   1  |   1  |   1  |
 *    \/      +------+------+------+------+------+------+------+
 *            |  DTV |   0  |   0  |   0  |   1  |   1  |   1  |
 *            +------+------+------+------+------+------+------+
 *            | SPCX |   0  |   0  |   1  |   0  |   1  |   1  |
 *            +------+------+------+------+------+------+------+
 *            |  DVD |   0  |   0  |   1  |   1  |   0  |   1  |
 *            +------+------+------+------+------+------+------+
 *            |  USB |   0  |   0  |   1  |   1  |   1  |   0  |
 *            +------+------+------+------+------+------+------+
 *
 *  In the matrix set up the 0 is replaced by "false"
 *  and 1 respectively to "true".
 */

static FC_VIDEOMANAGER_SOURCES videomanager_source_matrix[] =
{
	{false,true,true,true,true,true},
	{true,false,true,true,true,true},
	{false,false,false,true,true,true},
	{false,false,true,false,true,true},
	{false,false,true,true,false,true},
	{false,false,true,true,true,false},
};


#endif // _VIDEOMANAGER_LOOKUPTABLE_H_
