/************************************************************************
* FILE:        	videomanager_lookuptable.cpp
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	videomanager
*----------------------------------------------------------------------
*
* DESCRIPTION: class for message handling mcan <-> CCA
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 16.02.2017| CM-CI1/ERN4-E Schurig | initial version
*
*************************************************************************/

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_LOOKUPTABLE
#include "trcGenProj/Header/videomanager_lookuptable.cpp.trc.h"
#endif

#include "videomanager_lookuptable.h"

/*************************************************************************
 * Constructors / Destructor
 ************************************************************************/
videomanager_lookuptable::videomanager_lookuptable(const videomanager_tclAppMain* poMainAppl)
: I_videomanager_lookuptable(poMainAppl)
{
	ETG_TRACE_USR4(("videomanager_lookuptable::videomanager_lookuptable() entered"));

	s8NumOfActiveVideoSource  = 0; // No video source
	s8NumOfSourceWhileRVC     = 0; // No video source while RVC is on
}

videomanager_lookuptable::~videomanager_lookuptable()
{
	ETG_TRACE_USR4(("videomanager_lookuptable::~videomanager_lookuptable() entered"));
}

/******************************************************************************
 *
 * FUNCTION:    vSetCurrentSource
 *
 * DESCRIPTION: set the current source
 *
 * PARAMETER:   [in]
 *              tU8 currentSource
 *
 * RETURNVALUE: none
 *
 *****************************************************************************/
void videomanager_lookuptable::vSetCurrentSource(tU8 currentSource)
{

}

/******************************************************************************
 *
 * FUNCTION:    bSourceChangeApproved
 *
 * DESCRIPTION: checks if a source change can happen by checking the values
 *              from current source to new source in the videomanager_source_matrix
 *
 * PARAMETER:   [in]
 *               tU8 newSource => Index of the new source according to table
 *
 * RETURNVALUE: bool
 *              true:  source change can be done
 *              false: source change cannot be done
 *
 *****************************************************************************/
tBool videomanager_lookuptable::bSourceChangeApproved(tU8 newSource)
{
//	newSource--;

	ETG_TRACE_USR4(("videomanager_lookuptable::bSourceChangeApproved() entered, current source is %d, new source is %d",gets8NumOfActiveVideoSource(),newSource));

	// Check if source is already running
	if(gets8NumOfActiveVideoSource() == newSource)
	{
		ETG_TRACE_USR4(("Running Source is same as new source, request denied"));
		return false;
	}

	newSource--;

	// Check if there is no video source active
	if(gets8NumOfActiveVideoSource() == eNoSource)
	{
		return true;
	}

	else if (gets8NumOfActiveVideoSource() == eRVCA)
	{
		if(videomanager_source_matrix[newSource].bSourceRVCA == true)
		{
			return TRUE;
		}
		else return FALSE;
	}

	else if (gets8NumOfActiveVideoSource() == eRVCD)
	{
		if(videomanager_source_matrix[newSource].bSourceRVCD == true)
		{
			return TRUE;
		}
		else return FALSE;
	}

	else if (gets8NumOfActiveVideoSource() == eDTV)
	{
		if(videomanager_source_matrix[newSource].bSourceDTV == true)
		{
			return TRUE;
		}
		else return FALSE;
	}

	else if (gets8NumOfActiveVideoSource() == eSPCX)
	{
		if (videomanager_source_matrix[newSource].bSourceSPCX == true)
		{
			return TRUE;
		}
		else return FALSE;
	}

	else if (gets8NumOfActiveVideoSource() == eDVD)
	{
		if (videomanager_source_matrix[newSource].bSourceDVD == true)
		{
			return TRUE;
		}
		else return FALSE;
	}

	else if(gets8NumOfActiveVideoSource() == eUSB)
	{
		if (videomanager_source_matrix[newSource].bSourceUSB == true)
		{
			return TRUE;
		}
		else return FALSE;
	}
	return FALSE;
}


/******************************************************************************
 * Need to be implemented
 *****************************************************************************/
void videomanager_lookuptable::vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg) {(tVoid)pMsg;}
void videomanager_lookuptable::vGetReferences(){}
void videomanager_lookuptable::vHandleTraceMessage(const tUChar* puchData) {(tVoid)puchData;}
void videomanager_lookuptable::vStartCommunication() {}
void videomanager_lookuptable::vTraceInfo(){}
