#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif

#include "buildversion_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_APPLICATION
#include "trcGenProj/Header/procstarter.cpp.trc.h"
#endif

#include "fc_aux_AppMain.h"

extern tVoid vAppProxyStarter(fc_aux_tclAppMain* _poCcaServer);

OSAL_tEventHandle  hEvShutdown = 0;
OSAL_tEventMask    hEvRequest  = 0x00000001;

tS32 s32RunEnv(void)
{
    tS32 s32RetVal = OSAL_OK;

     // open Trace ------------------------------
    ET_TRACE_OPEN;

    // Initialise AMT framework (tracing, static variables, ...)
    // Must be called before using AMT framework.

    amt_bInit();
    scd_init();

    tBool bRetVal = exh_bInitExceptionHandling();
    if(bRetVal != TRUE) {
    }

#   ifdef BUILDVERSION_DISPLAY_STARTUP_TRACE_ENABLED
    BuildVersion_vDisplayStartupMessage("PROCFC_AUX");
#   endif

    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procfc_aux.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procfc_aux.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procfc_aux.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);

    // create the shutdown event
    if (OSAL_s32EventCreate("PROCFC_AUX", &hEvShutdown) != OSAL_ERROR) {

#   ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
        DP_vCreateDatapool();
#   endif

        fc_aux_tclAppMain* _poCcaServer = fc_aux_tclAppMain::theServer();
        if (_poCcaServer != NULL){

            vAppProxyStarter(_poCcaServer);

            // and new create application instances
            if ( _poCcaServer->bInitInstance(0, CCA_C_U16_APP_FC_AUX) == FALSE )
            {
                ETG_TRACE_FATAL(("!!! vStartCCAApplications(): fc_aux_tclAppMain bInitInstance FAILED" ));
            }
        }

        // Wait for Shutdown-Signal
        ETG_TRACE_FATAL(("Wait for Shutdown-event 'PROCFC_AUX'!"));
        OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
        ETG_TRACE_FATAL(("Shutdown-event received -> stop applications!"));

        // Shutdown everything else
        OSAL_s32EventClose(hEvShutdown);
        OSAL_s32EventDelete("PROCFC_AUX");
    } else {
        ETG_TRACE_FATAL(("Failed to create event 'PROCFC_AUX'"));
    }

    // end trace
    ET_TRACE_CLOSE;

    return s32RetVal;
}
