
/*****************************************************************************
* FILE:         fc_aux_ServiceAuxSrv.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// fc_aux_tclServiceAuxSrvIncludes: user specific code start
// fc_aux_tclServiceAuxSrvIncludes: user specific code end

#include "fc_aux_ServiceAuxSrv.h"
#include "fc_aux_ServiceAuxSrvCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_SERVER_AUXSRV
#include "trcGenProj/Header/fc_aux_ServiceAuxSrv.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define AUXSRV_SERVICE_ID              177
#define AUXSRV_FI_MAJOR_VERSION        1
#define AUXSRV_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_aux_tclServiceAuxSrv, ahl_tclBaseWork)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_aux_tclServiceAuxSrv::
*             fc_aux_tclServiceAuxSrv(fc_aux_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclServiceAuxSrv::fc_aux_tclServiceAuxSrv(fc_aux_tclAppMain* poMainAppl) : 
Ifc_aux_tclServiceAuxSrv(poMainAppl, AUXSRV_SERVICE_ID, AUXSRV_FI_MAJOR_VERSION, AUXSRV_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv() entered."));
   _poCallbackIf = OSAL_NULL;


   // fc_aux_tclServiceAuxSrvConstructor: user specific code start
   // fc_aux_tclServiceAuxSrvConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: fc_aux_tclServiceAuxSrv::
*             ~fc_aux_tclServiceAuxSrv(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclServiceAuxSrv::~fc_aux_tclServiceAuxSrv(tVoid)
{
   ETG_TRACE_USR4(("~fc_aux_tclServiceAuxSrv() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // fc_aux_tclServiceAuxSrvDestructor: user specific code start
   // fc_aux_tclServiceAuxSrvDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'fc_aux_ServiceAuxSrv.h':
*     Add forward declaration:
*         class Ifc_aux_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_aux_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_aux_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_aux_app_tclObject2Get"));
*     AUXSRV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv::vGetReferences() entered."));
   // fc_aux_tclServiceAuxSrvvGetReferences: user specific code start
   // fc_aux_tclServiceAuxSrvvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv::vStartCommunication() entered."));
   // fc_aux_tclServiceAuxSrvvStartCommunication: user specific code start
   // fc_aux_tclServiceAuxSrvvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   fc_aux_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(fc_aux_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // fc_aux_tclServiceAuxSrvvHandleMessage: user specific code start
   // fc_aux_tclServiceAuxSrvvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // fc_aux_tclServiceAuxSrvvHandleTraceMessage: user specific code start
   // fc_aux_tclServiceAuxSrvvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      Availibility (AUX_MAINFI_C_U16_AVAILIBILITY) -> Opcode: UpReg, RelUpReg, Set, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      ConnectionState (AUX_MAINFI_C_U16_CONNECTIONSTATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));

   // fc_aux_tclServiceAuxSrvvTraceInfo: user specific code start
   // fc_aux_tclServiceAuxSrvvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // fc_aux_tclServiceAuxSrvvOnServiceAvailable: user specific code start
   // fc_aux_tclServiceAuxSrvvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrv::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrv::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // fc_aux_tclServiceAuxSrvvOnServiceUnavailable: user specific code start
   // fc_aux_tclServiceAuxSrvvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool fc_aux_tclServiceAuxSrv
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_aux_tclServiceAuxSrv
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case AUX_MAINFI_C_U16_AVAILIBILITY:
      {
         aux_mainfi_tclMsgAvailibilityStatus oStatus;

         oStatus.oStates = _tAvailibility_oStates;


         fi_tclVisitorMessage oVisitor(oStatus, AUXSRV_FI_MAJOR_VERSION);

         // CaseAvailibilityStatus: user specific code start
         // CaseAvailibilityStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case AUX_MAINFI_C_U16_CONNECTIONSTATE:
      {
         aux_mainfi_tclMsgConnectionStateStatus oStatus;

         oStatus.oStates = _tConnectionState_oStates;


         fi_tclVisitorMessage oVisitor(oStatus, AUXSRV_FI_MAJOR_VERSION);

         // CaseConnectionStateStatus: user specific code start
         // CaseConnectionStateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
	  }
	  break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool fc_aux_tclServiceAuxSrv
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool fc_aux_tclServiceAuxSrv
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case AUX_MAINFI_C_U16_AVAILIBILITY:
      {
         aux_mainfi_tclMsgAvailibilitySet oSet;

         if (oVisitorMsg.s32GetData(oSet, AUXSRV_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onAvailibilitySet(oSet.enAUXNumber, oSet.enAUXAvailState, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onAvailibilitySet(oSet.enAUXNumber, oSet.enAUXAvailState, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseAvailibilitySet: user specific code start
         // CaseAvailibilitySet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid fc_aux_tclServiceAuxSrv::sendAvailibilityStatus(aux_fi_tcl_AUX_States oStates)
{

   _tAvailibility_oStates = oStates;


   ETG_TRACE_USR4(("sendAvailibilityStatus() called."));
   eUpdateClients(AUX_MAINFI_C_U16_AVAILIBILITY);
}
tVoid fc_aux_tclServiceAuxSrv::sendConnectionStateStatus(aux_fi_tcl_AUX_States oStates)
{

   _tConnectionState_oStates = oStates;


   ETG_TRACE_USR4(("sendConnectionStateStatus() called."));
   eUpdateClients(AUX_MAINFI_C_U16_CONNECTIONSTATE);
}

tBool fc_aux_tclServiceAuxSrv::onAvailibilitySet(tU8 enAUXNumber, aux_fi_tcl_e8_AUXAvailabilityState enAUXAvailState, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enAUXNumber; (tVoid)enAUXAvailState;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onAvailibilitySet: user specific code start
   // onAvailibilitySet: user specific code end
   return _bResult;
}






// fc_aux_tclServiceAuxSrvfc_aux_ServiceAuxSrv: user specific code start
// fc_aux_tclServiceAuxSrvfc_aux_ServiceAuxSrv: user specific code end

//EOF
