/*****************************************************************************
* FILE:         fc_aux_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef _FC_AUX_APPMAIN_H_
#define _FC_AUX_APPMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_SET
#include "stl_pif.h"

#include "fc_aux_AppMain_Trace.h"

// fc_aux_tclAppMainIncludes: user specific code start
// fc_aux_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_AUX_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define FC_AUX_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// fc_aux_tclAppMainDefine: user specific code start
// fc_aux_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define FC_AUXINTERNAL_MSG_LEN    4       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class fc_aux_tclAppMain;

// fc_aux_tclAppMainForwardDecl: user specific code start
// fc_aux_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class fc_aux_tclBaseIf
{
protected:
   const fc_aux_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages

      // fc_aux_tclAppMainIMsgDef: user specific code start
      // fc_aux_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[50];
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[FC_AUXINTERNAL_MSG_LEN];

         // fc_aux_tclAppMainIMsgUnion: user specific code start
         // fc_aux_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   fc_aux_tclBaseIf(const fc_aux_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~fc_aux_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // fc_aux_tclAppMainBaseIfDecl: user specific code start
   // fc_aux_tclAppMainBaseIfDecl: user specific code end

};


class fc_aux_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static fc_aux_tclAppMain*   _poMainAppInstance;

public:
   static fc_aux_tclAppMain* theServer();    


   fc_aux_tclAppMain(tVoid);
   virtual ~fc_aux_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'fc_aux_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   fc_aux_tclAppMain& operator= (const fc_aux_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'fc_aux_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   fc_aux_tclAppMain(const fc_aux_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(fc_aux_tclBaseIf::TMsg* pInternalMsg);
   virtual tVoid vPostInternalMessage(fc_aux_tclBaseIf::TMsg* pInternalMsg);

   tVoid vAddObj(fc_aux_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(fc_aux_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   //reference handling for __ created objects
private:
   bpstl::set<fc_aux_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      bpstl::set<fc_aux_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      bpstl::set<fc_aux_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   fc_aux_tclBaseIf*  getHandler(const tChar* cName) const{
      bpstl::set<fc_aux_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:


   // fc_aux_tclAppMainDecl: user specific code start
   tVoid vGetBrandEntryFromKDS();
   tU8 getU8BrandOfTarget() const {	return _u8BrandOfTarget; }
   void setU8BrandOfTarget(tU8 u8BrandOfTarget) { _u8BrandOfTarget = u8BrandOfTarget; }

   tBool getbAuxConfig() const { return _bAUXIsValid; }
   void setbAuxConfig(tBool u8AuxConfig) { _bAUXIsValid = u8AuxConfig; }

	tBool getbStartDetection() const { return _bStartDetection; }
	void setbStartDetection(tBool startDetection) { _bStartDetection = startDetection; }

private:
   tU8 _u8BrandOfTarget;
   tBool _bAUXIsValid;
   tBool _bStartDetection;
   // fc_aux_tclAppMainDecl: user specific code end
}; 

#endif // _FC_AUX_APPMAIN_H_

