/*****************************************************************************
* FILE:         fc_aux_app_ClientStarter.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     appl_ClientStarter.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Create application specific objects here
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "fc_aux_AppMain.h"

#include "fc_aux_ServiceAuxSrv.h"
#include "fc_aux_ServiceAuxSrvIf.h"
#include "fc_aux_ClientSpm.h"
#include "fc_aux_ClientSpmIf.h"
#include "fc_aux_ClientDiagLog.h"
#include "fc_aux_ClientDiagLogIf.h"


// AsfClientStarterInclude: user specific code start
#include "fc_auxJackDetection.h"
#include "../../appl/audio_routing/fc_auxAudioRouting.h"
// AsfClientStarterInclude: user specific code end

void vAppProxyStarter(fc_aux_tclAppMain *poServer){

    {
        {
            fc_aux_tclServiceAuxSrv *poCcaProxy = new fc_aux_tclServiceAuxSrv(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            fc_aux_tclServiceAuxSrvIf *poCcaProxy = new fc_aux_tclServiceAuxSrvIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            fc_aux_tclClientSpm *poCcaProxy = new fc_aux_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            fc_aux_tclClientSpmIf *poCcaProxy = new fc_aux_tclClientSpmIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            fc_aux_tclClientDiagLog *poCcaProxy = new fc_aux_tclClientDiagLog(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        {
            fc_aux_tclClientDiagLogIf *poCcaProxy = new fc_aux_tclClientDiagLogIf(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
    }

    // AsfClientProxyStarter: user specific code start

    // start audio routing class
    {
    	fc_auxAudioRouting *poCcaProxy = new fc_auxAudioRouting(poServer);
    	poServer->vAddObj(poCcaProxy);
    }

    // start jack detection class
    {
    	fc_auxJackDetection *poCcaProxy = new fc_auxJackDetection(poServer);
   	    poServer->vAddObj(poCcaProxy);
    }

    // AsfClientProxyStarter: user specific code end
}
