/*****************************************************************************
* FILE:         fc_aux_ClientSpmIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __fc_aux_ClientSpmIf__IF__H_
#define __fc_aux_ClientSpmIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_fc_aux_ClientSpmIf.h"
#include "fc_aux_AppMain.h"
#include "fc_aux_ClientSpmCallbackIf.h"

// fc_aux_tclClientSpmIf_Include: user specific code start
// fc_aux_tclClientSpmIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ifc_aux_tclClientSpm;

class fc_aux_tclClientSpmIf : public Ifc_aux_tclClientSpmIf, public fc_aux_tclClientSpmCallbackIF
{
public:

   fc_aux_tclClientSpmIf(tVoid); 
   fc_aux_tclClientSpmIf(fc_aux_tclAppMain* poMainAppl);
   virtual ~fc_aux_tclClientSpmIf();

   virtual const tChar* getName() const { return "fc_aux_tclClientSpmIf"; };
   
   virtual tVoid vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) {
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesSet(SubStateType, SubStateData);
   }

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSubStatesStatus(rSubState, rHwSubState, rInternSubState);
   }


   virtual tBool sendSubStatesGet(){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesGet();
   }
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCvmEventStatus(rCvmEvent);
   }


   virtual tBool sendCvmEventGet(){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCvmEventGet();
   }

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);


   // fc_aux_tclClientSpmIfDeclarations: user specific code start
   // fc_aux_tclClientSpmIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ifc_aux_tclClientSpm* _poClientRef;

// fc_aux_tclClientSpmIfDeclarationsPart2: user specific code start
// fc_aux_tclClientSpmIfDeclarationsPart2: user specific code end

};

#endif // __fc_aux_ClientSpmIf__IF__H_


