/*****************************************************************************
* FILE:         fc_aux_ClientDiagLogIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __fc_aux_ClientDiagLogIf__IF__H_
#define __fc_aux_ClientDiagLogIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_fc_aux_ClientDiagLogIf.h"
#include "fc_aux_AppMain.h"
#include "fc_aux_ClientDiagLogCallbackIf.h"

// fc_aux_tclClientDiagLogIf_Include: user specific code start
// fc_aux_tclClientDiagLogIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ifc_aux_tclClientDiagLog;

class fc_aux_tclClientDiagLogIf : public Ifc_aux_tclClientDiagLogIf, public fc_aux_tclClientDiagLogCallbackIF
{
public:

   fc_aux_tclClientDiagLogIf(tVoid); 
   fc_aux_tclClientDiagLogIf(fc_aux_tclAppMain* poMainAppl);
   virtual ~fc_aux_tclClientDiagLogIf();

   virtual const tChar* getName() const { return "fc_aux_tclClientDiagLogIf"; };
   
   virtual tVoid vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSendNextTestResultStatus(rNextTestResultStruct, rStatus);
   }


   virtual tBool sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList){
       //just forward send request
       FC_AUX_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSaveTestResultMStart(TestResultList);
   }

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status);

   // fc_aux_tclClientDiagLogIfDeclarations: user specific code start
   // fc_aux_tclClientDiagLogIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ifc_aux_tclClientDiagLog* _poClientRef;

// fc_aux_tclClientDiagLogIfDeclarationsPart2: user specific code start
// fc_aux_tclClientDiagLogIfDeclarationsPart2: user specific code end

};

#endif // __fc_aux_ClientDiagLogIf__IF__H_


