
/*****************************************************************************
* FILE:         fc_aux_ClientDiagLogIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// fc_aux_tclClientDiagLogIfIncludes: user specific code start
extern bool bIsDiagnosisError;

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"
// fc_aux_tclClientDiagLogIfIncludes: user specific code end

#include "fc_aux_ClientDiagLogIf.h"
#include "Ifc_aux_ClientDiagLog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_CLIENT_DIAGLOG
#include "trcGenProj/Header/fc_aux_ClientDiagLogIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientDiagLogIf::
*             fc_aux_tclClientDiagLogIf(fc_aux_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientDiagLogIf::fc_aux_tclClientDiagLogIf(fc_aux_tclAppMain* poMainAppl) : 
Ifc_aux_tclClientDiagLogIf(poMainAppl)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf() entered."));
   _poClientRef = OSAL_NULL;

   // fc_aux_tclClientDiagLogIfConstructor: user specific code start
   // fc_aux_tclClientDiagLogIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientDiagLogIf::
*             ~fc_aux_tclClientDiagLogIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientDiagLogIf::~fc_aux_tclClientDiagLogIf(tVoid)
{
   ETG_TRACE_USR4(("~fc_aux_tclClientDiagLogIf() entered."));
   _poClientRef = OSAL_NULL;

   // fc_aux_tclClientDiagLogIfDestructor: user specific code start
   // fc_aux_tclClientDiagLogIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'fc_aux_ClientDiagLogIf.h':
*     Add forward declaration:
*         class Ifc_aux_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_aux_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_aux_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_aux_app_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ifc_aux_tclClientDiagLog*>(_cpoMain->getHandler("Ifc_aux_tclClientDiagLog"));

   FC_AUX_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // fc_aux_tclClientDiagLogIfvGetReferences: user specific code start
   // fc_aux_tclClientDiagLogIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::vStartCommunication() entered."));
   // fc_aux_tclClientDiagLogIfvStartCommunication: user specific code start
   // fc_aux_tclClientDiagLogIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   fc_aux_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(fc_aux_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // fc_aux_tclClientDiagLogIfvHandleMessage: user specific code start
   // fc_aux_tclClientDiagLogIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // fc_aux_tclClientDiagLogIfvHandleTraceMessage: user specific code start
   // fc_aux_tclClientDiagLogIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::vTraceInfo()
{
   // fc_aux_tclClientDiagLogIfvTraceInfo: user specific code start
   // fc_aux_tclClientDiagLogIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::onServiceAvailable() entered."));

   // fc_aux_tclClientDiagLogIfvOnServiceAvailable: user specific code start
   // fc_aux_tclClientDiagLogIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLogIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_aux_tclClientDiagLogIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLogIf::onServiceUnavailable() entered."));

   // fc_aux_tclClientDiagLogIfvOnServiceUnavailable: user specific code start
   // fc_aux_tclClientDiagLogIfvOnServiceUnavailable: user specific code end
}

tVoid fc_aux_tclClientDiagLogIf::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {
   ETG_TRACE_USR1( ( "fc_aux_tclClientDiagLogIf::onSendNextTestResultStatus(): CALLED" ) );

   // onSendNextTestResultStatus: user specific code start
   midw_fi_tcl_TestResult _oResult;
   midw_fi_tcl_TestResultList _oList;
   _oResult.TroubleCode = ITC_AUX_INPUT_1_OPEN;

   // Fix for NCG3D-78498
   // (If ITC_List == Empty, respond always to DiagSendNextTestResults() with all your ITC status.
   //  If ITC_List != Empty, do not respond to DiagSendNextTestResults() function call at all.)
   if(NextTestResultStruct.ITCList.empty() == true)
   {
	   if(bIsDiagnosisError == true)
	   {
		   _oResult.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
		   ETG_TRACE_USR4(("SendNextTestResult: Sending diagnosis trouble code: FAILED"));
	   }
	   else if (bIsDiagnosisError == false)
	   {
		   _oResult.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
		   ETG_TRACE_USR4(("SendNextTestResult: Sending diagnosis trouble code: OK"));
	   }

	   _oList.TestResultList.push_back(_oResult);
	   sendSaveTestResultMStart(_oList);
   }
   // onSendNextTestResultStatus: user specific code end
}

tVoid fc_aux_tclClientDiagLogIf::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {
   ETG_TRACE_USR1( ( "fc_aux_tclClientDiagLogIf::onSaveTestResultMResult(): CALLED" ) );

   // onSaveTestResultMResult: user specific code start
   // onSaveTestResultMResult: user specific code end
}



// fc_aux_tclClientDiagLogIffc_aux_ClientDiagLogIf: user specific code start
// fc_aux_tclClientDiagLogIffc_aux_ClientDiagLogIf: user specific code end

//EOF
