/************************************************************************
* FILE:        	fc_auxJackDetection.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	fc_aux
*----------------------------------------------------------------------
*
* DESCRIPTION: class for jack detection
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 13.05.2015| CM-AI/EPB2 Schurig | initial version
*
*************************************************************************/

#ifndef FC_AUXJACKDETECTION_H_
#define FC_AUXJACKDETECTION_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// include base class
#include "I_fc_auxJackDetection.h"
#include "I_fc_aux_ClientDiagLogIf.h"

// feature switch for scope 1
#define FEAT_SW_SET_JACK_DETECTION_FOR_SCOPE_ONE

class fc_auxJackDetection : public I_fc_auxJackDetection
{
public:

   fc_auxJackDetection(void){;};
   fc_auxJackDetection(const fc_aux_tclAppMain* poMainAppl);

   virtual ~fc_auxJackDetection();
   
   virtual const tChar* getName() const {return "fc_auxJackDetection";};

   virtual void vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg);
   virtual void vHandleTraceMessage(const tUChar* puchData);
   virtual void vGetReferences();
   virtual void vStartCommunication();
   virtual void vTraceInfo();
   
   virtual bool bGetVoltageIsOK();
   virtual void bSetVoltageIsOK(bool voltageIsOK);

   virtual void bSetJackConnected(bool jackConnected);
   virtual bool bGetJackConnectionState();
   virtual void vSetNewConnectionStatus(bool bIsNewDevice = false);

   virtual void vStartDetectionLoop(void);
   static void *vDetectionLoop(void *device_path);
   virtual void vEndDetectionLoop(void);

   virtual void vCallDiagLog();


private:
   tS32 m_s32MyThreadID;
   static fc_auxJackDetection*   _poJackDetectionInstance;
};
#endif /* FC_AUXJACKDETECTION_H_ */
