/************************************************************************
* FILE:        	fc_auxAudioRouting.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	fc_aux
*----------------------------------------------------------------------
*
* DESCRIPTION: class for audio routing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 27.05.2015| CM-AI/EPB2 Schurig | initial version
*
*************************************************************************/

#ifndef _FC_AUXAUDIOROUTING_H_
#define _FC_AUXAUDIOROUTING_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// include base class
#include "I_fc_auxAudioRouting.h"

// include Audio sources
#include "fc_aux_arl_tclISource.h"

#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#include "fc_aux_AudioRoutingLib.h"

class fc_auxAudioRouting : public I_fc_auxAudioRouting, public arl_tclISource
{
public:
	fc_auxAudioRouting(void){;};
	fc_auxAudioRouting(const fc_aux_tclAppMain* poMainAppl);
	virtual ~fc_auxAudioRouting();

	virtual const tChar* getName() const {return "fc_auxAudioRouting";};

	// To be implemented by I_fc_auxAudioRouting
	virtual void vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg);
	virtual void vHandleTraceMessage(const tUChar* puchData);
	virtual void vGetReferences();
	virtual void vStartCommunication();
	virtual void vTraceInfo();

	// To be implemented by audio_routing_lib( arl_tclISource )
    virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
    virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
    virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);

	virtual void vSetJackConnectionState(bool isConnected);
	bool bGetIsNewDevice() const { return _bIsNewDevice; }
	void bSetIsNewDevice(bool isNewDevice) { _bIsNewDevice = isNewDevice; }

protected:
	   bool _bIsNewDevice;
};

#endif // _FC_AUXAUDIOROUTING_H_
