/************************************************************************
* FILE:        	fc_auxAudioRouting.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	fc_aux
*----------------------------------------------------------------------
*
* DESCRIPTION: class for audio routing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date       | Author                  | Modification
* 27.05.2015 | CM-AI/EPB2 Schurig      | initial version
* 20.11.2015 | CM-CI1 / ERN4-E Schurig | Fix for NCG3D-3432
*************************************************************************/

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "fc_auxAudioRouting.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_AUDIO_ROUTING
#include "trcGenProj/Header/fc_auxAudioRouting.cpp.trc.h"
#endif

#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_aux_if.h"
#endif

#include "fc_aux_arl_tclISource.h"
#include "../../server/cca/AuxSrv/I_fc_aux_ServiceAuxSrvIf.h"

#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#include "fc_aux_AudioRoutingLib.h"


/*************************************************************************
 * Constructors / Destructor
 ************************************************************************/
fc_auxAudioRouting::fc_auxAudioRouting(const fc_aux_tclAppMain* poMainAppl)
: I_fc_auxAudioRouting(poMainAppl), arl_tclISource((ahl_tclBaseOneThreadApp*)poMainAppl)
{
    ETG_TRACE_USR4(("fc_auxAudioRouting::fc_auxAudioRouting() entered"));
	// temporarily initialize as available until jack detection is fully functional
	// Fix for NCG3D-3432
	bSetSourceAvailability(ARL_EN_SRC_PLAYABLE_UNKNOWN, ARL_EN_REASON_NEWMEDIA, ARL_SRC_AUX, 0);

	// initialize value
	bSetIsNewDevice(true);

	dp_tclAuxiliaryDPfcAuxBoolIsNewDevice AuxIsNewDevice;
	bSetIsNewDevice(AuxIsNewDevice.tGetData());

	// temporary fix for NCG3D-75187 (AUX is always active source after startup)
//	bSetIsNewDevice(false);
	ETG_TRACE_USR4(("_bIsNewDevice = %d",bGetIsNewDevice()));
}

fc_auxAudioRouting::~fc_auxAudioRouting()
{
	ETG_TRACE_USR4(("fc_auxAudioRouting::~fc_auxAudioRouting() entered"));
}

/*************************************************************************
 *
 * FUNCTION:    vHandleTraceMessage
 *
 * DESCRIPTION: handles the trace messages (if msgCode == 6)
 *              ==> new Connection
 *
 * PARAMETER:   const tUChar* puchData
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void fc_auxAudioRouting::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);

   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrv::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   if((u32MsgCode == 6) && (_cpoMain->getU8BrandOfTarget() == 8))
   {
	   // jack connected
	   if(puchData[3] == 0)
	   {
		   ETG_TRACE_USR4(("+===============+====================+==========================+=============+"));
		   ETG_TRACE_USR4(("| DETECT PLUG 1 | DETECT PLUG 1 DIAG | Meaning                  | DIAGNOSIS   |"));
		   ETG_TRACE_USR4(("+---------------+--------------------+--------------------------+-------------+"));
		   ETG_TRACE_USR4(("|      LOW      |         LOW        | Plug attached            |      OK     |"));
		   ETG_TRACE_USR4(("+===============+====================+==========================+=============+"));
		   bSetIsNewDevice(true);
		   vSetJackConnectionState(true);
	   }

	   // jack NOT connected
	   else if(puchData[3] == 1)
	   {
		   ETG_TRACE_USR4(("+===============+====================+==========================+=============+"));
		   ETG_TRACE_USR4(("| DETECT PLUG 1 | DETECT PLUG 1 DIAG | Meaning                  | DIAGNOSIS   |"));
		   ETG_TRACE_USR4(("+---------------+--------------------+--------------------------+-------------+"));
		   ETG_TRACE_USR4(("|      HIGH     |         LOW        | Plug NOT attached        |      OK     |"));
		   ETG_TRACE_USR4(("+===============+====================+==========================+=============+"));
		   vSetJackConnectionState(false);
	   }
   }
}

/*************************************************************************
 *
 * FUNCTION:    vSetJackConnectionState
 *
 * DESCRIPTION: set the availability according the jack connection state
 *
 * PARAMETER:   tBool isConnected
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void fc_auxAudioRouting::vSetJackConnectionState(bool isConnected)
{
	ETG_TRACE_USR4(("fc_auxAudioRouting::vSetJackConnection() entered"));

	Ifc_aux_tclServiceAuxSrvIf* _FIservice = dynamic_cast<Ifc_aux_tclServiceAuxSrvIf*>(_cpoMain->getHandler("Ifc_aux_tclServiceAuxSrvIf"));
	FC_AUX_NULL_POINTER_CHECK(_FIservice);

	aux_fi_tcl_AUX_States aux_states;
	aux_fi_tcl_AUX_State myState;


	// If true, we are a RENAULT target and request to be played
	if(_cpoMain->getU8BrandOfTarget() == 0x08)
	{
		// If true, a jack has been connected
		if(isConnected == TRUE)
		{
			// If true, it is a new plugged device and needs to be played automatically.
			// If false, it needs to be reported to audio routing lib, but not played automatically.
			if(bGetIsNewDevice() == TRUE)
			{
				ETG_TRACE_USR4(("fc_auxAudioRouting::vSetJackConnection() TRUE, Reporting NEW MEDIA DEVICE"));

				myState.eAuxAvailState.enType = aux_fi_tcl_e8_AUXAvailabilityState::FI_EN_AUX_AVAIL;
				myState.eAuxSwitchState.enType = aux_fi_tcl_e8_AUXSwitchState::FI_EN_AUX_PLUGGED;
				myState.eAuxConState.enType = aux_fi_tcl_e8_AUXConnectionState::FI_EN_AUX_UNKNOWN;

				aux_states.oItems.push_back(myState);

				_FIservice->sendAvailibilityStatus(aux_states);

				bSetSourceAvailability(ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_NEWMEDIA,ARL_SRC_AUX,0);
			}
			else
			{
				// In this case the system has shut down with connected, but not activated AUX plug.
				ETG_TRACE_USR4(("fc_auxAudioRouting::vSetJackConnection() TRUE, Reporting SAME MEDIA DEVICE"));

				myState.eAuxAvailState.enType = aux_fi_tcl_e8_AUXAvailabilityState::FI_EN_AUX_AVAIL;
				myState.eAuxSwitchState.enType = aux_fi_tcl_e8_AUXSwitchState::FI_EN_AUX_PLUGGED;
				myState.eAuxConState.enType = aux_fi_tcl_e8_AUXConnectionState::FI_EN_AUX_UNKNOWN;

				aux_states.oItems.push_back(myState);

				_FIservice->sendAvailibilityStatus(aux_states);

				bSetSourceAvailability(ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_SAMEMEDIA,ARL_SRC_AUX,0);
			}
		}
		else
		{
			// Plug as been disconnected
			ETG_TRACE_USR4(("fc_auxAudioRouting::vSetJackConnection() FALSE"));

			myState.eAuxAvailState.enType = aux_fi_tcl_e8_AUXAvailabilityState::FI_EN_AUX_UNAVAIL;
			myState.eAuxSwitchState.enType = aux_fi_tcl_e8_AUXSwitchState::FI_EN_AUX_UNPLUGGED;
			myState.eAuxConState.enType = aux_fi_tcl_e8_AUXConnectionState::FI_EN_AUX_UNKNOWN;

			aux_states.oItems.push_back(myState);

			_FIservice->sendAvailibilityStatus(aux_states);

			bSetSourceAvailability(ARL_EN_SRC_NOT_PLAYABLE,ARL_EN_REASON_NOMEDIA,ARL_SRC_AUX,0);
		}
	}

	// we are anything else but Renault and need to be activate
	else // if(_cpoMain->getU8BrandOfTarget() == 0x06) NCG3D_43127
	{
		ETG_TRACE_USR4(("Connection State: NISSAN (Always SAME device)"));
		myState.eAuxAvailState.enType = aux_fi_tcl_e8_AUXAvailabilityState::FI_EN_AUX_AVAIL;
		myState.eAuxSwitchState.enType = aux_fi_tcl_e8_AUXSwitchState::FI_EN_AUX_PLUGGED;
		myState.eAuxConState.enType = aux_fi_tcl_e8_AUXConnectionState::FI_EN_AUX_UNKNOWN;

	    aux_states.oItems.push_back(myState);

		_FIservice->sendAvailibilityStatus(aux_states);

		bSetSourceAvailability(ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_SAMEMEDIA,ARL_SRC_AUX,0);
	}
}

/*************************************************************************
 *
 * FUNCTION:    vOnNewAppStateNotify
 *
 * DESCRIPTION: reports source available as soon as audio is up
 *
 * PARAMETER:   tU32 u32OldAppState
 *              tU32 u32AppState
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void fc_auxAudioRouting::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
   ETG_TRACE_USR4(("vOnNewAppStateNotify: oldState=%d, newState=%d", u32OldAppState, u32AppState));
   // Removed due to NCG3D-3432
   // vSetSrcAvailable(true);
}

/*************************************************************************
 *
 * FUNCTION:    bOnSrcActivity
 *
 * DESCRIPTION: calls vSourceActivityResult and set some values
 *              according the handed over parameters
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *              const arl_tSrcActivity& rfcoSrcActivity
 *
 * RETURNVALUE: bool (true)
 *
 ************************************************************************/
tBool fc_auxAudioRouting::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
	ETG_TRACE_USR4(("fc_auxAudioRouting::bOnSourceActivity() entered"));
	if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_ON)
	{
	    vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON);
	}
	else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
    {
        vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
    }
    else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE)
    {
        vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_PAUSE);
    }
    return true;
}

/*************************************************************************
 *
 * FUNCTION:    bOnDeAllocate
 *
 * DESCRIPTION: returns true
 *              needs to be implemented according audio lib
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *
 * RETURNVALUE: bool
 *
 ************************************************************************/
tBool fc_auxAudioRouting::bOnDeAllocate(arl_tenSource enSrcNum)
{
	ETG_TRACE_USR4(("fc_auxAudioRouting::bOnDeAllocate() entered"));
	return true;
}

/*************************************************************************
 *
 * FUNCTION:    bOnAllocate
 *
 * DESCRIPTION: returns true
 *              needs to be implemented according audio lib
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *              const arl_tAllocRouteResult& rfcoAllocRoute
 *
 * RETURNVALUE: bool
 *
 ************************************************************************/
tBool fc_auxAudioRouting::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
{
	ETG_TRACE_USR4(("fc_auxAudioRouting::bOnAllocate() entered"));
	return true;
}

// needs to be implemented
void fc_auxAudioRouting::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg) {}
void fc_auxAudioRouting::vGetReferences() {}
void fc_auxAudioRouting::vStartCommunication() {}
void fc_auxAudioRouting::vTraceInfo() {}














