/************************************************************************
* FILE:         vdmmgr_trace.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device MediaManager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 17.10.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_TRACE_H_
#define _VDMMGR_TRACE_H_

///*******************************************************************************
//| includes of component-internal interfaces, if necessary
//| (scope: component-local)
//|-----------------------------------------------------------------------------*/
//
#include "Config.h"

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/
#define FOR_FUTURE_USE(parm) (tVoid)(parm)

// Base identifier for VD MMgr (1024 * 46) 0x4500 (taken from tri_types.h->TR_COMP_VD_MEDIAMANAGER)
#ifndef TR_COMP_MEDIAMANAGER
   #define TR_COMP_MEDIAMANAGER     (256 * 69)              // 0x4500
#endif // TR_COMP_MEDIAMANAGER

#define VDMMGR_TR                   (TR_COMP_MEDIAMANAGER + 0x00)  // 0x4500
#define VDMMGR_TR_MAIN              (TR_COMP_MEDIAMANAGER + 0x01)  // 0x4501 -> Traces in 
#define VDMMGR_TR_SERVICE           (TR_COMP_MEDIAMANAGER + 0x02)  // 0x4502 -> Traces in 
#define VDMMGR_TR_CLIENTSPM         (TR_COMP_MEDIAMANAGER + 0x03)  // 0x4503 -> Traces in SPM client
#define VDMMGR_TR_CDCTRLIF          (TR_COMP_MEDIAMANAGER + 0x05)  // 0x4505 -> Traces in trace class cdcdtrl1 (CD) interface
#define VDMMGR_TR_TIMER             (TR_COMP_MEDIAMANAGER + 0x07)  // 0x4507 -> Traces in timer class
#define VDMMGR_TR_TRACE             (TR_COMP_MEDIAMANAGER + 0x08)  // 0x4508 -> Traces in trace class
#define VDMMGR_TR_CLIENTDIAGLOG     (TR_COMP_MEDIAMANAGER + 0x09)  // 0x4509 -> Traces in DiagLog client
#define VDMMGR_TR_ERRORIF           (TR_COMP_MEDIAMANAGER + 0x11)  // 0x4511 -> Traces in error IF of CD
#define VDMMGR_TR_SERVICE_CD        (TR_COMP_MEDIAMANAGER + 0x12)  // 0x4512 -> Traces in 
#define VDMMGR_TR_SERVICE_DIAG      (TR_COMP_MEDIAMANAGER + 0x13)  // 0x4513 -> Traces in 

// \enum mmgr_tenTraceClass
// Trace Class Enumeration.
typedef enum
{
     TR_CLASS_MEDIAMANAGER                =  TR_COMP_MEDIAMANAGER + 0x00   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_MAIN           =  TR_COMP_MEDIAMANAGER + 0x01   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_SERVICE        =  TR_COMP_MEDIAMANAGER + 0x02   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_CLIENTSPM      =  TR_COMP_MEDIAMANAGER + 0x03   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_CDCTRLIF       =  TR_COMP_MEDIAMANAGER + 0x05   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_TIMER          =  TR_COMP_MEDIAMANAGER + 0x07   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_TRACE          =  TR_COMP_MEDIAMANAGER + 0x08   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_CLIENTDIAGLOG  =  TR_COMP_MEDIAMANAGER + 0x09   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_ERRORIF        =  TR_COMP_MEDIAMANAGER + 0x11   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_SERVICE_CD     =  TR_COMP_MEDIAMANAGER + 0x12   ///< Enum value for
   , TR_CLASS_MEDIAMANAGER_SERVICE_DIAG   =  TR_COMP_MEDIAMANAGER + 0x13   ///< Enum value for
} mmgr_tenTraceClass;

// SPM Client
#define VDMMGR_TR_CLIENTSPM_24      0x0024      // vHandleStartUpReason(): New StartUpReason: %u(STARTUP_REASON,8)

#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   // cdctrl1 (CD) interface
   #define VDMMGR_TR_CDCTRLIF_2D    0x002D         // Start: New callback: info from /dev/cdtrl
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE

#define VDMMGR_TR_99                0x0099         // OSAL error code for error macro
#define VDMMGR_TR_9B                0x009B         // string trace code for error macro
#define VDMMGR_TR_9D                0x009D         // pointer code for error macro
#define VDMMGR_TR_9E                0x009E         // invalid pointer code for error macro

#define TRACE_OSAL_ERROR( VDMMGR_TRACE_CLASS )  \
{                                               \
   tU32 u32ErrorCode = OSAL_u32ErrorCode();     \
   ET_TRACE_ERROR_BIN( VDMMGR_TRACE_CLASS, ET_EN_T16 _ VDMMGR_TR_99 _ ET_EN_T16 _ __LINE__ _ ET_EN_T32 _ u32ErrorCode _ \
                       ET_EN_STRING _ OSAL_coszErrorText( u32ErrorCode ) _  ET_EN_DONE ); \
}

// ---   TRACE_Error, Warning, Info   ---
//
//  |  6  ...  7  |  8  ...  9  |  10  ...  x  |
//  |   MsgCode   |    LineNo   |    String    |
   
#define TRACE_Error(szErrString, u16Class)                  \
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_ERRORS))  \
      et_vTraceBinary                                       \
      (                                                     \
         u16Class,                                          \
         (tU16) TR_LEVEL_ERRORS,                            \
         ET_EN_T16 _ VDMMGR_TR_9B _                         \
         ET_EN_T16 _  __LINE__  _                           \
         ET_EN_STRING _  szErrString _                      \
         ET_EN_DONE                                         \
      )    

#define TRACE_Warning(szErrString, u16Class)                 \
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_WARNING) ) \
      et_vTraceBinary                                        \
      (                                                      \
         u16Class,                                           \
         (tU16) TR_LEVEL_WARNING,                            \
         ET_EN_T16 _ VDMMGR_TR_9B _                          \
         ET_EN_T16 _  __LINE__  _                            \
         ET_EN_STRING _  szErrString _                       \
         ET_EN_DONE                                          \
      )    

#define TRACE_Info(u16Level, szString, u16Class)         \
   if (et_bIsTraceActive(u16Class, (tU16)u16Level))      \
      et_vTraceBinary                                    \
      (                                                  \
         u16Class,                                       \
         (tU16) u16Level,                                \
         ET_EN_T16 _ VDMMGR_TR_9B _                      \
         ET_EN_T16 _ __LINE__ _                          \
         ET_EN_STRING _  szString _                      \
         ET_EN_DONE                                      \
      )    

// ---   TRACE_(On_)OSAL_Error   ---
//
//  |  6  ...  7  |  8  ...  9  |  10  ... 13  |  14  ...  x  |
//  |   MsgCode   |    LineNo   |  Error-Code  |  Error-Text  |
   
#define TRACE_OSAL_Error( u16Class )                          \
{    tU32 ___ErrorCode = OSAL_u32ErrorCode();                 \
      if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_ERRORS)) \
      et_vTraceBinary(u16Class,                               \
      (tU16) TR_LEVEL_ERRORS,                                 \
      ET_EN_T16 _ VDMMGR_TR_99 _                              \
      ET_EN_T16 _ __LINE__  _                                 \
      ET_EN_T32 _ ___ErrorCode _                              \
      ET_EN_STRING _ OSAL_coszErrorText(___ErrorCode) _       \
      ET_EN_DONE                                              \
      );                                                      \
}

#define TRACE_On_OSAL_Error( RetCode, u16Class )         \
{                                                        \
   if ((intptr_t) RetCode == (intptr_t) OSAL_ERROR)                            \
   {                                                     \
      TRACE_OSAL_Error(u16Class);                        \
   };                                                    \
}

// ---   TRACE_(Invalid)Pointer   ---
//
//  |  6  ...  7  |  8  ...  9  |  10  ...  13   |  14  ...  x  |
//  |   MsgCode   |    LineNo   |    Pointer     | PointerName  |
   
#define TRACE_On_Invalid_Pointer( Pointer, PointerName, u16Class )   \
{                                                                    \
   if ((et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_ERRORS))          \
         && ((Pointer == NULL) || ((intptr_t) Pointer == (intptr_t) OSAL_ERROR)))   \
   {                                                                 \
      et_vTraceBinary                                                \
      (                                                              \
      u16Class,                                                      \
      (tU16) TR_LEVEL_ERRORS,                                        \
      ET_EN_T16 _ VDMMGR_TR_9D _                                     \
      ET_EN_T16 _ __LINE__ _                                         \
      ET_EN_T32 _ (tU32) ((Pointer == NULL) ? 0 : OSAL_ERROR ) _     \
      ET_EN_STRING _ PointerName _                                   \
      ET_EN_DONE                                                     \
      );                                                             \
      TRACE_On_OSAL_Error((intptr_t) Pointer, u16Class);                 \
   }                                                                 \
}
/* else if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_DATA))          \
   {                                                                 \
      et_vTraceBinary                                                \
      (                                                              \
      u16Class,                                                      \
      (tU16) TR_LEVEL_DATA,                                          \
      ET_EN_T16 _ VDMMGR_TR_9E _                                     \
      ET_EN_T16 _ __LINE__ _                                         \
      ET_EN_T32 _ (tU32) Pointer _                                   \
      ET_EN_STRING _ PointerName _                                   \
      ET_EN_DONE                                                     \
      );                                                             \
   }                                                                 \*/

// ---   TRACE_(Invalid)Pointer   ---
//
//  |  6  ...  7  |  8  ...  9  |  10  ...  13   |  14  ...  x  |
//  |   MsgCode   |    LineNo   |    Pointer     | PointerName  |
   
#define TRACE_Pointer( Pointer, PointerName, u16Class )           \
{                                                                 \
   if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_DATA))          \
   {                                                              \
      et_vTraceBinary                                             \
      (                                                           \
      u16Class,                                                   \
      (tU16) TR_LEVEL_DATA,                                       \
      ET_EN_T16 _ VDMMGR_TR_9E _                                  \
      ET_EN_T16 _ __LINE__ _                                      \
      ET_EN_T32 _ (tU32) Pointer _                                \
      ET_EN_STRING _ PointerName _                                \
      ET_EN_DONE                                                  \
      );                                                          \
   }                                                              \
}

// ---   TRACE_CCA_xxMessage   ---
//
//  |   6    |    7    |  8  ...  9  | 10  ... 11 | 12  ... 13 |    14    | 15  ...   |
//  |  File  | MsgCode |    LineNo   |    AppID   | FunctionID |  OpCode  |  Payload  |
   
#define TRACE_CCA_InMessage(poMessage, u16Class)                  \
{                                                                 \
 tU16 __class = 0;                                                \
 if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_1))          \
   __class = u16Class;                                            \
 else if (et_bIsTraceActive(VDMMGR_TR, (tU16)TR_LEVEL_USER_1))    \
   __class = VDMMGR_TR;                                           \
 tU8 __file = (tU8)(u16Class & 0xFF);                             \
 if (__class)                                                     \
 {                                                                \
   tU32 u32MsgSize = (poMessage)->u32GetSize();                   \
   if (u32MsgSize > 287) {u32MsgSize = 287;}                      \
   tU8 u8DataSize = (tU8) (u32MsgSize - 32);                      \
   {                                                              \
      tU8* pu8MsgData = (poMessage)->pu8GetSharedMemBase() + 32;  \
      et_vTraceBinary                                             \
      (                                                           \
         __class,                                                 \
         (tU16) TR_LEVEL_USER_1,                                  \
         ET_EN_T8 _ (tU8) __file  _                               \
         ET_EN_T8 _  0xD0 _                                       \
         ET_EN_T16 _  __LINE__  _                                 \
         ET_EN_T16 _ (poMessage)->u16GetSourceAppID() _           \
         ET_EN_T16 _ (poMessage)->u16GetFunctionID() _            \
         ET_EN_T8  _ (poMessage)->u8GetOpCode() _                 \
         ET_EN_T8LIST _ u8DataSize _ pu8MsgData _                 \
         ET_EN_DONE                                               \
      );                                                          \
    }                                                             \
 }                                                                \
}                                                                 \

#define TRACE_CCA_OutMessage(poMessage, u16Class, u16Line)        \
{                                                                 \
 tU16 __class = 0;                                                \
 if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_1))          \
   __class = u16Class;                                            \
 else if (et_bIsTraceActive(VDMMGR_TR, (tU16)TR_LEVEL_USER_1))    \
   __class = VDMMGR_TR;                                           \
 tU8 __file = (tU8)(u16Class & 0xFF);                             \
 if (__class)                                                     \
 {                                                                \
   tU32 u32MsgSize = (poMessage)->u32GetSize();                   \
   if (u32MsgSize > 287) {u32MsgSize = 287;}                      \
   tU8 u8DataSize = (tU8) (u32MsgSize - 32);                      \
   {                                                              \
      tU8* pu8MsgData = (poMessage)->pu8GetSharedMemBase() + 32;  \
      et_vTraceBinary                                             \
      (                                                           \
         __class,                                                 \
         (tU16) TR_LEVEL_USER_1,                                  \
         ET_EN_T8 _  __file  _                                    \
         ET_EN_T8 _ 0xD1 _                                        \
         ET_EN_T16 _ u16Line _                                    \
         ET_EN_T16 _ (poMessage)->u16GetTargetAppID() _           \
         ET_EN_T16 _ (poMessage)->u16GetFunctionID() _            \
         ET_EN_T8  _ (poMessage)->u8GetOpCode() _                 \
         ET_EN_T8LIST _ u8DataSize _ pu8MsgData _                 \
         ET_EN_DONE                                               \
      );                                                          \
   }                                                              \
  }                                                               \
}

// ---   TRACE_Value   ---
//
//  |  6  ...  7  |  8  ...  9  | 10  ... 13  | 14  ...  x  |
//  |   MsgCode   |    LineNo   |    Value    | Description |
   
#define TRACE_Value(Level, iValue, szDescription, u16Class)       \
   if (et_bIsTraceActive(u16Class, (tU16) Level))                 \
      et_vTraceBinary                                             \
      (                                                           \
         u16Class,                                                \
         (tU16) Level,                                            \
         ET_EN_T16 _ 0x00FF _                                     \
         ET_EN_T16 _ __LINE__ _                                   \
         ET_EN_T32 _ (tU32) iValue _                              \
         ET_EN_STRING _ szDescription _                           \
         ET_EN_DONE                                               \
      )    

// ---   TRACE_SPM_Transition   ---
//
//  |  6  ...  7  |  8  ...  9  | 10  ... 13 | 14  ... 17 |
//  |   MsgCode   |    LineNo   |  OldState  |  NewState  |
   
#define TRACE_SPM_Transition(OldState, NewState, u16Class)     \
{                                                              \
 tU16 __class = 0;                                             \
 if (et_bIsTraceActive(u16Class, (tU16)TR_LEVEL_USER_1))       \
   __class = u16Class;                                         \
 else if (et_bIsTraceActive(VDMMGR_TR, (tU16)TR_LEVEL_USER_1)) \
   __class = VDMMGR_TR;                                        \
 tU8 __file = (tU8)(u16Class & 0xFF);                          \
 if (__class)                                                  \
      et_vTraceBinary                                          \
      (                                                        \
         __class,                                              \
         (tU16) TR_LEVEL_USER_1,                               \
         ET_EN_T8  _  __file _                                 \
         ET_EN_T8  _  0xd4  _                                  \
         ET_EN_T16 _  __LINE__  _                              \
         ET_EN_T16 _ OldState _                                \
         ET_EN_T16 _ NewState _                                \
         ET_EN_DONE                                            \
      );                                                       \
}

// ============================================================================


class vdmmgr_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'


// This is the TTFis trace service
class vdmmgr_tclTrace
{
   public:
   // Constructors and destructors
   vdmmgr_tclTrace( tVoid );
   vdmmgr_tclTrace( vdmmgr_tclApp*  poVdMmgrMainApp );
   ~vdmmgr_tclTrace();
   // Send and Receive the data   
   tVoid             vdmmgr_Trace_vRx                    ( tPCU8 pu8Data ) const;
   tVoid             vSimulateEventAfterOsalNotification ( tU8 u8MsgCode, tU8 u8Data1, tU8 u8Data2, tU8 u8Data3=0 ) const;

   private:
      // Reference to Main
      vdmmgr_tclApp*        poMain;
};

#endif   // #if defined _VDMMGR_TRACE_H_
