/************************************************************************
* FILE:         vdmmgr_timer.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device MediaManager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 08.07.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_TIMER_H_
#define _VDMMGR_TIMER_H_


//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vdmmgr_tclservice;//lint !e763 Info 763;Redundant declaration for symbol 'x'


#define VDMMGR_TIMERTYPE_AUTOMATIC_REINSERT              1
#define VDMMGR_TIMERTYPE_ENSURE_CD_NO_MEDIA              3
#define VDMMGR_TIMERTYPE_CD_GET_TEMPERATURE              7

class vdmmgr_tclTimer
{
   private:
      // Private functions
      // Private variables
      tU32                 _u32Timeout;
      tU32                 _u32TimerInterval;
      OSAL_tTimerHandle    _phTimerHandle;   //Handle of the Timer 
      OSAL_tpfCallback     _pfOnTimer;  
      // Private static functions
      static void vOnTimeoutCdAutomaticReinsert       ( tPVoid arg );
      static void vOnTimeoutEnsureCdNoMedia           ( tPVoid arg );
      static void vOnCdTemperatureTimerTimeout        ( tPVoid arg );
      // Private static ariables

   public:
      // Public functions
      // connstructor / destructor
      vdmmgr_tclTimer ( );
      ~vdmmgr_tclTimer( );

      tBool    Create( tU32 u32TimerMSec, tU32 u32TimerIntervalMSec,
                       vdmmgr_tclservice* _poMmgrService, tU32 u32Arg );
      tBool    bStart( );
      tBool    bReset( );
      tBool    bStop ( );
      tVoid    vDelete( );
};

#endif //_VDMMGR_TIMER_H_


