/************************************************************************
* FILE:         vdmmgr_service.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.05.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_SERVICE_H_
#define _VDMMGR_SERVICE_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vdmmgr_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

// makeu16 -> make word. Get two bytes and use one as low and one as high byte
#define MAKEU16( u8Low, u8High )  ( (tU16) (( (tU8)(u8Low)) | ( ( (tU16)( (tU8) (u8High))  ) << 8) ) )

#define VDMMGR_TIMER_TIMEOUT_FIRST_AUTOMATI_CDREINSERT   10000
#define VDMMGR_TIMER_TIMEOUT_FIRST_ENSURE_CD_NO_MEDIA    5000
#define VDMMGR_TIMER_TIMEOUT_INTERVALL                   0

#define VDMMGR_TIME_DELAY_NEW_APPSTATE_FOR_CDINSERT      20000    // 20s to insert CD at system shutdown

#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER
   #define VDMMGR_WAITTIME_CD_REINSERT                   870      // necessary for PIONEER
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER

// for last mode use
#define VDMMGR_LM_MODULE_VERSION                         4  // 1 -> 2: add xxLockStatus; 2 -> 3 add bUsbInfiniteReInit -> 4 remove LockStatus and UsbReInit
#define VDMMGR_LM_FILE_NAME                              "VDMMGR_LMM.DAT"

#define VDMMGR_LMM_FULL_PATHNAME                         OSAL_C_STRING_DEVICE_FFS "/" \
                                                         VDMMGR_LM_FILE_NAME
// Define for use in elements of trMessageDataForMethodResult -> u32InternalData
#define VDMMGR_DIAG_EJECT_CD_STARTED                     0x00000001

#define VDMMGR_DIAG_INIT                                 0        // Init value

#define UNIQUE_ID_LENGTH                                 33

// mmgr-lmm data structur
typedef struct
{
   tU16           u16LmmVersion;
   tU16           u16WriteCount;
   T_e8_CdType    e8CDType;
} vdmmgr_trLastModeData;

// 'message data to send method result' data structur
typedef struct
{
   tU16           u16SourceAppID;
   tU16           u16RegisterID;
   tU16           u16CmdCounter;
   tU16           u16FunctionID;
   tU16           u16SourceSubID;
   tU32           u32InternalData;
} trMessageDataForMethodResult;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdmmgr_tclservice : public ahl_tclBaseWork
{
private:
   OSAL_tSemHandle                           hNotTableSem;
   ahl_tclNotificationTable*                 poNotTable;             //gets NotifactionTable from parent
   tBool                                     _bSendStatusOK;         // TRUE if service available, FALSE if service is not available

   // +++   Enter your private Data and functions here   +++
   T_e8_CdType                               _e8ActCDType;
   T_e8_CdType                               _e8CDTypeBeforeEject;
   T_e8_CdState                              _e8ActCDState;
   T_e8DeviceState                           _e8ActCDDeviceState;
   T_e8_InsertState                          _e8ActCDInsertState;
   tBool                                     _e8CdDrivevMounted;
   mplay_fi_tcl_DriveErrorInfo                _clActDriveError;
   mplay_fi_tcl_e8_DiagnosisTestType::tenType _e8CheckDiskInitiator;
   tBool                                     _bAppStateChangeWaitForInsert;
   tChar                                     _szcUniqueDeviceID[UNIQUE_ID_LENGTH];   /*Unique media ID*/
   
   vdmmgr_tclservice();//lint !e1704 ;Constructor 'vdmmgr_tclservice::vdmmgr_tclservice(void)' has private access specification

protected:
   //---------------------------------------------------------------------
   virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
   //---------------------------------------------------------------------
   T_DiagDriveVersion      _diagDriveVersion;

public:
   vdmmgr_tclApp*                            poMain;
   tBool                                     _bEjectStartet;
   vdmmgr_tclTimer                           _oAutoReInsertTimer;    // 'automatic reinsert' timer
   vdmmgr_tclTimer                           _oEnsureCdNoMediaTimer; // 'ensure CD NO_MEDIA' timer; due to missing Tanashin CD drive info
   // For simulation via TTFis
   tBool                                     _bSimulatedSelectTrackType;
   tBool                                     _bSimulatedCdDriveTest;

   //typedef const bpstl::vector<mplay_fi_tcl_DiagTroubleStatus,bpstl::allocator<mplay_fi_tcl_DiagTroubleStatus> >*  CP_TSL_V; // const pointer to vector of diagnosis trouble status
   typedef const std::vector<mplay_fi_tcl_DiagTroubleStatus,std::allocator<mplay_fi_tcl_DiagTroubleStatus> >*  CP_TSL_V; // const pointer to vector of diagnosis trouble status

   //---------------------------------------------------------------------
   vdmmgr_tclservice( vdmmgr_tclApp* poMain ); // constructor
   //---------------------------------------------------------------------

   tVoid vSetIsSendStatusOK                  ( tBool bSendStatusOK );
   tVoid vSendVisitorMessage                 ( fi_tclVisitorMessage*  poResultMsg, tU16 u16AppId );
   tVoid vSendStatusVisitorMessage           ( const ahl_tNotification* pNot, tU16 u16FID, fi_tclVisitorMessage* poResultMsg );
   tVoid vSendStatusAnswerVisitorMessage     ( const amt_tclServiceData* poMessage, fi_tclVisitorMessage* poResultMsg, const trMessageDataForMethodResult* poMsgData=NULL );
   tVoid vSendMethodResultVisitorMessage     ( const amt_tclServiceData* poMessage, fi_tclVisitorMessage* poResultMsg, tU8 u8Opcode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT );
   tVoid vCopyMsgDataToStoreForAnswer        ( const amt_tclServiceData* poMessage, trMessageDataForMethodResult* pStoreStruct ) const;
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vSendStatusCDInfo                   ( T_e8_CdType e8ActCDType, T_e8_CdState e8ActCDState, T_e8_InsertState e8ActCDInsertState, T_e8DeviceState e8DeviceState );
   tVoid vSendStatusCDTemp                   ( tS16 s16CDTemp, T_e8DriveTempSensorStatus DriveTempSensorStatus );
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vSendStatusDriveErrorInformation    ( const mplay_fi_tcl_DriveErrorInfo* pclDriveErrorInfo );
   //---------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vSendAnswerCDInfo                   ( const amt_tclServiceData* poMessage, T_e8_CdType e8ActCDType, T_e8_CdState e8ActCDState, 
                                               T_e8_InsertState e8ActCDInsertState, T_e8DeviceState e8DeviceState );
   tVoid vSendAnswerCDEject                  ( const amt_tclServiceData* poMessage, T_e8_MMgr_MethodResult enMsgResult );
   tVoid vSendAnswerCDInsert                 ( const amt_tclServiceData* poMessage, T_e8_MMgr_MethodResult enMsgResult );
   tVoid vSendAnswerCDTemp                   ( const amt_tclServiceData* poMessage, tS16 s16CDTemp, T_e8DriveTempSensorStatus DriveTempSensorStatus, const trMessageDataForMethodResult* poMsgData=NULL );
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vSendAnswerDriveErrorInformation    ( const amt_tclServiceData* poMessage, const mplay_fi_tcl_DriveErrorInfo* pclDriveErrorInfo );
   //---------------------------------------------------------------------
   tBool bUpreg                              ( const amt_tclServiceData* poMessage );
   //---------------------------------------------------------------------
   tBool bRelUpreg                           ( const amt_tclServiceData* poMessage );
   //---------------------------------------------------------------------
   tU32 u32OnNewAppState                     ( tU32 u32OldAppState, tU32 u32AppState );
   //---------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vHandleCDInfo                       ( amt_tclServiceData* poMessage );
   tVoid vHandleEject                        ( amt_tclServiceData* poMessage );
   tVoid vHandleInsert                       ( amt_tclServiceData* poMessage );
   tVoid vHandleCDTemp                       ( amt_tclServiceData* poMessage );
   tVoid vNewCdType                          ( T_e8_CdType enNewCDType, tBool bSendImmediately=TRUE );
   tVoid vNewCdState                         ( T_e8_CdState enNewCDState, tBool bSendImmediately=TRUE );
   tVoid vNewCdDeviceState                   ( T_e8DeviceState e8NewCdDeviceState, tBool bSendImmediately=TRUE );
   tVoid vNewStateInsert                     ( T_e8_InsertState enNewCDInsertState, tBool bSendImmediately=TRUE );
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vHandleDriveErrorInformation        ( amt_tclServiceData* poMessage );

   // Functions for Diagnosis Interface
   tVoid vSendAnswerDiagFirmwareVersion      ( const amt_tclServiceData* poMessage, const T_DiagFirmwareVersion* pDiagFirmwareVersion );
   tVoid vSendAnswerDiagDriveVersion         ( const amt_tclServiceData* poMessage, const T_DiagDriveVersion* pDiagDriveVersion );
   tVoid vSendAnswerDiagLoadStatus           ( const amt_tclServiceData* poMessage, T_e8_DiagLoadStatus e8LoadStatus );
   tVoid vSendAnswerDiagErrorStatus          ( const amt_tclServiceData* poMessage, CP_TSL_V poTroubleCodeStatusList );
   tVoid vSendAnswerDiagDriveTest            ( const trMessageDataForMethodResult* poMsgDataForResult, const T_DiagMethodControlResultDriveTest* pDiagResultDriveTest );
   tVoid vSendAnswerDiagDriveTestFirstMessageResult( const trMessageDataForMethodResult* poMsgDataForResult, tU8 u8Opcode );
   tVoid vSendAnswerDiagEject                ( const trMessageDataForMethodResult* poMsgDataForResult, const T_DiagMethodControlResultEject* pDiagResultEject );
   tVoid vSendAnswerDiagPerformTest          ( const amt_tclServiceData* poMessage, const mplay_fi_tcl_DiagTestRoutineList* pDiagResultPerformTest );
   tVoid vSendAnswerReadOnlyDevInterfaceTest ( const amt_tclServiceData* poMessage, mplay_fi_tcl_e8_DiagnosisTestType::tenType e8TestInitiator,
                                               mplay_fi_tcl_DiagTestResult::tenType e8TestResult );
   tVoid vSendMethodResultDiagDrvTest        ( T_e8_DiagRetValueDriveTest e8TestResult, T_e8_DiagDuration e8Duration, const T_DiagMethodResultDrvTest* pDiagMethodResultDrvTest );
   tVoid vSendMethodResultFirstDiagDrvTest   ( tVoid );
   tVoid vSendMethodResultDiagSelectTrackType( T_e8_TrackType e8ActTrType, T_e8_TrackType e8ReqTrType, T_e16_TrackTypeResult e8Result);

   tVoid vHandleDiagFirmwareVersion          ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagDriveVersion             ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagLoadStatus               ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagErrorStatus              ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagDriveTest                ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagEject                    ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagPerformTest              ( amt_tclServiceData* poMessage );
   tVoid vHandleReadOnlyDevInterfaceTest     ( amt_tclServiceData* poMessage );
   tVoid vHandleDiagCdSelectTrackType        ( amt_tclServiceData* poMessage );

   tU32  u32SendCDInsertEvDueToNewAppState   ( tVoid );

   //---------------------------------------------------------------------
   tVoid vSendError                          ( amt_tclServiceData* poInMessage, tU16 u16ErrorCode, tU16 u16Class,  tU32 u32Line ) const;
   //---------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid             vGetLastModeData        ( tVoid );
   tVoid             vReadLastModeData       ( OSAL_tIODescriptor fdLmmMmgr );
   tVoid             vCreateLastModeFile     ( tVoid ) const;
   tVoid             vSetLastModeData        ( tVoid );
   tVoid             vWriteLastModeData      ( OSAL_tIODescriptor fdLmmMmgr ) const;
   tVoid             vReadKdsCd              ( tVoid );
   tVoid             vSetInsertStateAfterLastModeData( tVoid );
   T_e8_CdType       enGetActCdType          ( tVoid ) const;
   T_e8_CdState      enGetActCDState         ( tVoid ) const;
   T_e8_InsertState  enGetActCDInsertState   ( tVoid ) const;
   T_e8DeviceState   enGetActCDDeviceState   ( tVoid ) const;
   tBool             bIsCDDriveMounted       ( tVoid ) const;
   tVoid             vSetCdTypeBeforeEject   ( T_e8_CdType e8NewCDTypeBeforeEject );
   tVoid             vSetUniqueID            (const tChar* szcMediaID);
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE

   tVoid vSendCdDriveErrorInformation        ( mplay_fi_tcl_e16_DriveErrorValue::tenType e16ErrorValue );

   trMessageDataForMethodResult              _MessageDataForMethodResultDiagDrvTest;
   trMessageDataForMethodResult              _MessageDataForMethodResultDiagEject;
   trMessageDataForMethodResult              _MsgDataMethResDiagSelectTrType;
   trMessageDataForMethodResult              _MessageDataForGetFirstCdTemp;

   //---------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tVoid vCloseDoorAutoInsert                ( tVoid );
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   DECLARE_MSG_MAP( vdmmgr_tclservice )
};

#endif //_VDMMGR_SERVICE_H_
