//-----------------------------------------------------------------------
//  FILE:         vdmmgr_msgtypes.h
//  PROJECT:      ARION Prototyp
//  SW-COMPONENT: Virtual Device Media Manager
// ----------------------------------------------------------------------
// 
//  DESCRIPTION: VD MediaManager
//               
// ----------------------------------------------------------------------
//  COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
//  HISTORY:      
//  Date      | Author             | Modification
//  08.07.05  | CM-DI/ESA2 Fiebing | initial version
//-----------------------------------------------------------------------
#ifndef _VDMMGR_MSGTYPES_H_
#define _VDMMGR_MSGTYPES_H_
#include "Config.h"


/******************************************************
**           Function Ids (Most Like)                 *
*******************************************************/
#define MMGR_C_U16_FKTID_INFO                               MPLAY_MMGRFI_C_U16_CDINFO                          //0x100
#define MMGR_C_U16_FKTID_CDTEMP                             MPLAY_MMGRFI_C_U16_CDTEMP                          //0xC25
#define MMGR_C_U16_FKTID_CDEJECT                            MPLAY_MMGRFI_C_U16_CDEJECT                         //0xC05
#define MMGR_C_U16_FKTID_CDINSERT                           MPLAY_MMGRFI_C_U16_CDINSERT                        //0xC06
#define MMGR_C_U16_FKTID_DRIVE_ERROR_INFORMATION            MPLAY_MMGRFI_C_U16_DRIVEERRORINFORMATION           //0xC10
#define MMGR_C_U16_FKTID_DIAGVERSIONFIRMWARE                MPLAY_MMGRFI_C_U16_DIAGFIRMWAREVERSION             //0xD00
#define MMGR_C_U16_FKTID_DIAGVERSIONDRIVE                   MPLAY_MMGRFI_C_U16_DIAGDRIVEVERSION                //0xD01
#define MMGR_C_U16_FKTID_DIAGLOADSTATUS                     MPLAY_MMGRFI_C_U16_DIAGLOADSTATUS                  //0xD02
#define MMGR_C_U16_FKTID_DIAGERRORSTATUS                    MPLAY_MMGRFI_C_U16_DIAGERRORSTATUS                 //0xD03
#define MMGR_C_U16_FKTID_DIAGDRIVETEST                      MPLAY_MMGRFI_C_U16_DIAGCONTROLDRIVETEST            //0xD20
#define MMGR_C_U16_FKTID_DIAGEJECT                          MPLAY_MMGRFI_C_U16_DIAGCONTROLEJECT                //0xD21
#define MMGR_C_U16_FKTID_DIAGPERFOMRTEST                    MPLAY_MMGRFI_C_U16_DIAGPERFORMTEST                 //0xD22
#define MMGR_MAX_FIRMWAREVERSIONLENGHT                      8
#define MMGR_MAX_DRIVEVERSIONLENGTH                         40

/*******************************************************************************
********************************************************************************
**                      Defines for client use                                **
********************************************************************************
*******************************************************************************/

/******************************************************
**           T_e8_CdType                              *
*******************************************************/
typedef enum
{
   MMGR_INIT                  = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_INIT,          //0,
   MMGR_NO_MEDIA              = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_NO_MEDIA,      //1,
   MMGR_INSERTION             = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_INSERTION,     //2,
   MMGR_INCORRECT             = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_INCORRECT,     //3,
   MMGR_AUDIO                 = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_AUDIO,         //4,
   MMGR_DATA                  = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_DATA,          //5,
   MMGR_EJECTING              = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_EJECTING,      //17,    // (CD)Media is ejecting
   MMGR_IN_SLOT               = mplay_fi_tcl_e8_CdType::FI_EN_MMGR_MEDIA_IN_SLOT  //18     // (CD)Media is in slot
} T_e8_CdType;

typedef enum
{
   MMGR_MEDIA_NOT_READY       = mplay_fi_tcl_e8_MediaState::FI_EN_MMGR_MEDIA_NOT_READY, //1,
   MMGR_MEDIA_READY           = mplay_fi_tcl_e8_MediaState::FI_EN_MMGR_MEDIA_READY      //2
} T_e8_CdState;

typedef enum
{
   MMGR_INSERT_BEFOREON       = mplay_fi_tcl_e8_InsertState::FI_EN_MMGR_INSERT_BEFOREON,// 1,
   MMGR_INSERT_AFTERON        = mplay_fi_tcl_e8_InsertState::FI_EN_MMGR_INSERT_AFTERON, //2,
   MMGR_INSERT_AUTOMATIC      = mplay_fi_tcl_e8_InsertState::FI_EN_MMGR_INSERT_AUTOMATIC//3
} T_e8_InsertState;

typedef enum
{
   MMGR_ACCEPTED              = mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_ACCEPTED,       //1,
   MMGR_NOTACCEPTED           = mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_NOTACCEPTED,    //2
   MMGR_DEVICENOTREADY        = mplay_fi_tcl_e8_MMgr_MethodResult::FI_EN_MMGR_DEVICENOTREADY  //3
} T_e8_MMgr_MethodResult;

typedef enum
{
   MMGR_DEVICE_NOT_READY      = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_NOT_READY,//0,
   MMGR_DEVICE_READY          = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_READY     //1
} T_e8DeviceState;

typedef enum
{
   DRIVE_INIT                    = mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_INIT,                         //0
   DRIVE_MOUNTED_OK              = mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_DRIVE_MOUNTED_OK,             //1
   DRIVE_MOUNTED_ERROR_READ_TEMP = mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_DRIVE_MOUNTED_ERROR_READ_TEMP,//2
   DRIVE_MOUNTED_NO_SENSOR       = mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_DRIVE_MOUNTED_NO_SENSOR,      //3
   DRIVE_NOT_MOUNTED             = mplay_fi_tcl_e8DriveTempSensorStatus::FI_EN_DRIVE_NOT_MOUNTED             //4
} T_e8DriveTempSensorStatus;

//Diagnosis 
typedef enum
{
   MMGR_CD                    = mplay_fi_tcl_e16_DiagDrv::FI_EN_MMGR_CD  // 1
} T_e16_DiagDrv;

typedef enum
{
   MMGR_START                 = mplay_fi_tcl_e16_DiagDrvTestCmd::FI_EN_MMGR_START,   //1,
   MMGR_STOP                  = mplay_fi_tcl_e16_DiagDrvTestCmd::FI_EN_MMGR_STOP,    //2,
   MMGR_CANCEL                = mplay_fi_tcl_e16_DiagDrvTestCmd::FI_EN_MMGR_CANCEL   //3
} T_e16_DiagDrvTestCmd;

typedef enum
{
   MMGR_SHORT                 = mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT,       //1,
   MMGR_INTENSIVE             = mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_INTENSIVE,   //2,
   MMGR_SHORT_TEF_CD          = mplay_fi_tcl_e16_DiagDrvTestParam::FI_EN_MMGR_SHORT_TEF_CD //3
} T_e16_DiagDrvTestParam;

typedef enum
{
   MMGR_EJECT_OK              = mplay_fi_tcl_e16_DiagResultEject::FI_EN_MMGR_EJECT_OK,     //1,
   MMGR_EJECT_FAILED          = mplay_fi_tcl_e16_DiagResultEject::FI_EN_MMGR_EJECT_FAILED  //2
} T_e16_DiagResultEject;

typedef enum
{
   MMGR_MEDIA_IN_SLOT         = mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_MEDIA_IN_SLOT,     //1,
   MMGR_NO_MEDIA_IN_DRIVE     = mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_NO_MEDIA_IN_DRIVE, //2,
   MMGR_MEDIA_INSIDE          = mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_MEDIA_INSIDE,      //3,
   MMGR_EJECT_IN_PROGRESS     = mplay_fi_tcl_e8_DiagLoadStatus::FI_EN_MMGR_EJECT_IN_PROGRESS  //5
} T_e8_DiagLoadStatus;

typedef enum
{
   MMGR_CONTINUOUS            = mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_CONTINUOUS, //0,  //mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_CONTINUOUS,
   MMGR_SINGLE_RUN            = mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_SINGLE_RUN  //1   //mplay_fi_tcl_e8_DiagDuration::FI_EN_MMGR_SINGLE_RUN
} T_e8_DiagDuration;

typedef enum
{
   MMGR_RESULT_FALSE          = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_FALSE,        //0,
   MMGR_RESULT_OK             = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_OK,           //1,
   MMGR_RESULT_NO_MEDIA       = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_NO_MEDIA,     //2,
   MMGR_RESULT_INVALID_MEDIA  = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_INVALID_MEDIA,//3,
   MMGR_RESULT_CANCELED       = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_CANCELED,     //4,
   MMGR_RESULT_BUSY           = mplay_fi_tcl_e8_DiagRetValueDriveTest::FI_EN_MMGR_RESULT_DEV_MMGR_BUSY //5
} T_e8_DiagRetValueDriveTest;

typedef enum
{
   MMGR_TestPassed            = mplay_fi_tcl_e16_DiagErrorStatus::FI_EN_MMGR_TESTPASSED,      //0,
   MMGR_TestFailed            = mplay_fi_tcl_e16_DiagErrorStatus::FI_EN_MMGR_TESTFAILED,      //1,
   MMGR_RoutineNeverRan       = mplay_fi_tcl_e16_DiagErrorStatus::FI_EN_MMGR_ROUTINENEVERRAN  //2
} T_e16_DiagErrorStatus;

typedef enum
{
   MMGR_RoutineNotRunning     = mplay_fi_tcl_e16_DiagRoutineStatus::FI_EN_MMGR_ROUTINENOTRUNNING,//0,
   MMGR_RoutineRunningRunning = mplay_fi_tcl_e16_DiagRoutineStatus::FI_EN_MMGR_ROUTINERUNNING,   //1,
   MMGR_RoutineFinished       = mplay_fi_tcl_e16_DiagRoutineStatus::FI_EN_MMGR_ROUTINEFINISHED   //2
} T_e16_DiagRoutineStatus;

typedef enum
{
   INIT                       = mplay_fi_tcl_e8_TrackType::FI_EN_INIT,   //0
   AUDIO                      = mplay_fi_tcl_e8_TrackType::FI_EN_AUDIO,  //1
   DATA                       = mplay_fi_tcl_e8_TrackType::FI_EN_DATA,   //2
   NONE                       = mplay_fi_tcl_e8_TrackType::FI_EN_NONE,   //3
   INVALID                    = mplay_fi_tcl_e8_TrackType::FI_EN_INVALID //4
} T_e8_TrackType;

typedef enum
{
   OK                         = mplay_fi_tcl_e8_TrackTypeResult::FI_EN_OK,                       //0
   NO_CD                      = mplay_fi_tcl_e8_TrackTypeResult::FI_EN_NOCD,                     //1
   INCORRECT_MEDIA            = mplay_fi_tcl_e8_TrackTypeResult::FI_EN_INCORRECTMEDIA,           //2
   FAILED_TO_SELECT           = mplay_fi_tcl_e8_TrackTypeResult::FI_EN_FAILEDTOSELECT,           //3
   INVALID_REQUESTED_TRACKTYPE= mplay_fi_tcl_e8_TrackTypeResult::FI_EN_INVALIDREQUESTEDTRACKTYPE,//4
   GENERAL_ERROR              = mplay_fi_tcl_e8_TrackTypeResult::FI_EN_GENERALERROR              //5
} T_e16_TrackTypeResult;

// structs
typedef struct
{
   T_e16_DiagDrv              e16Drive;
   T_e16_DiagDrvTestCmd       e16DriveTestCmd;
   T_e16_DiagDrvTestParam     e16DriveTestParam;
} T_DiagDrvTestParameter;

typedef struct
{
   T_e8_DiagRetValueDriveTest e8RetValueDriveTest;
   T_e16_DiagDrvTestParam     e16DiagDrvTesttype;
   T_e16_DiagDrv              e16Drive;
   tU32                       u32SectorsRead;
   tU16                       u16ReadAttempts;
   tU16                       u16CntErrors;
   tU16                       u16AverageReadtimeSector;
   tU32                       u32TotalReadTime;
   tU16                       u16MaxReadTimePerSector;
   tU32                       u32MaxLBA;
   tU8                        u8CntDVDLayer;
} T_DiagMethodResultDrvTest;

typedef struct
{
   T_e16_DiagDrv e16Drive;
} T_DiagEjectParam;


typedef struct
{
   T_e16_DiagResultEject e16Result;
} T_DiagMethodResultEject;


typedef struct
{
   T_e8_DiagDuration          e8Duration;
   T_DiagDrvTestParameter     StartDriveTestParam;
} T_DiagMethodControlStartDriveTest;            // internal VD MMGR only!

typedef struct
{
   T_e8_DiagDuration          e8Duration;
   T_DiagMethodResultDrvTest  ResultDriveTest;
} T_DiagMethodControlResultDriveTest;           // internal VD MMGR only!

typedef struct
{
   T_e8_DiagDuration          e8Duration;
   T_DiagEjectParam           StartEjectParam;
} T_DiagMethodControlStartEject;                // internal VD MMGR only!

typedef struct
{
   T_e8_DiagDuration          e8Duration;
   T_DiagMethodResultEject    ResultEject;
} T_DiagMethodControlResultEject;               // internal VD MMGR only!

typedef struct
{
  tU8                         au8FirmwareVersion[ MMGR_MAX_FIRMWAREVERSIONLENGHT ];

} T_DiagFirmwareVersion;


typedef struct
{
  tU8                         au8DriveVersion[ MMGR_MAX_DRIVEVERSIONLENGTH ];

} T_DiagDriveVersion;

#endif // _VDMMGR_MSGTYPES_H_
