/******************************************************************************
* FILE:         vdmmgr_main.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Media Manager
*------------------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*------------------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.05.05  | CM-DI/ESA2 Fiebing | initial version
*
*******************************************************************************/

#ifndef _VDMMGR_MAIN_H_
#define _VDMMGR_MAIN_H_

#include "Config.h"

#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
#define VDMMGR_FUNCARRAY_SIZE    30      // To be checked continuously -> greater than number of FIDs of VD MMgr

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define VDMMGR_NOTTABLE_SEM_NAME      "VDMMGR_NOTTABLESEM"

class vdmmgr_tclservice;               //lint !e763 Info 763;Redundant declaration for symbol 'x'
class vdmmgr_tclclienthandlerspm;      //lint !e763 Info 763;Redundant declaration for symbol 'x'
class vdmmgr_tclclienthandlerdiaglog;
class vdmmgr_tclcdctrlif;
class vdmmgr_tclerrorif;
class vdmmgr_tclTrace;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdmmgr_tclApp : public ail_tclAppInterface
{
private:
   // private functions
   vdmmgr_tclApp& operator=(const vdmmgr_tclApp& c); //this function must not be used, therefore it is private
   //this function must not be used, therefore it is private
   vdmmgr_tclApp(const vdmmgr_tclApp& c);//lint !e1704 Info 1704;Constructor 'vdmmgr_tclApp::vdmmgr_tclApp(const vdmmgr_tclApp &)' has private access specification

   // private data
   static vdmmgr_tclApp*   _vdmmgr_poExemplar;          // pointer to myself
   static vdmmgr_tclApp*   _theServer;
   static tBool            _bAppClosed;

public:
   // ---   messages handler for messages form a client to this server   ---
   vdmmgr_tclservice*               _vdmmgr_poCCAService;
   // ---   messages handler for messages form another server to this appliction ( client part )   ---
   vdmmgr_tclclienthandlerspm*      _vdmmgr_poCCAClienthandlerspm;      // Get information about insert clamps
   vdmmgr_tclclienthandlerdiaglog*  _vdmmgr_poCCAClienthandlerdiaglog;  // Give information to error/report memory
   vdmmgr_tclerrorif*               _vdmmgr_poErrorIf;                  // Interface funtions for error handling
   vdmmgr_tclcdctrlif*              _vdmmgr_poCdctrlIf;                 // Interface funtions for OSAL device CD control -> /dev/cdctrl1
   vdmmgr_tclTrace*                 _vdmmgr_poTraceHandler;             // Trace stuff

   static OSAL_tSemHandle           _hNotTableSem;
   ahl_tclNotificationTable*        _poNotTable;
   tU32                             _u32AppState;

   // method to create server object - called by SPM
   static vdmmgr_tclApp* theServer();

     /*!
    * \brief Get the  the singleton object - added that it looks like devicemanager
    */
   static vdmmgr_tclApp *GetInstance();
   
   
   /*!
    * \brief Destroys the singleton object
    */
   static void  DestroyInstance();
   
   
   vdmmgr_tclApp();              // constructor
   virtual ~vdmmgr_tclApp();     // destructor

   virtual tBool bOnInit             ();
   virtual tVoid vOnServiceState     ( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId );
   virtual tVoid vOnAsyncRegisterConf( tU16 u16RegisterId, tU16 u16ServerAppId,tU16 u16ServiceId, tU16 u16TargetSubId);
   virtual tVoid vOnNewAppState      ( tU32 u32OldAppState, tU32 u32AppState );
   virtual tVoid vOnNewMessage       ( amt_tclBaseMessage* poMessage );
   virtual tBool bOnWatchdog         ( );
   virtual tVoid vOnApplicationClose ( );

   inline vdmmgr_tclservice* u16GetDnlServiceHandler(){return _vdmmgr_poCCAService;};

   template< class T > void          vDeleteNoThrow( T*& rfpArg ) throw();

   // help function to send error messages
   tVoid vSendError( tU16 u16SourceID, tU16 u16TargetID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16Sid, tU16 u16Fid );
private:
   OSAL_tIODescriptor   _fdTrace;

   //TTfis command functions
   tVoid          vRegisterTraceService  ( );
   tVoid          vUnregisterTraceService( );
   static tVoid   vChannelMgr            ( tPUChar puchData );

protected:
   virtual tBool bGetServiceVersion( tU16 u16ServiceID, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion );
}; 

#endif // _VDMMGR_MAIN_H_
