/************************************************************************
* FILE:         vdmmgr_errorif.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.06.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_ERRORIF_H_
#define _VDMMGR_ERRORIF_H_

#include "Config.h"


#define VDMMGR_ERRORIF_REGPATH_THREAD_DATA           "APP_THREAD"
// VD MediaManager thread priority and thread stack name in registery
#define VDMMGR_ERRORIF_REGVALUE_THREAD_PRIO_NAME     "VDMMGR_ERRIF_PRIO"
#define VDMMGR_ERRORIF_REGVALUE_STACK_SIZE_NAME      "VDMMGR_ERRIF_STCK"

#define VDMMGR_ERRORIF_THREADNAME            "Mmgr_Err"              // Default Thread name
#define VDMMGR_ERRORIF_DEFAULT_STACKSIZE     10000                   // Default stacksize
#define VDMMGR_ERRORIF_DEFAULT_PRIO          145                     // Magic priority for worker threads -> given by architect
#define VDMMGR_ERRORIF_EVENTNAME             "vdmmgr_PrcEventError"

// Defines for events from callback function to thread
#define VDMMGR_ERRORIF_EVENT_MASK_DEFECT_CD        (tU16)0x0010      // Event defect: DEFECT_LOAD_EJECT, LOAD_INSERT, DISCTOC...

#define VDMMGR_ERRORIF_CDFCT        1

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdmmgr_tclerrorif
{
   private:
      // Private variables
      tBool                      _bThreadStarted;        // Indicates 'Thread is running'
      OSAL_tIODescriptor         _hDevice;               // OSAL handle for dev/cdctrl1
      tBool                      _bTerminate;            // Flag: soll der Thread beendet werden?
      OSAL_tThreadID             _tThreadID;             // 
      OSAL_tEventHandle          _hEvent;                // Event handle 
      vdmmgr_tclApp*             _poMainApp;             // Pointer to main app
      // Private static variables
      static tU16                _u16CdDefect;
      static vdmmgr_tclerrorif*  _poInstance;
      // Private functions
      // constructor 
      vdmmgr_tclerrorif                ( vdmmgr_tclApp* poVdmmgrMain );//lint !e1704 Constructor 'vdmmgr_tclcdctrlif::vdmmgr_tclerrorif(void)' has private access specification
      vdmmgr_tclerrorif                ( tVoid );//lint !e1704 Constructor 'vdmmgr_tclcdctrlif::vdmmgr_tclerrorif(void)' has private access specification
      // Functions in thread
      tBool bCreateThread              ( tVoid );
      tVoid vExecute                   ( tVoid );
      tVoid vHandleEvent               ( OSAL_tEventMask rEventMask ) const;
      tVoid vHandleDefectCd            ( tVoid ) const;
      static OSAL_tpfThreadEntry    dwThreadProc( tPVoid pvArg );
      static tVoid                  vCallbackFct( tPU32 pu32Data );
   public:
      // public functions:
      static vdmmgr_tclerrorif*  poGetInstance( vdmmgr_tclApp* poVdmmgrMain );
      static vdmmgr_tclerrorif*  poGetInstance( tVoid );
      tVoid                      vStartThread ( tVoid );
      // Destructor
      ~vdmmgr_tclerrorif                     ( tVoid );
      // Activate / deactivate thread
      tVoid vActivateSrc                     ( tVoid );
      tVoid vDeActivateSrc                   ( tVoid ) const;

      tVoid    vSendDefectEvent              ( OSAL_tEventMask u32DefectEvent, tU16 u16DefectData ) const;
      tVoid    vSetDefectCdForSimulation     ( tU16 u16Defect ) const;
};
#endif //_VDMMGR_ERRORIF_H_
