/************************************************************************
* FILE:         vdmmgr_clienthandlerspm.h
* PROJECT:      ARION Prototype
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.06.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_CLIENT_HANDLERSPM_H_
#define _VDMMGR_CLIENT_HANDLERSPM_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vdmmgr_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

//service id
#define VDMMGR_C_U16_SERVICE_SPM_MAJOR_VERSION 1 
#define VDMMGR_C_U16_SERVICE_SPM_MINOR_VERSION 0

#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER
   #define VDMMGR_CLIENTSPM_WAITTIME_GETLOADERSTATE   1400  // introduced for MASCA (500ms). For PIONEER drive (firmware 0xA) changes to 1.4s (with firmware 0x5 1.2s was sufficient...)
#else
   #define VDMMGR_CLIENTSPM_WAITTIME_GETLOADERSTATE   500   // introduced for MASCA drives
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE_PIONEER

#define VDMMGR_CLIENTSPM_THREADNAME          "Mmgr_GPIO"             // Default Thread name
#define VDMMGR_CLIENTSPM_DEFAULT_STACKSIZE   10000                   // Default stacksize
#define VDMMGR_CLIENTSPM_DEFAULT_PRIO        145                     // Magic priority for worker threads -> given by architect
#define VDMMGR_CLIENTSPM_EVENTNAME           "vdmmgr_EventGPIO"

// Defines for events from callback function to thread
#define VDMMGR_CLIENTSPM_EVENT_MASK_CD_DRIVE_INSERT_CLAMPS  (tU16)0x0010   // Event to indicate a change at GPIO for insert clamps

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
// ---  the application has one client message handler for each service ---
class vdmmgr_tclclienthandlerspm : public ahl_tclBaseWork
{
private:
   vdmmgr_tclApp*            poMain;

   // ---   to store the RegID of the service    ---
   tU16     _u16RegID;
   tBool    _bFidReg;
   // Asynchronous registration for Service has started
   tBool    _bRegAsyncStarted;
   tBool    _bMediaInSlot;
   tBool    _bInsertClampsActive;
   OSAL_tThreadID             _ThreadID;  //! thread ID for GPIO thread -> insert clamps
   static OSAL_tEventHandle   _hEvent;    // Event handle
   #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tBool    _bFirstSystemStatusAfterRegForFID;
   tBool    _bBackGrdActive;
   #endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE

   //---------------------------------------------------------------------
   tBool bRegisterForService();
   //---------------------------------------------------------------------
   tBool bUnregisterForService();
   //---------------------------------------------------------------------
   tBool bRegisterForFID(tU16 u16FID);
   //---------------------------------------------------------------------
   tBool bUnregisterForFID(tU16 u16FID);
   //---------------------------------------------------------------------
   tBool bSendGetForFID(tU16 u16FID);
   //---------------------------------------------------------------------
   vdmmgr_tclclienthandlerspm();//lint !e1704 ;Constructor 'vdmmgr_tclclienthandlerspm::vdmmgr_tclclienthandlerspm(void)' has private access specification
   //---------------------------------------------------------------------
   static tVoid vSendEventToCdCtrlThread( tU32 u32Event );

   // GPIO handling (Insert clamps)
   tBool bInstallGpioCallback       ( OSAL_tGPIODevID Gpio, OSAL_tpfGPIOCallback pvCallback, tVoid* pvArg = NULL, tU16 u16TriggerLevel=OSAL_GPIO_EDGE_BOTH ) const;
   static tVoid vCallbackGPIOHdl    ( tVoid* pvArg );
   static tVoid vGPIOThread         ( tVoid* pvArg );
   tVoid vHandleEvent               ( OSAL_tEventMask rEventMask );
   tVoid vHandleInsertClampsGPIO    ( );
   tVoid vInsertClampsActive        ( );
   tVoid vInsertClampsInactive      ( );

protected:
   //---------------------------------------------------------------------
   virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
   //---------------------------------------------------------------------

public:

   //---------------------------------------------------------------------
   vdmmgr_tclclienthandlerspm (vdmmgr_tclApp* poMain); // constructor
   ~vdmmgr_tclclienthandlerspm( tVoid );               // Destructor
   //---------------------------------------------------------------------
   tVoid vOnNewAppState       ( tU32 u32OldAppState, tU32 u32AppState );
   //---------------------------------------------------------------------
   tVoid vOnAsyncRegisterConf ( tU16 u16RegisterId, tU16 u16ServerAppId,tU16 u16ServiceId, tU16 u16TargetSubId );
   //---------------------------------------------------------------------
   tBool bIsMediaInSlot       ( tVoid ) const;
   tBool bInsertClampsActive  ( tVoid ) const;
   //---------------------------------------------------------------------
   tVoid vHandleSubStates     ( amt_tclServiceData* poMessage );
   tVoid vHandleSystemState   ( amt_tclServiceData* poMessage );
   //---------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   tBool bSetNewSPMSubState   ( tBool bSubStateData, cfc_fi_tcl_SPM_e32_SubStateType::tenType e32SubStateType = cfc_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS );
   //---------------------------------------------------------------------
   tBool bIsBackgrdActive     ( tVoid ) const;
#endif // #ifdef VARIANT_S_FTR_ENABLE_MMGR_CD_DRIVE
   //---------------------------------------------------------------------
   tVoid vHandleWakeUpReason  ( amt_tclServiceData* poMessage );
   //---------------------------------------------------------------------
   tVoid vHandleStartUpReason ( amt_tclServiceData* poMessage );
   //---------------------------------------------------------------------
   tVoid vOnServiceState      ( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId );
   //---------------------------------------------------------------------

   // +++   Enter your public Data and functions here   +++

   DECLARE_MSG_MAP(vdmmgr_tclclienthandlerspm)

};

#endif // _VDMMGR_CLIENT_HANDLERSPM_H_
