/************************************************************************
* FILE:         vdmmgr_cdctrlif.h
* PROJECT:      MIB2_ENTRY
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 27.06.05  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_CDCTRLIF_H_
#define _VDMMGR_CDCTRLIF_H_
#include "Config.h"
#include <pthread.h>

#define VDMMGR_CDCTRLIF_REGPATH_THREAD_DATA                    "APP_THREAD"
#define VDMMGR_CDCTRLIF_REGPATH_CONFIG_DATA                    "APP_CONFIG"

// VD MediaManager thread priority and thread stack name in registry
#define VDMMGR_CDCTRLIF_REGVALUE_THREAD_PRIO_NAME              "VDMMGR_DVDIF_PRIO"
#define VDMMGR_CDCTRLIF_REGVALUE_STACK_SIZE_NAME               "VDMMGR_DVDIF_STCK"

#define VDMMGR_CDCTRLIF_THREADNAME                             "Mmgr_CD"   // Default Thread name
#define VDMMGR_CDCTRLIF_DEFAULT_STACKSIZE                      10000       // Default stack size
#define VDMMGR_CDCTRLIF_DEFAULT_PRIO                           145         // Magic priority for worker threads -> given by architect
#define VDMMGR_CDCTRLIF_EVENTNAME                              "vdmmgr_PrcEventCD"
#define VDMMGR_CDCDTRLIF_MAXRETRY_EJECT                        8           // Max retries of CD eject (due to low voltage)
#define VDMMGR_CDCDTRLIF_WAITTIME_EJECT_RETRY                  5000        // Wait time between eject retries (due to low voltage)

// CD drive 
#define VDMMGR_CDCTRL_TIMEOUT_CD_DRIVE_TEMP                    60000       // timer timeout

// Defines for events from callback function to thread
#define VDMMGR_EVENT_MASK_MEDIA_CHANGE                         (tU32)0x00000001// Event media change: AUDIO_MEDIA,DATA_MEDIA, MEDIA_EJECTED...
#define VDMMGR_EVENT_MASK_TOTAL_FAILURE                        (tU32)0x00000002// Event total failure: DEVICE_OK, DEVICE_FAIL
#define VDMMGR_EVENT_MASK_MEDIA_STATE                          (tU32)0x00000008// Event media state changed: MEDIA_READY, MEDIA_NOT_READY
#define VDMMGR_EVENT_MASK_DEFECT                               (tU32)0x00000020// Event defect: DEFECT_LOAD_EJECT, LOAD_INSERT, DISCTOC...
#define VDMMGR_EVENT_MASK_CD_DEVICE_STATE                      (tU32)0x00000040// Event defect: OSAL_C_U16_DEVICE_NOT_READY, OSAL_C_U16_DEVICE_READY
#define VDMMGR_EVENT_MASK_CMD_EJECTCD                          (tU32)0x00000100// Event eject CD: eject CD started from the thread
#define VDMMGR_EVENT_MASK_CMD_AUTOREINSERTCD                   (tU32)0x00000200// Event automatic reinsert of media
#define VDMMGR_EVENT_MASK_CMD_DIAG_START_CDDRIVE_TEST          (tU32)0x00000400// Event start drive test: Trigger to start the drive test if it's not running actual
#define VDMMGR_EVENT_MASK_CD_TEMP_TIMEOUT                      (tU32)0x00000800// Event to indicate that a timeout to get CD drive temperature again occured
#define VDMMGR_EVENT_MASK_CD_GET_FIRST_TEMP                    (tU32)0x00001000// Event to indicate that the first CD drive temperature should be get and send
#define VDMMGR_EVENT_MASK_CMD_DIAG_CONTINUE_CD_DRV_SHORT_TEST  (tU32)0x00002000// Event to continue the  drive test with next.
#define VDMMGR_EVENT_MASK_CMD_DIAG_CONTINUE_CD_DRV_INT_TEST    (tU32)0x00004000// Event to continue the  drive test with next.
#define VDMMGR_EVENT_MASK_CMD_DIAG_SET_REQUESTED_TRACKTYPE     (tU32)0x00008000// Event to select a requested track type
// Defines media state (result of drive test) -> see also T_e8_DiagRetValueDriveTest
#define VDMMGR_DIAG_CD_MEDIA_OK                 1                          // Media OK for test
#define VDMMGR_DIAG_CD_MEDIA_NO                 MMGR_RESULT_NO_MEDIA       // No media inside the drive -> test isn't possible
#define VDMMGR_DIAG_CD_MEDIA_INVALID            MMGR_RESULT_INVALID_MEDIA  // Wrong media inside -> test isn't possible
// Defines for position in LBA array
#define VDMMGR_DIAG_CD_INNER_RIM                0                          // Inner rim
#define VDMMGR_DIAG_CD_MIDDLE                   1                          // Middle of CD
#define VDMMGR_DIAG_CD_OUTER_RIM                2                          // Outer rim
// Defines for diagnosis short read test.
#define VDMMGR_DIAG_CD_CNT_DIFF_LBA             3                          // Count different LBA for short test
#define VDMMGR_DIAG_CD_CNT_LBA_SHORT_TEST       7                          // Count read attempts for short test
#define VDMMGR_DIAG_CD_SHORT_TEST_CNT_LBA       1                          // Amount LBAs to test in short test
#define VDMMGR_DIAG_CD_MIN_LBA                  1                          // min. LBA for drive read test
// Defines for diagnosis short quality read test. The value are defined in:
// 'ToDo: write document title if possible'
#define VDMMGR_DIAG_CD_TEF_CD_MIN_LBA           200                        // Min LBA TEF CD test
#define VDMMGR_DIAG_CD_TEF_CD_MAX_LBA           245000                     // Max LBA TEF CD test
#define VDMMGR_DIAG_CD_TEF_CD_DATA_TRACK_NO     1                          // Track No. of data track on TEF mix mode test CD
#define VDMMGR_DIAG_CD_TEF_CD_AUDIO_TRACK_NO    2                          // Track No. of first audio track on TEF mix mode test CD

#define VDMMGR_DIAG_CD_WAIT_FOR_MOTOR_ON        2000                       // Wait time after SetMotorOn -> to sure drive is running
#define VDMMGR_CDCDTRLIF_WAITTIME_TRACKTYPE     500                        // Wait time after GetTrackInfo -> to wait till the new track is reached
#define VDMMGR_DIAG_CD_WAIT_CNT_TRACKTYPE       5                          // Wait count for selecting a different track type
// Defines for positions in LBA array for short test
#define VDMMGR_DIAG_CD_IMO_POS_0                0                          // 1. position in array
#define VDMMGR_DIAG_CD_IMO_POS_1                1                          // 2. position in array
#define VDMMGR_DIAG_CD_IMO_POS_2                2                          // 3. position in array
#define VDMMGR_DIAG_CD_IMO_POS_3                3                          // 4. position in array
#define VDMMGR_DIAG_CD_IMO_POS_4                4                          // 5. position in array
#define VDMMGR_DIAG_CD_IMO_POS_5                5                          // 6. position in array
#define VDMMGR_DIAG_CD_IMO_POS_6                6                          // 7. position in array
// Defines for read test
#define VDMMGR_DIAG_CD_INIT_PASS_CNT            0                          // Init value read attempts
#define VDMMGR_DIAG_CD_INIT_MAX_LBA             0L                         // Init value for max/last Logical Block Address
#define VDMMGR_DIAG_CD_INIT                     0                          // Init value
#define VDMMGR_DIAG_CD_RESULT_INIT              0                          // Init value for test result values (-> _DiagMethodResultDrvTest)
#define VDMMGR_DIAG_CD_SEC_PER_MIN              60                         // 60 seconds per minute
#define VDMMGR_DIAG_CD_FRAMES_PER_SEC           75                         // 75 frames per seconds
#define VDMMGR_DIAG_CD_LBA_MFS_OFFSET           2                          // Offset LBA to MFS (2s)
#define VDMMGR_DIAG_CD_SECURITY_OFFSET_END      3                          // driver has problems to read last LBA. Max.-2 works but -3 is more secure
#define VDMMGR_DIAG_CD_MAGIC_NUMBER             0xFF                       // Magic track for OSAL_C_S32_IOCTRL_CDCTRL_GETTRACKINFO to get (CD) MaxLBA via rTrackInfo.u32LBAAddress
// Defines for memory size for read test. The more memory the faster the read test
// and time requirements are very ambitious.
#define VDMMGR_DIAG_CD_WANTED_MEM_SIZE_MAX      10485760                    // 1024 KB +10 -> 10 MB

#define VDMMGR_DIAG_CD_WANTED_MEM_SIZE_MIN      2048                       // 2 KB -> min. memory size for read test
#define VDMMGR_DIAG_CD_LBA_SIZE                 2048                       // 2 KB -> size of Block
// Defines for read test command bit for _u32DiagDriveTestBitCmdField
#define VDMMGR_DIAG_CD_CMD_STOP_TEST            0x00000001                 // Stop read test (if continuous test is running)
#define VDMMGR_DIAG_CD_CMD_CANCEL_TEST          0x00000002                 // Cancel read test (as soon as the OSAL read function returns)
#define VDMMGR_DIAG_CD_CMD_START_SHORT          0x00000010                 // Start a short read test 7 read attempts at 3 different blocks
#define VDMMGR_DIAG_CD_CMD_START_INTENSIVE      0x00000020                 // Start a intensive read test (read whole CD)
#define VDMMGR_DIAG_CD_CMD_START_SHORT_TEF_CD   0x00000040                 // Start short TEF CD read test
#define VDMMGR_DIAG_CD_CMD_DUR_CONTINUOUS       0x00000100                 // Duration 'continuous' for read test
#define VDMMGR_DIAG_CD_CMD_DUR_SINGLE           0x00000200                 // Duration 'single' for read test
// Defines for read test status bits for _u32DiagDriveTestBitStatusField
#define VDMMGR_DIAG_CD_STATUS_TESTRUNING        0x00000001                 // Read test is running
#define VDMMGR_DIAG_CD_STATUS_TYPE_SHORT        0x00000010                 // Short read test is running
#define VDMMGR_DIAG_CD_STATUS_TYPE_INTENSIVE    0x00000020                 // Intensive read test is running
#define VDMMGR_DIAG_CD_STATUS_TYPE_SHORT_TEF_CD 0x00000040                 // Short TEF CD read test is running
#define VDMMGR_DIAG_CD_STATUS_DUR_CONTINUOUS    0x00000100                 // Read test runs with duration 'continuous'
#define VDMMGR_DIAG_CD_STATUS_DUR_SINGLE        0x00000200                 // Read test runs with duration 'single'
#define VDMMGR_DIAG_CD_STATUS_INIT_DONE         0x00001000                 // Marker if all necessary init stuff has been done
#define VDMMGR_DIAG_CD_STATUS_CANCEL_IN_PROGRESS 0x00002000                ///Marker if Cancel is in Progress, because Diagnosis expects a immediate method result after cancel or stop for CD Intensive tests.

// Define for error return value for function CDMGRS_bGetTemperature()
#define VDMMGR_CDCTRLIF_TEMP_NOT_SUPPORTED      0xFE                       // Temperature not supported from this drive. A Value not 0x00 or 0x32 to 0x5b
#define VDMMGR_CDCTRLIF_TEMP_TMP_NOT_AVAIL      0xFF                       // Temperature temporary not available. A Value not 0x00 or 0x32 to 0x5b

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class vdmmgr_tclcdctrlif
{
   private:
      // Private variables
      tBool                      _bThreadStarted;           // Indicates 'Thread is running'
      OSAL_tIODescriptor         _hDevice;                  // OSAL handle for dev/cdctrl1
      tBool                      _bTerminate;               // Flag: <Terminate Thread?>
      OSAL_tThreadID             _tThreadID;                // 
      OSAL_tEventHandle          _hEvent;                   // Event handle 
      vdmmgr_tclApp*             _poMain;                   // Pointer to main application
      tBool                      _bEjectActive;             // Marker for active CD eject
      tBool                      _bCdReinsertActive;        // Marker for active CD reinsert
      tU32                       _u32DriveTestStartLBA;
      tU8                        _u8DriveTestCntReadData;
      tBool                      _bFirstCdTypeValueArrived;
      T_e8_TrackType             _e8ReqTrackType;           // Requested track type for switching between Audio and Data on MixMode CD during TEF
      // Private static variables
      static tU16                _u16TotalFailure;
      static tU16                _u16MediaChange;
      static tU16                _u16ModeChange;
      static tU16                _u16MediaState;
      static tU16                _u16Defect;
      static tU16                _u16DeviceState;
      static tBool               _bLowVoltageDuringEject;
      static tU8                 _u8CDEjectLowVoltageRetryCnt;
      static vdmmgr_tclcdctrlif* _poInstance;
      // Variables for diagnosis
      tS8*                       _ps8DiagReadMem;
      tU32                       _u32DiagMaxLBA;                              // max / last LBA
      tU16                       _u16DiagMaxBlocksPerReadAttempt;             // max
      tU32                       _au32DiagLBA_IMO[VDMMGR_DIAG_CD_CNT_DIFF_LBA];
      tU32                       _au32DiagLBA_IMO_TEF_CD[VDMMGR_DIAG_CD_CNT_DIFF_LBA];
      tU32                       _au8DiagOrderShortTest[VDMMGR_DIAG_CD_CNT_LBA_SHORT_TEST];
      T_DiagMethodResultDrvTest  _DiagMethodResultDrvTest;
      tU32                       _u32DiagDriveTestBitCmdField;
      tU32                       _u32DiagDriveTestBitStatusField;
      // Private functions
      // constructor 
      vdmmgr_tclcdctrlif               ( vdmmgr_tclApp* poVdmmgrMain );//lint !e1704 Constructor 'vdmmgr_tclcdctrlif::vdmmgr_tclcdctrlif(void)' has private access specification
      vdmmgr_tclcdctrlif               ( tVoid );//lint !e1704 Constructor 'vdmmgr_tclcdctrlif::vdmmgr_tclcdctrlif(void)' has private access specification
      // Functions in thread
      tBool bCreateThread              ( tVoid );
      tVoid vExecute                   ( tVoid );
      tVoid vHandleEvent               ( OSAL_tEventMask rEventMask );
      tVoid vHandleTotalFailure        ( tVoid ) const;
      tVoid vHandleMediaChange         ( tVoid );
      tVoid vHandleMediaState          ( tVoid );
      tVoid vHandleModeChange          ( tVoid ) const;
      tVoid vHandleDeviceState         ( tVoid ) const;
      tVoid vHandleCommandEject        ( tVoid );
      tVoid vHandleCommandAutoReinsert ( tVoid ) const;
      tVoid vHandleTimeOutToGetTemp    ( tVoid );
      tVoid vHandleFirstGetTemp        ( tVoid );
      static OSAL_tpfThreadEntry    dwThreadProc( tPVoid pvArg );
      static tVoid                  vCallbackFct( tPU32 pu32Data );
      pthread_mutex_t mLock;
      void bEjectSet(tBool status);
      void bEjectGet(tBool &status);
      tBool                                     _bEjectTimerStart;      // flag to set 
   public:
      // public variables
      vdmmgr_tclTimer            _oPollCdDriveTempTimer;  // timer to poll CD drive temperature
      // public functions:
      static vdmmgr_tclcdctrlif* poGetInstance( vdmmgr_tclApp* poVdmmgrMain );
      static vdmmgr_tclcdctrlif* poGetInstance( tVoid );
      tVoid                      vStartThread ( tVoid );
      // Destructor
      ~vdmmgr_tclcdctrlif( );
      // Activate / deactivate thread
      tVoid vActivateSrc();
      tVoid vDeActivateSrc();
      // Function for OSAL function calls. Access to OSAL device dev/cdctrl1
      tBool                bOpen                   ( tVoid );
      tBool                bClose                  ( tVoid );
      tBool                bRegNotification        ( tVoid );
      tVoid                vUnRegNotification      ( tVoid );
      tBool                bEject                  ( tVoid );
      tBool                bSetMotorOn             ( tVoid );
      tBool                bGetMediaInfo           ( tVoid );
      tBool                bCloseDoor              ( tVoid );
      T_e8_DiagLoadStatus  e8GetLoaderState        ( tVoid );
      tS16                 s16GetTemperature       ( T_e8DriveTempSensorStatus* pDriveTempSensorStatus );
      tBool                bGetDriveVersion        ( OSAL_trDriveVersion* prDriveVersion );
      tBool                bReadRawDataLBA         ( tU32 u32LBAAdress, tU32 u32CntLBA, tS8* ps8ReadBuf );
      tBool                bEjectInThread          ( tVoid ) const;
      tBool                bIsEjectActive          ( tVoid ) const;
      tVoid                vStartTemperatureTimeout( tVoid );
      tVoid                vStopTemperatureTimeout ( tVoid );
      tVoid                vSetCdReinsertActive    ( tBool bCdReinsertActive );
      tBool                bGetCdReinsertActive    ( tVoid ) const;

      // Functions for diagnosis
      tVoid    vDiagDriveTest                         ( const T_DiagMethodControlStartDriveTest* pDiagStartDriveTest );
      tVoid    vDiagStartDriveTest                    ( tVoid );
      tU8      u8DiagIsMediaTypeOkForDriveTest        ( tVoid );
      tBool    bDiagInitAllDriveTestParameters        ( tVoid );
      tVoid    vDiagInitDriveTestResultStruct         ( tVoid );
      tVoid    vDiagInitDriveTestResultStructOnError  ( tVoid );
      tVoid    vDiagResetDriveCmdStatusBitsOnError    ( tVoid );
      tU32     u32DiagGetMaxLBA                       ( tVoid ) const;
      tVoid    vDiagSetCmdDurationBit                 ( T_e8_DiagDuration e8Duration );
      tVoid    vDiagSetCmdTestTypeBit                 ( T_e16_DiagDrvTestParam e16DriveTestParam );
      tVoid    vDiagSelectTrackType                   ( T_e8_TrackType e8TrackType );
      T_e8_TrackType e8DiagGetActualTrackType         ( tVoid ) const;
      tVoid    vHandleDiagCommandStart                ( tVoid );
      tVoid    vHandleDiagDriveShortTestContinue      ( tVoid );
      tVoid    vHandleDiagDriveIntensiveTestContinue  ( tVoid );
      tVoid    vHandleDiagSelectTrackType             ( tVoid );
      tVoid    vDiagShortDriveTest                    ( tBool bFirstPass );
      tVoid    vDiagIntensiveDriveTest                ( tBool bFirstPass );
      tVoid    vDiagCalcNewActualResult               ( tU32 u32NewReadLBA, tU8 u8NewReadAttempts,
                                                        tBool bReadSuccess, OSAL_tMSecond MSecondReadTime );
      tVoid    vDiagCalcNewActualResultForMethodCancel( tVoid );
      tVoid    vDiagGetFirmwareVersion                ( T_DiagFirmwareVersion* pDiagFirmwareVersion );
      tVoid    vDiagGetDriveVersion                   ( T_DiagDriveVersion* pDiagDriveVersion );
      mplay_fi_tcl_DiagTestResult::tenType    e8DiagCDInterfaceTest( mplay_fi_tcl_e8_DiagnosisTestType::tenType e8TestInitiator,
                                                                    mplay_fi_tcl_e16_DiagTestType::tenType e16TestType );
      tU16     u16GetTotalFailure                     ( tVoid ) const;
      // Functions for trace input. -> Simulation of OSAL events from dev/ctrl1
      tVoid    vSetTotalFailureForSimulation    ( tU16 u16TotalFailure ) const;
      tVoid    vSetMediaChangeForSimulation     ( tU16 u16MediaChange ) const;
      tVoid    vSetMediaStateForSimulation      ( tU16 u16MediaState ) const;
      tVoid    vSetDefectForSimulation          ( tU16 u16Defect ) const;
      tVoid    vSetDeviceStateForSimulation     ( tU16 u16DeviceState ) const;
      tVoid    vSetFirstCdTypeValueArrived      ( tBool  bArrived );
      tBool    vGetFirstCdTypeValueArrived      ( tVoid ) const;
      tVoid    vRestartHandleMediaChange        ( tVoid ) const;
      tVoid    vPrintCDState                    ( tVoid );
      tVoid    vSendEventToCdCtrlThread         ( tU32 u32Event ) const;
      tBool    bEjectOngoing;
      //---------------------------------------------------------------------
};
#endif //_VDMMGR_CDCTRLIF_H_
