/*-----------------------------------------------------------------------------*
 * VD_MediaManagerProcess.cpp                                                 *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_MediaManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_MediaManagerProcess.cpp
 *
 * \brief wrapps devmgr.out to get it running as a process
 *
 * \mainpage VD_MediaManager process
 *
 * \version 16.03.2012, Koechling, Christian (Bosch), Initial Version - to
 *          enable recreate in build process for VD_DVM-files only
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

//-----------------------------------------------
//error check dependencies and stop compilation on error
//----------------------------------------------

//-----------------------------------------------------------

#if 0
#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_BASICS
#include "common/Common.h"








#define EVENT_SHUTDOWN_NAME "SHUTDOWN_VD_MediaManager"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#ifdef VARIANT_S_FTR_DEVMGR_LINK_INTERFACE_CCADBUS
#include "service/VD_MediaManager_service_DBus.h"
#endif

#endif
#include "Config.h"


#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"




#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "vdmmgr/vdmmgr_main.h"



#define EVENT_SHUTDOWN_NAME "SHUTDOWN_VD_MediaManager"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"


#include "vdmmgr/vdmmgr_trace.h"
#define _CLASS  VDMMGR_TR_MAIN
#define TRACE_ALWAYS(szString)         \
      et_vTraceBinary                                    \
      (                                                  \
         _CLASS,                                         \
         (tU16) TR_LEVEL_FATAL,                          \
         ET_EN_T16 _ VDMMGR_TR_9B _                      \
         ET_EN_T16 _ __LINE__ _                          \
         ET_EN_STRING _  szString _                      \
         ET_EN_DONE                                      \
      )



extern "C" OSAL_DECL tS32 vStartApp(tS32 /*cPar*/, tString /*aPar[]*/)
{
    tS32 bRetVal = OSAL_OK;
    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;

    et_vTraceOpen();
    et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START VD_MEDIAMANAGRER");
    scd_init();

    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        //ETG_TRACE_ERR(("vd_devicemanager_tclApp: Creation of SPM shutdown event failed!!!"));
        NORMAL_M_ASSERT_ALWAYS();
    }

    // Activate Exception Handling
    /*bRetVal = exh_bInitExceptionHandling();
    if (TRUE != bRetVal)
    {
        //ETG_TRACE_ERR(("vd_devicemanager_tclApp: exh_bInitExceptionHandling failed"));
        NORMAL_M_ASSERT_ALWAYS();
    }*/
    //May be used for future reference
    //OSAL_tProcessID pId = OSAL_ProcessWhoAmI();

#ifdef VARIANT_S_FTR_ENABLE_PROCESS_READS_ITS_REGISTRY
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        //have to care that ipk installs this registry with mediaplayer packet
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t) "/dev/root/opt/bosch/base/registry/vd_mediamanager.reg")) == OSAL_OK)
        {
            TRACE_ALWAYS("[OK]  REGISTRY loaded: /dev/root/opt/bosch/base/registry/vd_mediamanager.reg");
        }
        else
        {
            TRACE_ALWAYS("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_mediamanager.reg");
            NORMAL_M_ASSERT_ALWAYS();
            //ETG_TRACE_ERRMEM(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_mediamanager.reg"));
        }
    }
    OSAL_s32IOClose(regHandle);

#endif

//-----------------------------------------------------------------------------------------
// Alternative: CCA based vdmmgr
//-----------------------------------------------------------------------------------------

    vdmmgr_tclApp *poVdMediaManagerApp = vdmmgr_tclApp::GetInstance();

    if (NULL != poVdMediaManagerApp)
    {
        if (!poVdMediaManagerApp->bInitInstance(0, CCA_C_U16_APP_MMGR))
        {
            //poVdMediaManagerApp->bInitInstance() failed!!!
            NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            //poVdMediaManagerApp->bInitInstance() success!"
        }
    }
    else
    {
         NORMAL_M_ASSERT_ALWAYS();
    }

    // Wait for Shutdown-Signal
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                     OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (NULL != poVdMediaManagerApp)
    {
        poVdMediaManagerApp->vDeinitInstance();
        //DEL_M(poVdMediaManagerApp);
        vdmmgr_tclApp::DestroyInstance();

    }

    //Prozess: Exiting...
    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
    et_vTraceClose();
    return bRetVal;
}
#endif // VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

////////////////////////////////////////////////////////////////////////////////
// <EOF>

