/*-----------------------------------------------------------------------------*
 * IFConfigurationPersistent.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IFConfigurationPersistent.h
 *
 * \brief Implementation to open, read and close persistent configuration
 *
 * \version 05.03.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef INTERFACE_VOLTAGE_MANAGER_H
#define INTERFACE_VOLTAGE_MANAGER_H  

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IVoltageManager
 */

class IVoltageManager
{
    public:

        typedef enum 
        {
            eVolt_Undefined    = 0,
            eVolt_CriticalLow  = 1,
            eVolt_Low          = 2,
            eVolt_Operating    = 3,
            eVolt_High         = 4,
            eVolt_CriticalHigh = 5
        }tenSystemVoltage;
        

        /*!
         * \brief Destructor
         */
        virtual ~IVoltageManager(){};


              /*! 
            * \brief read system voltage 
            *        
            * \param [out] true: critical voltage e.g. below 6.5 depends on target
            *
            */
           virtual bool IsCriticalVoltage() = 0;


           /*! 
         * \brief read system voltage 
         *        
         * \param [out] tenSystemVoltage: eVolt_Undefined,eVolt_CriticalLow,eVolt_Low,eVolt_Operating,eVolt_High,eVolt_CriticalHigh
         *
         */
        virtual void vGetSystemVoltage(OUT tenSystemVoltage &f_eSystemVoltage){(void)f_eSystemVoltage;} 
           
             /*! 
           * \brief read system voltage 
           *        
           * \param [out] f_u32BoardVoltage_milliVolt: current available voltage in millivolt
           *
           */
        virtual void vGetBoardVoltage(OUT tU32 &f_u32BoardVoltage_milliVolt){(void)f_u32BoardVoltage_milliVolt;}

          /*! 
        * \brief vSendVoltageWarning to StateTable
        *        
        * \param [out]f_eU60_drop: Input parameter telling if there is critical voltage or not. traditional below 6Volt that's why the naming is chosen 
        *
        */
        virtual tVoid vSendVoltageWarning(IN tenSignalValue f_eU60_drop) const{(void)f_eU60_drop;}

};
// class IFConfigurationPersistent

#endif // IF_VOLTAGE_MANAGER_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>

