/*-----------------------------------------------------------------------------*
 * IStorgeInfoProvider.h
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IStorageInfoProvider.h
 *
 * \brief new IStorageInfoProvider used to fetch the storage info to devices using a temporary thread
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 24.08.2016, Rajeev Narayanan Sambhu (RBEI/ECO3) (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __ISTORAGEINFOPROVIDER_H__
#define __ISTORAGEINFOPROVIDER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "Enums.h"
#include "Device.h"



/*-----------------------------------------------------------------------------*
 * Interface declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class IStorageInfoProvider
 *
 * \brief class used to fetch the storage info to devices using a temporary thread
 */

class IStorageInfoProvider
{

    public:


    /*!
         * \brief Destructor
         */
    virtual ~IStorageInfoProvider(){};

    /**
    * This function request to fill the storage info of device
    *
    * @return void
    */

    virtual tVoid vGetSizeMSC(IN const CDevice &f_CurDevice) = 0;

    /**
    * This function  forwards the storage information to UdevManager
    *
    * @return void
    */

    virtual tVoid vUpdateStorageInfo(OUT CDevice f_CurDevice) = 0 ;

};



#endif // __ISTORAGEINFOPROVIDER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

