/*-----------------------------------------------------------------------------*
 * HUBHardwareSignalReader.h
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file HUBHardwareSignalReader.h
 *
 * \brief new HUBHardwareSignalReader used to continuously poll the Internal Hub ports to monitor the Over current of the ports
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 23.04.2015, Rajeev Narayanan Sambhu (RBEI/ECS1) (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __IHUBHARDWARESIGNALREADER_H__
#define __IHUBHARDWARESIGNALREADER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "Enums.h"
#include "Device.h"



/*-----------------------------------------------------------------------------*
 * Interface declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class HUBHardwareSignalReader
 *
 * \brief class to monitor the OC status of ports connected to Internal HUB
 */

class IHUBHardwareSignalReader
{

    public:


    /*!
         * \brief Destructor
         */
    virtual ~IHUBHardwareSignalReader(){};


    virtual tVoid getHWSignalAtPort(IN int iPortNum, OUT int &OC, OUT int &PPON) = 0;
    /**
    * This function fills the device speed into in each of USB port using the libusb communication
    *
    * @return void
    */

    virtual tVoid vgetDeviceSpeed() = 0;

    /**
    * This function fills the device speed into the array of structures
    *
    * @return void
    */
    virtual tVoid vFillDeviceSpeedinfo(OUT TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB]) = 0;

    /**
    * This function fills the device speed into of the usb port from the ttfis command
    *
    * @return void
    */
    virtual tVoid vsetDeviceSpeed(IN tenDevManagerUSBHost eUsb,IN tBool bIsDevicePresent,IN tBool b_DeviceSpeed) = 0;

};



#endif // __HUBHARDWARESIGNALREADER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

