/*-----------------------------------------------------------------------------*
 *IDeviceRecognized.h                                                                *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2015 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \fileIDeviceRecognized.h
 *
 * \brief Interface
 *
 * e.g. VD_DVM receives a CDROM mount via CCA-Interface from FC_DIAG. Mounts the CDROM (Mix mode) and triggers VD_DVM as ifplatform would have notified it
 *
 * \version Initial Version
 * \version 10.10.2011, Koechling, Christian (Bosch), added to serve unit test

 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2020
 */

#ifndef __INTERFACE_DEVICERECOGNIZER_H__
#define __INTERFACE_DEVICERECOGNIZER_H__


/*-----------------------------------------------------------------------------*
 * includes                                                                  *
 *-----------------------------------------------------------------------------*/

//bound to member variables
extern "C"
{
#include <libudev.h>

#include <errno.h>
#include <libusb-1.0/libusb.h>
#include <libmtp.h>

}


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*
 * forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/

class CDevice;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
 



/*!
 * \class PrmManager
 */
class IDeviceRecognizer
{
    public:

    
        /*!
         * \brief private destructor for singleton
         */
       virtual  ~IDeviceRecognizer(){};

       virtual int FillCurrDevice(INOUT CDevice& f_oCurDevice, IN GENSTRING f_cDevNode,IN struct udev_device *f_pBaseUSBDev,IN struct udev *f_pUdev) = 0;

       virtual int DetectDevice(CGlobalEnumerations::DETECTION_Type enDetectionType, CDevice* f_pCurDevice) = 0;



       //used as a helper to store member variable of UDevManager which are used and ajusted by DeviceRecognizer
       //if code has been refactored one has to check if UDEVManager still has to use such member variable which is also available in MemContainer
       //Pointer of MTP raw Devices
       LIBMTP_raw_device_t *m_pMTPRawdevices;
       
       //Number Of MTP Devices
       int m_iNumrawDevices;
       
       //MTP Error Number
       LIBMTP_error_number_t m_LIBMTP_Error;
      

};

#endif //__INTERFACE_DEVICERECOGNIZER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

