/*-----------------------------------------------------------------------------*
 * AutomounterAdapter.h                                                                    *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*! 
 * \file IAutomounterAdapter.h
 *
 * \brief  Interface to AutomounterAdapter.  
 *         
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 21.12.2015, Koechling, Christian (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __INTERFACE_AUTOMOUNTERADAPTER_H__
#define __INTERFACE_AUTOMOUNTERADAPTER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"


/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#define AUTOMOUNTER_NAMEOFFSET 14 /*in /tmp/.automounter/mounted_partitions_db/ e.g. parttiion_dev_sda1.info  appear i.e. part before sda1 has len=strlen("partition_dev_");*/
#define DIR_AUTOMOUNTER_SUFFIX                            ".info"
#define DIR_AUTOMOUNTER                                   "/tmp/.automounter/"
#define DIR_AUTOMOUNTER_MOUNTEDPARTITIONS_DB              DIR_AUTOMOUNTER "mounted_partitions_db/"
#define DIR_AUTOMOUNTER_MOUNTEDPARTITIONS_DB_FILENAMEBASE DIR_AUTOMOUNTER_MOUNTEDPARTITIONS_DB "partition_dev_"

#define DIR_AUTOMOUNTER_SUFFIX_LEN                        5 /*=strlen(DIR_AUTOMOUNTER_SUFFIX)*/
#define DIR_AUTOMOUNTER_MOUNTEDDEVICE_DB                  DIR_AUTOMOUNTER "device_db/"
#define DIR_AUTOMOUNTER_MOUNTEDDEVICE_DB_FILENAMEBASE     DIR_AUTOMOUNTER_MOUNTEDDEVICE_DB "device_dev_"



/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace std;

/*-----------------------------------------------------------------------------*
 * Forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/

//class CDevice;
/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/

class IAutomounterAdapter
{

    public:

        typedef enum tenResAutomounterAdapt_E{   //add to class without namespace helps to let ETG_CENNUM work
            enRES_OK                   = 0,
            enRES_ERROR_GENERAL        = 1
        }tenResIAutomounterAdapt_Type;

        virtual ~IAutomounterAdapter(){};

        virtual int Initialize(tVoid) = 0;


        virtual tenResIAutomounterAdapt_Type FillDevice(OUT CDevice& device, IN  std::string strPathfilename)=0;
        virtual tenResIAutomounterAdapt_Type GetExtractBlockDevName(OUT std::string &strDevName, IN std::string strAutomounterPartitionFileName) const = 0;


};

#endif // __INTERFACE_AUTOMOUNTERADAPTER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

