/*-----------------------------------------------------------------------------*
 * HUBHardwareSignalReader.h
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file HUBHardwareSignalReader.h
 *
 * \brief new HUBHardwareSignalReader used to continuously poll the Internal Hub ports to monitor the Over current of the ports
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 23.04.2015, Rajeev Narayanan Sambhu (RBEI/ECS1) (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __HUBHARDWARESIGNALREADER_H__
#define __HUBHARDWARESIGNALREADER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "Enums.h"
#include "Device.h"
#include "IHUBHardwareSignalReader.h"


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace std;
using namespace prmmgr;

/*-----------------------------------------------------------------------------*
 * Forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class HUBHardwareSignalReader
 *
 * \brief class to monitor the OC status of ports connected to Internal HUB
 */

class HUBHardwareSignalReader: public IHUBHardwareSignalReader,public TFThread
{

    public:

    typedef enum
    {
       eThread_HUBHardwareSignalReader = 0,
       eThread_Last       = 1
    }tenThreadFunction;





   /*!
         * \brief Constructor
         */
    HUBHardwareSignalReader();

    /*!
         * \brief Destructor
         */
    virtual ~HUBHardwareSignalReader();

    int Initialize(tVoid) ;


    /**
     * \brief Thread function -
     *
     * Thread to listen to autmounter notification i.e. if new devices are mounted this received within this thread
     * clientHandler_spm and timerExp
     */
    virtual tVoid vThreadFunction();


    
    virtual tVoid getHWSignalAtPort(IN int iPortNum, IN int &OC, IN int &PPON);

	/**
	* This function fills the device speed into in each of USB port using the libusb communication
	*
	* @return void
	*/
    virtual tVoid vgetDeviceSpeed();

	/**
	* This function fills the device speed into the array of structures
	*
	* @return void
	*/

    virtual tVoid vFillDeviceSpeedinfo(OUT TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB]);

    /**
	* This function fills the device speed into of the usb port from the ttfis command
	*
	* @return void
	*/
    virtual tVoid vsetDeviceSpeed(IN tenDevManagerUSBHost eUsb,IN tBool bIsDevicePresent,IN tBool b_DeviceSpeed);

    /**
    * This function derives from TFThread and starts a user function in a thread from the thread factory's thread pool.
    * After leaving while loop used thread is stopped and released for other users
    *
    * @return void
    */
    virtual void Do(int functionID, void *ptr);

    private:
    UsbPortState m_usbPortState[2];
    //to store the device info obtained from the libusb communication
    TelematicsBoxSpeedAndPortInfo m_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB];

  protected:


};



#endif // __HUBHARDWARESIGNALREADER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

