/*-----------------------------------------------------------------------------*
 * HUBHardwareSignalReader.cpp                                                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM Gen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file HUBHardwareSignalReader.cpp
 *
 * helper class to connect VD_Devicemanager to new automounter mechanism of Adit


 * \version Initial Version
 * \ Version 23.04.2015, Rajeev Narayanan Sambhu (RBEI/ECS1) (Bosch)
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"


#include "HUBHardwareSignalReader.h"
#include "config/ConfigurationManager.h"
#include "usbutils.h"
//linux headers
 #include <unistd.h>




/*-----------------------------------------------------------------------------*
* ETG Tracing                                                                 *
*-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_PRMMANAGER
#include "trcGenProj/Header/HUBHardwareSignalReader.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
* name spaces                                                                 *
*-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------*
* static variables of class                                                                 *
*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
HUBHardwareSignalReader::HUBHardwareSignalReader()
{

    m_usbPortState[0].u8OC = SIGNAL_UNDEF;
    m_usbPortState[0].u8PPON = SIGNAL_UNDEF;
    m_usbPortState[0].u8PortNr = SIGNAL_UNDEF;

    m_usbPortState[1].u8OC = SIGNAL_UNDEF;
    m_usbPortState[1].u8PPON = SIGNAL_UNDEF;
    m_usbPortState[1].u8PortNr = SIGNAL_UNDEF;

    for(tInt eUsb=(tInt)eUSB1;eUsb<ARRAYSIZEFORUSB;eUsb++)
    {
        m_TelematicsBoxSpeedAndPortInfo[eUsb].b_DeviceSpeed = FALSE;
        m_TelematicsBoxSpeedAndPortInfo[eUsb].eUsb = (statetbl::tenDevManagerUSBHost )eUsb;
        m_TelematicsBoxSpeedAndPortInfo[eUsb].bIsDevicePresent = FALSE;
    }

}
/*-----------------------------------------------------------------------------*
 * Destructor                                                                 *
 *-----------------------------------------------------------------------------*/
HUBHardwareSignalReader::~HUBHardwareSignalReader()
{
}




/*-----------------------------------------------------------------------------*
int HUBHardwareSignalReader::Initialize(tVoid)
 *-----------------------------------------------------------------------------*/
int HUBHardwareSignalReader::Initialize(tVoid)
{
    tS32 s32Result = OSAL_OK;

    tInt iThreadIndex = ThreadFactoryDVM::GetThreadFactory()->Do(IN this, (int)HUBHardwareSignalReader::eThread_HUBHardwareSignalReader, NULL);

    ETG_TRACE_COMP(("HUBHardwareSignalReader: iThreadIndex:%d",iThreadIndex));

    m_usbPortState[0].u8OC = SIGNAL_UNDEF;
    m_usbPortState[0].u8PPON = SIGNAL_UNDEF;
    m_usbPortState[0].u8PortNr = SIGNAL_UNDEF;

    m_usbPortState[1].u8OC = SIGNAL_UNDEF;
    m_usbPortState[1].u8PPON = SIGNAL_UNDEF;
    m_usbPortState[1].u8PortNr = SIGNAL_UNDEF;

    return s32Result;
}

void HUBHardwareSignalReader::vThreadFunction()
{
    ETG_TRACE_USR4(("Begin: vThreadFunction"));

    //Note: This part of the code taken from prm

    int ihubReaderTimeoutval = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_HUB_HWSIGNAL_MONITOR_INTERVAL);
    if(DVM_OFF != ihubReaderTimeoutval )
    {
        while(1)
        {
#if 0
            ETG_TRACE_USR4(("Begin: Fetch the hardware signals"));
            m_usbPortState[0].u8OC = SIGNAL_FALSE;
            m_usbPortState[0].u8PPON = SIGNAL_TRUE;
            m_usbPortState[0].u8PortNr = 2;

            m_usbPortState[1].u8OC = SIGNAL_FALSE;
            m_usbPortState[1].u8PPON = SIGNAL_UNDEF;
            m_usbPortState[1].u8PortNr = 3;
            ETG_TRACE_USR4(("End: Fetch the hardware signals"));
#endif
            vgetDeviceSpeed();
            //TODO add functionality to monitor the OC and PPON values of ports connected to internal HUB
            sleep(ihubReaderTimeoutval);
        }
    }
    ETG_TRACE_USR4(("End  : vThreadFunction"));
}

tVoid HUBHardwareSignalReader::getHWSignalAtPort(IN int iPortNum, OUT int &iOverCurrent, OUT int &iPPON)
{
    ETG_TRACE_USR4(("Begin: getHWSignalAtPort"));
    int dvmConfigValue1 = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_HWSIGNAL_SOURCE_USB2);
    int dvmConfigValue2 = ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_HWSIGNAL_SOURCE_USB3);

    if( DVM_HUBINTERNAL_USED == dvmConfigValue1 && iPortNum == m_usbPortState[0].u8PortNr )
    {
        iPPON = m_usbPortState[0].u8PPON;
        iOverCurrent = m_usbPortState[0].u8OC;
    }
    else if( DVM_HUBINTERNAL_USED == dvmConfigValue2 && iPortNum == m_usbPortState[1].u8PortNr)
    {
        iPPON = m_usbPortState[1].u8PPON;
        iOverCurrent = m_usbPortState[1].u8OC;
    }
    else
    {
        ETG_TRACE_USR4(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!getHWSignalAtPort invalid port !!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }
    ETG_TRACE_USR4(("End: getHWSignalAtPort"));

}


tVoid HUBHardwareSignalReader::vFillDeviceSpeedinfo(OUT TelematicsBoxSpeedAndPortInfo f_TelematicsBoxSpeedAndPortInfo[ARRAYSIZEFORUSB])
{
	ETG_TRACE_USR4(("Begin: FillDeviceSpeedinfo"));
	for(tInt eUsb=(tInt)eUSB1;eUsb<ARRAYSIZEFORUSB;eUsb++)
	{
		f_TelematicsBoxSpeedAndPortInfo[eUsb].b_DeviceSpeed = m_TelematicsBoxSpeedAndPortInfo[eUsb].b_DeviceSpeed;
		f_TelematicsBoxSpeedAndPortInfo[eUsb].eUsb = m_TelematicsBoxSpeedAndPortInfo[eUsb].eUsb;
		f_TelematicsBoxSpeedAndPortInfo[eUsb].bIsDevicePresent = m_TelematicsBoxSpeedAndPortInfo[eUsb].bIsDevicePresent;
	}
	ETG_TRACE_USR4(("End: FillDeviceSpeedinfo"));
}

tVoid HUBHardwareSignalReader::vgetDeviceSpeed()
{
	ETG_TRACE_USR4(("Begin: getDeviceSpeed"));
    for(tInt eUsb=(tInt)eUSB1;eUsb<ARRAYSIZEFORUSB;eUsb++)
    {
    	tBool l_bIsHighSpeedExpected;
		if(TRUE == ConfigurationManager::GetInstance()->bFilterTelematicsBoxExpectedAtConnector((tenDevManagerUSBHost)eUsb))
		{
			tBool l_bIsDevicePresent = FALSE;
			tBool l_bDeviceSpeed = bIsDeviceAtFullSpeed((tenDevManagerUSBHost)eUsb,l_bIsDevicePresent);
			ETG_TRACE_USR4(("getDeviceSpeed: TelematicsBoxSpeed l_bDeviceSpeed %d",l_bDeviceSpeed));


			m_TelematicsBoxSpeedAndPortInfo[eUsb].b_DeviceSpeed = l_bDeviceSpeed;
			m_TelematicsBoxSpeedAndPortInfo[eUsb].eUsb = (statetbl::tenDevManagerUSBHost )eUsb;
			m_TelematicsBoxSpeedAndPortInfo[eUsb].bIsDevicePresent = l_bIsDevicePresent;
		}

    }
    ETG_TRACE_USR4(("End: getDeviceSpeed"));

}

tVoid HUBHardwareSignalReader::vsetDeviceSpeed(IN tenDevManagerUSBHost eUsb,IN tBool bIsDevicePresent,IN tBool b_DeviceSpeed)
{
    ETG_TRACE_USR4(("Begin: vsetDeviceSpeed"));
    for(tInt u8USBNo=(tInt)eUSB1;u8USBNo<ARRAYSIZEFORUSB;u8USBNo++)
    {
		if(u8USBNo == eUsb)
        {
            ETG_TRACE_USR4(("vsetDeviceSpeed match found for %d",u8USBNo));
            m_TelematicsBoxSpeedAndPortInfo[u8USBNo].eUsb = eUsb;
            m_TelematicsBoxSpeedAndPortInfo[u8USBNo].bIsDevicePresent = bIsDevicePresent;
            m_TelematicsBoxSpeedAndPortInfo[u8USBNo].b_DeviceSpeed = b_DeviceSpeed;
        }
    }
	ETG_TRACE_USR4(("End: vsetDeviceSpeed"));
}

/*-----------------------------------------------------------------------------*
void HUBHardwareSignalReader::Do(...)
 *-----------------------------------------------------------------------------*/
tVoid HUBHardwareSignalReader::Do(int functionID, void *ptr)
{
    ETG_TRACE_USR4(("Begin:Do"));
    (void) ptr;
    tenThreadFunction eFunctionID = (tenThreadFunction)functionID;
    switch(eFunctionID)
    {
        case HUBHardwareSignalReader::eThread_HUBHardwareSignalReader: //execution tree for thread eThread_SystemVolt
            ThreadFactoryDVM::GetThreadFactory()->SetName("VD_DVM:eThread_HUBHardwareSignalReader");
            vThreadFunction();
            break;
        default:
            break;
    }
    ETG_TRACE_USR4(("End  :Do"));
}
////////////////////////////////////////////////////////////////////////////////
// <EOF>



