/*-----------------------------------------------------------------------------*
 * AutomounterAdapter.cpp                                                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM Gen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file AutomounterAdapter.cpp
 *
 * helper class to connect VD_Devicemanager to new automounter mechanism of Adit
 * This code  had access to text interface of automounter and shared lib interface before
 * different behaviour has been extracted into different classes. Behaviour can be injected now
 * In this manner GOF Decorator pattern has been used

 * \version Initial Version
 * \version 03.12.2013, Koechling, Christian (Bosch)
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2020
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"

#define INCLUDE_VD_DVM_OSAL
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#include <stdexcept>
#include <string>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <unistd.h>

#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"

#include "AutomounterAdaptSharedLibIF.h"
#include "AutomounterAdaptTextIF.h"
#include "AutomounterAdapter.h"
#include "config/ConfigurationManager.h"

#include <signal.h>
#include <sys/epoll.h>
#include <errno.h>
#include <poll.h>
//#include <sys/inotify.h>
//#include <unistd.h>


/*-----------------------------------------------------------------------------*
* ETG Tracing                                                                 *
*-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"
     
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_UDEVMANAGER
#include "trcGenProj/Header/AutomounterAdapter.cpp.trc.h"
#endif
#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
* name spaces                                                                 *
*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
* static variables of class                                                                 *
*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
AutomounterAdapter::AutomounterAdapter()
{
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF)) 
    {
        ETG_TRACE_COMP(("AutomounterAdapter: eCONF_ENABLE_AUTOMOUTNER_SHAREDLIBIF: ON"));
    }
    else
    {
        ETG_TRACE_COMP(("AutomounterAdapter: eCONF_ENABLE_AUTOMOUTNER_SHAREDLIBIF: OFF"));
    }

}
/*-----------------------------------------------------------------------------*
 * Destructor                                                                 *
 *-----------------------------------------------------------------------------*/
AutomounterAdapter::~AutomounterAdapter()
{

}
/*-----------------------------------------------------------------------------*
  * FillDevice  - Alternative based on shared lib callbacks                                                               *
  *-----------------------------------------------------------------------------*/
IAutomounterAdapter::tenResIAutomounterAdapt_Type AutomounterAdapter::FillDevice(OUT CDevice& f_device)
{
    ETG_TRACE_USR4(("Begin: FillDevice()"));
    IAutomounterAdapter::tenResIAutomounterAdapt_Type enResult =  enRES_ERROR_GENERAL;

    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF)) 
    {
         f_device.m_cMountPoint = "FillDevice: (SharedLibIF) tbd not yet implemented";
    }
    else
    {
        f_device.m_cMountPoint = "FillDevice: (TextIF) tbd not yet implemented";
    }

    ETG_TRACE_USR4(("End  : FillDevice()"));

    return enResult; //since it is not yet fully implemented
}

/*-----------------------------------------------------------------------------*
int AutomounterAdapter::FillDevice(...)
 *-----------------------------------------------------------------------------*/
IAutomounterAdapter::tenResIAutomounterAdapt_Type AutomounterAdapter::FillDevice(OUT CDevice& device, IN  std::string strPathfilename)
{
    ETG_TRACE_COMP(("Begin: AutomounterAdapter: FillDevice"));
    IAutomounterAdapter::tenResIAutomounterAdapt_Type   enRet = enRES_ERROR_GENERAL;

    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF)) 
    {
        ETG_TRACE_COMP(("AutomounterAdapter: FillDevice(...): Usage of AutomounterAdaptSharedLibF - not yet implemented"));
    }
    else
    {
        AutomounterAdaptTextIF::tenResAutomounterAdapt_Type enResult =  mAutomounterAdaptTextIF.FillDevice(OUT device, IN strPathfilename);
        ETG_TRACE_COMP(("AutomounterAdapter: FillDevice: enResult:%d",ETG_CENUM(AutomounterAdaptTextIF::tenResAutomounterAdapt_Type,enResult) ));
        if(enResult == AutomounterAdaptTextIF::enRES_OK)
        {
            enRet = IAutomounterAdapter::enRES_OK;
        }
    }
    ETG_TRACE_COMP(("End  : AutomounterAdapter: FillDevice: enRet:%d",ETG_CENUM(IAutomounterAdapter::tenResIAutomounterAdapt_Type,enRet) ));
    return enRet;
}

/*-----------------------------------------------------------------------------*
int AutomounterAdapter::GetExtractBlockDevName(...)
 *-----------------------------------------------------------------------------*/
IAutomounterAdapter::tenResIAutomounterAdapt_Type AutomounterAdapter::GetExtractBlockDevName(OUT std::string &strDevName, IN std::string strAutomounterPartitionFileName) const
{
    ETG_TRACE_COMP(("Begin: AutomounterAdapter: GetExtractBlockDevName"));

    IAutomounterAdapter::tenResIAutomounterAdapt_Type   enRet     = enRES_ERROR_GENERAL;

    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_AUTOMOUNTER_SHAREDLIBIF)) 
    {
        ETG_TRACE_COMP(("AutomounterAdapter: GetExtractBlockDevName: Usage of AutomounterAdaptSharedLibF - not yet implemented"));
    }
    else
    {
        AutomounterAdaptTextIF::tenResAutomounterAdapt_Type enResult =  mAutomounterAdaptTextIF.GetExtractBlockDevName(OUT strDevName, IN strAutomounterPartitionFileName);
        ETG_TRACE_COMP(("End  : AutomounterAdapter: GetExtractBlockDevName() : enResult:%d ",ETG_CENUM(AutomounterAdaptTextIF::tenResAutomounterAdapt_Type,enResult)));
        if(enResult == AutomounterAdaptTextIF::enRES_OK)
        {
           enRet = IAutomounterAdapter::enRES_OK;
        }
    }
   ETG_TRACE_COMP(("End  : AutomounterAdapter: GetExtractBlockDevName() : enResult:%d ",ETG_CENUM(IAutomounterAdapter::tenResIAutomounterAdapt_Type,enRet)));
   return enRet;
}

/*-----------------------------------------------------------------------------*
int AutomounterAdapter::Initialize(...)
 *-----------------------------------------------------------------------------*/
int AutomounterAdapter::Initialize(tVoid) 
{
    ETG_TRACE_COMP(("Begin: AutomounterAdapter: Initialize"));
    tS32 s32Result = OSAL_OK;

#ifdef USE_AUTMOUNTERSHAREDLIB_ENABLED
    s32Result = mAutomounterAdaptSharedLibIF.Initialize();
#endif

    ETG_TRACE_COMP(("End : AutomounterAdapter: Initialize"));
    return s32Result;
}



////////////////////////////////////////////////////////////////////////////////
// <EOF>



